<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>视频鉴定管理</title>
<meta name="decorator" content="default" />

	<link href="${ctxStatic}/layui_2/layui/css/layui.css" type="text/css" rel="stylesheet"/>
	<script src="${ctxStatic}/layui_2/layui/layui.all.js" type="text/javascript"></script>
	<style>
		.picDiv>div{
			width:33%;
		}
	</style>
	
<script type="text/javascript">

	$(document).ready(function() {
		//$("#name").focus();
		$("#inputForm").validate({
			submitHandler: function(form){
				loading('正在提交，请稍等...');
				form.submit();
			},
			errorContainer: "#messageBox",
			errorPlacement: function(error, element) {
				$("#messageBox").text("输入有误，请先更正。");
				if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
					error.appendTo(element.parent().parent());
				} else {
					error.insertAfter(element);
				}
			}
		});
		
		$("#dogBreed").change(function(){
			var dogBreed = $("#dogBreed").val();
			$.ajax({
				type: "POST",
				dataType:"json",
				url:"${ctx}/dogcolormark/dogColorMark/getByDogBreed?dogBreedCode="+dogBreed,
				async: false,
				error: function(request, textStatus, errorThrown) {

				},
				success: function(data) {
					var optionHtml = '';
					for (var i = 0; i < data.length; i++) {
						if(i == 0){
							optionHtml='<option selected= "selected" value = "'+ data[i].dogColorMarkCode +'" > '+ data[i].dogColorMarkCn+' </option>';
						}else{
							optionHtml+=' <option value = "'+ data[i].dogColorMarkCode +'" > '+ data[i].dogColorMarkCn+' </option>';
						}
					}
					$('#dogColor').html(optionHtml);
					$("#dogColor").select2();
				}
			});
		});
	});
	
	function viewImg(obj,tit){
		var img = new Image();  
        img.src = obj.src;
        var imgHtml = "<img src='" + obj.src + "' width='800px' height='900px'/>";  
        //弹出层
        layer.open({  
            type: 1,  
            shade: 0.8,
            offset: 'auto',
            area:['auto','auto'],
            shadeClose:true,
            scrollbar: false,
            title: tit, //不显示标题  
            content: imgHtml, //捕获的元素，注意：最好该指定的元素要存放在body最外层，否则可能被其它的相对元素所影响  
            cancel: function () {  
                //layer.msg('捕获就是从页面已经存在的元素上，包裹layer的结构', { time: 5000, icon: 6 });  
            }  
        }); 
	}
	
</script>
<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/dogvideoappraisal/">视频鉴定列表</a></li>
	</ul>
	<br />
	<form:form id="inputForm" modelAttribute="dogVideoAppraisal" action="${ctx}/dogvideoappraisal/editExamine" class="form-horizontal">
		<form:hidden path="id" />
		<sys:message content="${message}" />
		<form:hidden path="appraisalMember"/>		
		<div class="control-group" style="width: 100%;float: left; height: 190px">
		犬只信息:
		<div style="margin-top: 20px">
			<div class="control-group">
				<label class="control-label">犬只品种：</label>
				<div  class="controls">
	                <form:select id="dogBreed" path="dogBreed" class="input-xlarge required">
	                	<form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
	                </form:select>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">毛色：</label>
				<div id= "colorDiv" class="controls">
	                <form:select id="dogColor" path="dogColor" class="input-xlarge required">
	                	<form:options items="${colorList}" itemLabel="dogColorMarkCn" itemValue="dogColorMarkCode" htmlEscape="false"/>
	                </form:select>
				</div>				
			</div>
			<%-- <div class="control-group">
				<label class="control-label">犬只名称：</label>
				<div class="controls">
					${fns:escapeHtml(info.dogName)}</div>
			</div> --%>
			<div class="control-group">
				<label class="control-label">性别：</label>
				<div class="controls">
					${fns:escapeHtml(info.dogGenderDesc)}</div>
			</div>
			
			<div class="control-group">
				<label class="control-label">出生日期：</label>
				<div class="controls">
					<fmt:formatDate value="${info.dogBirth}"
						pattern="yyyy-MM-dd" />
				</div>
			</div>
			<%-- <div class="control-group">
				<label class="control-label">犬只主人：</label>
				<div class="controls">
					${fns:escapeHtml(info.memberName)}</div>
			</div>
			<div class="control-group">
				<label class="control-label">芯片号：</label>
				<div class="controls">
					<form:input path="chipNo" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
					<input class="btn btn-primary" type="button" value="生成护照号" onclick="createCabCode()"/>
				</div>
			</div>
			<div class="control-group">
				<label class="control-label">护照编号：</label>
				<div class="controls">
					<form:input path="passportNo" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
				</div>
			</div> --%>
		   </div>
		</div>
		
		<div  class="control-group" style="width: 100%;float: left; height: 190px">
			<label class="control-label">犬只图片：</label>
				<div class="controls">
					<c:forEach items="${info.imgs }" var = "list" varStatus = "status">
						<c:if test="${list.fileSort eq '1'}">
							<img style="width:180px; height: 190px" alt="犬只正面照片" style="max-width:200px;" class="layui-upload-img" onclick="viewImg(this,'犬只正面照片')" src="${ctx}/sys/file/image/${list.fildId}">
						</c:if>
						<c:if test="${list.fileSort eq '2'}">
							<img style="width:180px; height: 190px" alt="犬只左侧照片" style="max-width:200px;" class="layui-upload-img" onclick="viewImg(this,'犬只左侧照片')"  src="${ctx}/sys/file/image/${list.fildId}">
						</c:if>
						<c:if test="${list.fileSort eq '3'}">
							<img  style="width:180px; height: 190px" alt="犬只右侧照片" style="max-width:200px;" class="layui-upload-img" onclick="viewImg(this,'犬只右侧照片')"  src="${ctx}/sys/file/image/${list.fildId}">
						</c:if>
						<c:if test="${list.fileSort eq '4'}">
							<img  style="width:180px; height: 190px" alt="犬只背面照片" style="max-width:200px;" class="layui-upload-img" onclick="viewImg(this,'犬只背面照片')"  src="${ctx}/sys/file/image/${list.fildId}">
						</c:if>
						
					</c:forEach>
			 </div>
		</div>
		<div  class="control-group" style="width: 100%;float: left;">
			<label class="control-label">犬只视频：</label>
				<div class="controls" >
			<%-- <c:forEach items="${info.videos }" var = "list" varStatus = "status">
				<video width="480px" height="272px" src="${ctx}/sys/file/vod/${list.fildId}" controls="controls">
				</video>
			</c:forEach> --%>
			<video width="600px" height="400px" src="${info.vodUrl }" controls="controls">
				</video>
		   </div>
		</div>
		
		<div style="margin-top: 20px">
			<div class="control-group">
				<label class="control-label">鉴定人：</label>
				<div class="controls">
					${fns:escapeHtml(appraisalMember)}</div>
			</div>
			
			<div class="control-group">
				<label class="control-label">鉴定时间：</label>
				<div class="controls" id = "appraisalTime">
					${fns:escapeHtml(appraisalDate)} 
				</div>
			</div>
			
			<div class="control-group">
				<label class="control-label">鉴定结果：</label>
				<div class="controls">
					<form:select id="reviewState" path="reviewState" class="input-xlarge required">
	                	<form:options items="${reviewList}" itemLabel="label" itemValue="value" htmlEscape="false"/>
	                </form:select>
				</div>
			</div>
		</div>
		<div class="control-group">
				<label class="control-label">鉴定意见：</label>
				<div class="controls">
					<form:textarea path="reviewRemarks"/>
				</div>
		</div>
		

		<div class="form-actions">
			<shiro:hasPermission name="dogVideoAppraisal:edit">
				<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>
		   </shiro:hasPermission>
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)" />
		</div>
	</form:form>
</body>
</html>