<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>种犬申报管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        var index = parseInt("${dogSemenListSize}");
        $(document).ready(function () {
            //$("#name").focus();
            $("#inputForm").validate({
                submitHandler: function (form) {
                    var newaddArray = [];
                    var oldArray = [];
                    $(".newadd").each(function () {
                        newaddArray.push($(this).val());
                    });
                    $(".old").each(function () {
                        oldArray.push($(this).attr('name').replace("originalSemenCode", "") + "=" + $(this).val());
                    });
                    $("#newadd").val(newaddArray.toString());
                    $("#old").val(oldArray.toString());
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
            //下拉回显
            $("#reviewState").val("${dogFrozenSemen.reviewState}");
            $("#reviewState").trigger("change");
        });

        function changeReviewState() {
            var reviewState = $('#reviewState').val();
            if (reviewState == '1') {
                $("#semenDiv").show();
            } else if (reviewState == '0') {
                $("#semenDiv").hide();
            }
        }

        function delOne(object) {
            if (confirm('确认要删除吗？')) {
                $(object).parent().parent().remove();
            }
        }

        function addOne() {
            var html = '<tr><td>' +
                    '<input name="originalSemenCode' + index + '" value="" class="input-xxlarge required originalSemenCode newadd">' +
                    '</td><td></td><td><a href="#" onclick="delOne(this)">删除</a><a href="#" onclick="addOne()">添加一行</a></td><tr>';
            $("#tbody").after(html);
            index = index + 1;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/dogfrozensemen/dogFrozenSemen/list?businessType=0">种犬申报列表</a></li>
    <li class="active"><a href="${ctx}/dogfrozensemen/dogFrozenSemen/form?id=${dogFrozenSemen.id}">种犬申报编辑</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="dogFrozenSemen" action="${ctx}/dogfrozensemen/dogFrozenSemen/edit0"
           method="post" class="form-horizontal">
    <form:hidden path="id"/>
    <form:hidden path="newadd"/>
    <form:hidden path="old"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">血统证书号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.pedigreeCertifiedCode) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">芯片号码：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.identificationFlag) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬种：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.breedCnName) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬名：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.nameEn) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬主：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.dogOwner) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">犬主会员号：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.dog.memberCode) }
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">处理状态：</label>
        <div class="controls">
            <form:select id="reviewState" path="reviewState" class="input-medium" onchange="changeReviewState()">
                <option value="0">待采集</option>
                <option value="1">通过</option>
            </form:select>
        </div>
    </div>
    <div class="control-group" id="semenDiv">
        <label class="control-label">精子信息：</label>
        <div class="controls">
                ${fns:escapeHtml(dogFrozenSemen.semenNumber) }管
            <table class="table table-striped table-bordered table-condensed">
                <thead>
                <tr>
                    <th>原精子编号</th>
                    <th>CKU精子编号</th>
                    <th>操作</th>
                </tr>
                </thead>
                <tbody id="tbody">
                <c:forEach items="${dogSemenList}" var="dogSemen">
                <tr>
                    <td>
                        <input name="originalSemenCode${fns:escapeHtml(dogSemen.id) }"
                               value="${fns:escapeHtml(dogSemen.originalSemenCode) }"
                               class="input-xxlarge required originalSemenCode old">
                    </td>
                    <td>
                            ${fns:escapeHtml(dogSemen.semenCode) }
                    </td>
                    <td>
                        <a href="#" onclick="delOne(this)">删除</a>
                        <a href="#" onclick="addOne()">添加一行</a>
                    </td>
                <tr>
                    </c:forEach>
                </tbody>
            </table>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="dogfrozensemen:dogFrozenSemen:edit"><input id="btnSubmit" class="btn btn-primary"
                                                                              type="submit"
                                                                              value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>