package com.cku.subsystem.dog;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogSemen;
import com.cku.oa.dog.entity.DogSemenChange;
import com.cku.oa.dog.service.DogSemenChangeService;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 犬只精子变更Controller
 *
 * @author lgl
 * @version 2017-08-29
 */
@Controller
@RequestMapping(value = "/subSystem/dogSemenChange")
public class SubDogSemenChangeController extends BaseController {

    @Autowired
    private DogSemenChangeService dogSemenChangeService;
	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}

    @ModelAttribute
    public DogSemenChange get(@RequestParam(required = false) String id) {
        DogSemenChange entity = null;
        if (StringUtils.isNotBlank(id)) {
            entity = dogSemenChangeService.get(id);
        }
        if (entity == null) {
            entity = new DogSemenChange();
        }
        return entity;
    }

    @RequestMapping(value = {"list", ""})
    public String list(DogSemenChange dogSemenChange, HttpServletRequest request, HttpServletResponse response, Model model) {
        Page<DogSemenChange> page = dogSemenChangeService.findPage(new Page<DogSemenChange>(request, response), dogSemenChange);
        model.addAttribute("page", page);
        return "subSystem/"+getUrlByUserType()+"/dog/dogsemenchange/dogSemenChangeList";
    }
    @RequestMapping(value = "form")
    public String form(DogSemenChange dogSemenChange, Model model) {
        model.addAttribute("dogSemenChange", dogSemenChange);
        List<DogSemen> dogSemenList = dogSemenChangeService.getDogSemenList(dogSemenChange);
        model.addAttribute("dogSemenList", dogSemenList);
        model.addAttribute("dogSemenListCount", dogSemenList.size());
        return "subSystem/"+getUrlByUserType()+"/dog/dogsemenchange/dogSemenChangeForm";
    }
}