package com.cku.subsystem.dog;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.sys.service.LoginServerService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * DNA双亲比对Controller
 * @author lgl
 * @version 2016-11-24
 */
@Controller
@RequestMapping(value = "/subSystem/dogDnaParentsCompare")
public class SubDogDnaParentsCompareController extends BaseController {

	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;

	private final static String REPAGE = "redirect:"+Global.getAdminPath()+"/dogdnaparentscompare/dogDnaParentsCompare/?repage";

	@Autowired
	private LoginServerService loginServerService;
	
	/**
	 * 查询当前登录人登录类型得到跳转路径头
	 * @return
	 * @author chaixueteng
	 */
	public String getUrlByUserType(){
		User loginUser = UserUtils.getLoginUser();
		return loginServerService.getShortNameByUserType(loginUser.getUserType());
	}
	@ModelAttribute
	public DogDnaParentsCompare get(@RequestParam(required=false) String id) {
		DogDnaParentsCompare entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogDnaParentsCompareService.get(id);
		}
		if (entity == null){
			entity = new DogDnaParentsCompare();
		}
		return entity;
	}
	

	@RequestMapping(value = {"list", ""})
	public String list(DogDnaParentsCompare dogDnaParentsCompare, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogDnaParentsCompare> page = dogDnaParentsCompareService.findPage(new Page<DogDnaParentsCompare>(request, response), dogDnaParentsCompare);
		//双亲比对列表页面显示父母犬血统证书号
		dogDnaParentsCompareService.setParentsInfo(page.getList());
		model.addAttribute("page", page);
		return "subSystem/"+getUrlByUserType()+"/dog/dogdnaparentscompare/dogDnaParentsCompareList";
	}
	
	@RequestMapping(value = "form")
	public String form(DogDnaParentsCompare dogDnaParentsCompare, Model model) {
		model.addAttribute("dogDnaParentsCompare", dogDnaParentsCompare);
		return "subSystem/"+getUrlByUserType()+"/dog/dogdnaparentscompare/dogDnaParentsCompareForm";
	}
}