package com.cku.restful.v1.sys.web;

import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_BIND_USER;
import static com.cku.oa.sys.service.SMSRemindService.TYPE_SMS_CHANGE_MOBILE;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.core.ResultDto;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.breeder.entity.WhitelistModule;
import com.cku.oa.breeder.service.WhitelistService;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.groomer.dao.GroomerDiplomaDao;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.groomer.service.GroomerQualificationCertificateService;
import com.cku.oa.handler.entity.HandlerQualificationCertificate;
import com.cku.oa.handler.service.HandlerQualificationCertificateService;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.MemberMobileLog;
import com.cku.oa.sys.entity.SMSChangePassword;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberType;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.MemberMobileLogService;
import com.cku.oa.sys.service.SMSRemindService;
import com.cku.oa.sys.service.UserService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.DateUtils;
import com.cku.partner.sys.model.PartnerLoginUserInfo;
import com.cku.restful.v1.kennel.service.RestKennelService;
import com.cku.restful.v1.sys.model.CancelVerifyResp;
import com.cku.restful.v1.sys.model.RestKennel;
import com.cku.restful.v1.sys.model.RestMember;
import com.cku.restful.v1.sys.model.RestUser;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.ServletUtils;
import com.google.common.collect.ImmutableMap;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.thinkgem.jeesite.common.beanvalidator.BeanValidators;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.utils.CacheUtils;
import com.thinkgem.jeesite.common.utils.Encodes;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

@Controller
@RequestMapping(value = "/api/v1/userCenter")
public class RestUserController extends BaseRestController {
	@Autowired
	private MemberService memberService;
	@Autowired
	private KennelService kennelService;
	@Autowired
	private UserService userService;
	@Autowired
	private SMSRemindService smsRemindService;
	@Autowired
	public GroomerQualificationCertificateService groomerQualificationCertificateService;
	@Autowired
	public GroomerDiplomaDao groomerDiplomaDao;
	@Autowired
	public PaymentCartService paymentCartService;
	@Autowired
	public RestKennelService restKennelService;
	@Autowired
	public WhitelistService whitelistService;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	public HandlerQualificationCertificateService handlerQualificationCertificateService;
	@Autowired
	public RestIDCardService restIDCardService;
	@Autowired
	private MemberMobileLogService memberMobileLogService;

	// 计算时间，2017年6月1日
	private static Date startDate = null;
	static {
		try {
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
			startDate = simpleDateFormat.parse("2017-06-01");
		} catch (ParseException e) {
			e.printStackTrace();
		}
	}

	/**
	 * 获取用户个人基本信息
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/personalInfo", method = RequestMethod.GET)
	@ResponseBody
	public void getPersonalInfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
		User user = UserUtils.getLoginUser();
		// equals2是为了保证是会员帐号，防止合作机构合作医院帐号捣乱
		if (user.getId() != null && (user.getUserType().equals("2") || user.getUserType().equals("4")
				|| user.getUserType().equals("6"))) {
			Member member = new Member();
			member.setUser(user);
			List<Member> members = memberService.findList(member);
			JSONObject object = new JSONObject();
			JSONObject data = new JSONObject();
			// 初始化都为null，以防止缺失该节点
			data.put("member", JSONObject.fromObject(null));
			data.put("user", JSONObject.fromObject(null));
			data.put("kennel", JSONObject.fromObject(null));

			if (members.size() != 0) {
				member = members.get(0);
				// 增加实名认证，创建时间为2017年6月以后的第一次登陆进行实名认证 yuanshuai——2018年1月5日11:15:30
				if (StringUtils.isBlank(member.getAuthentication()) && startDate != null
						&& member.getCreateDate().getTime() >= startDate.getTime()) {
					String authentication;
					try {
						authentication = String.valueOf(restIDCardService.validateIDCard(null, member.getCardNo(),
								member.getName(), member.getMemberSite(), false));
					} catch (Exception e) {
						authentication = "0";
					}
					member.setAuthentication(authentication);
					memberService.updateMemberAuthentication(member, authentication);
				}

				RestMember restMember = new RestMember();
				BeanUtil.copyProperties(restMember, member, "yyyy-MM-dd");
				GroomerQualificationCertificate groomerQualificationCertificate = groomerQualificationCertificateService
						.getLevel(member.getMemberCode());
				if (groomerQualificationCertificate != null) {
					restMember.setLevelCn(groomerQualificationCertificate.getLevelCn());
				}
				GroomerDiploma groomerDiploma = groomerDiplomaDao.getByMemberCode(member.getMemberCode());
				if (groomerDiploma != null) {
					restMember.setCertificateLevel(groomerDiploma.getCertificateLevel());
				}

				if (StringUtils.isNotEmpty(restMember.getAvatar()) && !restMember.getAvatar().startsWith("http")) {
					String path = request.getContextPath();
					String imgPath = request.getScheme() + "://" + request.getServerName() + ":"
							+ request.getServerPort() + path + "/api/v1/file/image/" + restMember.getAvatar();
					restMember.setAvatarUrl(imgPath);
				} else {
					restMember.setAvatarUrl(restMember.getAvatar());
				}
				// 判断初次报名费
				int firstCost = ("professional".equals(member.getMemberType())
						&& (member.getMemberEndDate() == null || !DateUtils.isInXMounth(member.getMemberEndDate(), 1)))
								? 1
								: 0;
				restMember.setFirstCost(firstCost);
				if (null != restMember.getCardNo() && !"".equals(restMember.getCardNo())) {
					restMember.setCardNo(restMember.getCardNo().replaceAll("(\\w{12})\\w{6}(\\w{0})", "$1******$2"));
				}
				// 新增牵犬师类型
				String handlerType = "";
				HandlerQualificationCertificate handlerQualificationCertificate = handlerQualificationCertificateService
						.getLevel(member.getMemberCode());
				if (handlerQualificationCertificate != null) {
					handlerType = handlerQualificationCertificate.getCertificateLevelEn();
				}
				restMember.setHandlerType(handlerType);
				data.put("member", JSONObject.fromObject(restMember));
			}

			RestUser restUser = new RestUser();
			BeanUtil.copyProperties(restUser, user, "yyyy-MM-dd");
			// 获得退出登录标识，防止DC、UC通过拼url访问
			if (!user.getLoginType().equals("newapp") && !user.getLoginType().equals("iOS")
					&& !user.getLoginType().equals("Android") && !Global.isDevMode()) {
				restUser.setLogoutFlag(
						loginServerService.checkLogout(user.getUserType(), request.getHeader("Referer")));
			}
			// APP扫描二维码权限标记位
			restUser.setScanQRCode(
					whitelistService.isInWhitelist(null, user.getId(), WhitelistModule.SCAN_QRCODE.getValue()) ? "1"
							: "0");
			data.put("user", JSONObject.fromObject(restUser));

			if (member != null && member.getMemberType() != null
					&& member.getMemberType().equals(MemberType.professional.toString())) {
				RestKennel restKennel = new RestKennel();
				Kennel kennel = kennelService.getKennelByMemberCode(member.getMemberCode());
				if (kennel != null) {
					BeanUtil.copyProperties(restKennel, kennel, "yyyy-MM-dd");
					restKennel.setMemberName(members.size() != 0 ? members.get(0).getName() : "");
					restKennel.setAddCarFlag(restKennelService.getAddCarFlag(member, kennel));
					restKennel.setIsNeedFciInfo(restKennelService.isNeedFciInfo(kennel) == true ? "1" : "0");
					Date now = new Date();
					// 判断初次报名费
					int firstCost = (kennel.getEndTime() != null && now.after(kennel.getEndTime())
							&& !DateUtils.isInXMounth(kennel.getEndTime(), 1)) ? 1 : 0;
					restKennel.setFirstCost(firstCost);
					data.put("kennel", JSONObject.fromObject(restKennel));
				}
			}
			object.put("data", data);
			RESTResponse result = new RESTResponse(object);
			ServletUtils.writeResponse(response, result);
		} else {
			// 没有user记录或者类型不是2，都返回成功，但是没有会员信息
			ServletUtils.writeResponse(response, new RESTResponse());
		}
	}

	/**
	 * 修改用户的个人信息
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/personalInfo", method = RequestMethod.PUT)
	@ResponseBody
	public void editPersonalInfo(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		User user = UserUtils.getLoginUser();
		JSONObject requestObj = JSONObject.fromObject(json);
		Member member = UserUtils.getLoginMember();
		// 会员的姓名与证件号不允许修改
		// member.setName(requestObj.getString( "name"));
		member.setGender(requestObj.getString("gender"));
		// member.setNameEn(requestObj.getString( "nameEn"));
		// member.setCardNo(requestObj.getString( "cardNo"));
		member.setPhone(requestObj.getString("phone"));
		member.setMobile(requestObj.getString("mobile"));
		String birthday = requestObj.getString("birthday");
		Date date = com.thinkgem.jeesite.common.utils.DateUtils.parseDate(birthday);
		member.setBirthday(date);
		member.setFax(requestObj.getString("fax"));
		member.setQq(requestObj.getString("qq"));
		// 不为空set
		if (StringUtils.isNotBlank(requestObj.getString("email"))) {
			member.setEmail(requestObj.getString("email"));
		}
		member.setProvince(requestObj.getString("province"));
		member.setCity(requestObj.getString("city"));
		member.setArea(requestObj.get("area") == null ? "" : requestObj.getString("area"));
		member.setStreet(requestObj.getString("street").trim());
		member.setPostcode(requestObj.getString("postcode"));
		if (!"".equals(requestObj.getString("avatar"))) {// 头像为空 或者上传的头像id不与数据库一致时上传
			if (!requestObj.getString("avatar").equals(member.getAvatar())) {
				member.setAvatar(requestObj.getString("avatar"));
			}
		}
		member.setDeliveryCertified(requestObj.getString("deliveryCertified"));
		member.setDeliveryNotice(requestObj.getString("deliveryNotice"));
		// 因h5端暂时无此功能，故此处判断json中是否存在身份证正反面信息 by zhuoHeng 2017年3月6日17:08:50
		if (requestObj.has("cardPhotoFornt") && requestObj.has("cardPhotoRear")) {
			member.setCardPhotoFornt(requestObj.getString("cardPhotoFornt"));
			member.setCardPhotoRear(requestObj.getString("cardPhotoRear"));
		}
		try {
			BeanValidators.validateWithException(validator, member);
		} catch (Exception ex) {
			RESTResponse result = new RESTResponse(1, "数据校验出错");
			ServletUtils.writeResponse(response, result);
			return;
		}
		user.setName(requestObj.getString("nickName"));
		userService.updateUserInfo(user, member);
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 注册成为CKU会员
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/personalInfo", method = RequestMethod.POST)
	@ResponseBody
	public void addPersonalInfo(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		User user = UserUtils.getLoginUser();
		JSONObject requestObj = JSONObject.fromObject(json);
		Member member = new Member();
		member.setUser(user);
		member.setName(requestObj.getString("name"));
		member.setGender(requestObj.getString("gender"));
		member.setNameEn(requestObj.getString("nameEn"));
		member.setCardNo(requestObj.getString("cardNo"));
		member.setPhone(requestObj.getString("phone"));
		member.setMobile(requestObj.getString("mobile"));
		String birthday = requestObj.getString("birthday");
		Date date = com.thinkgem.jeesite.common.utils.DateUtils.parseDate(birthday);
		member.setBirthday(date);
		member.setFax(requestObj.getString("fax"));
		member.setEmail(requestObj.getString("email"));
		member.setProvince(requestObj.getString("province"));
		member.setCity(requestObj.getString("city"));
		member.setArea(requestObj.get("area") == null ? "" : requestObj.getString("area"));
		member.setStreet(requestObj.getString("street"));
		member.setMemberType(requestObj.getString("memberType"));
		member.setDeliveryCertified(requestObj.getString("deliveryCertified"));
		member.setDeliveryNotice(requestObj.getString("deliveryNotice"));
		LoginServer loginServer = loginServerService.getLoginServerByUrl(request);
		member.setMemberSite(loginServer.getMemberSite());
		memberService.memberRegister(member);
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/password", method = RequestMethod.PUT)
	@ResponseBody
	public void changePassword(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		// 用户修改密码
		JSONObject object = JSONObject.fromObject(json);
		String oldPassword = object.getString("oldPassword");
		String newPassword = object.getString("newPassword");
		User user = UserUtils.getLoginUser();
		userService.ChangePasswordByOldPassword(user, newPassword, oldPassword);
		RESTResponse result = new RESTResponse();
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 获取短信验证码
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/sms/{method}", method = RequestMethod.GET)
	@ResponseBody
	public void getSmsCode(@PathVariable String method, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		smsRemindService.sendCodeMessage(method, request);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 * 验证短信验证码
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@RequestMapping(value = "/smsValidate/{method}/{key}", method = RequestMethod.GET)
	@ResponseBody
	public void validateSMS(@PathVariable String key, @PathVariable String method, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		if (method.equals("changePassword")) {
			// 发送短信
			User user = UserUtils.getLoginUser();
			SMSChangePassword sms = (SMSChangePassword) CacheUtils.get(user.getId() + "-" + "sms" + method);

			if (sms == null) {
				RESTResponse result = new RESTResponse(1, "验证短信失败");
				ServletUtils.writeResponse(response, result);
				return;
			}

			User smsUser = sms.getUser();
			String realkey = sms.getKey();
			if (smsUser.getId().equals(user.getId()) && realkey.endsWith(key)) {
				JSONObject object = new JSONObject();
				String ticket = userService.applyChangePassword(user.getLoginName(), user.getUserType());
				object.put("ticket", ticket);
				RESTResponse result = new RESTResponse("data", object);
				ServletUtils.writeResponse(response, result);
			} else {
				RESTResponse result = new RESTResponse(1, "验证短信失败");
				ServletUtils.writeResponse(response, result);
			}
		}
	}

	@RequestMapping(value = "/smsValidate/bindUser", method = RequestMethod.GET)
	@ResponseBody
	public void validateSMSBindUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String memberCode = request.getParameter("memberCode");
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员信息有误，请重试");
		}
		Member member = memberService.getByMemberCode(memberCode);
		// 有safemobile优先发safemobile没有发mobile
		if (member == null || StringUtils.isBlank(member.getId())
				|| (StringUtils.isBlank(member.getMobile()) && StringUtils.isBlank(member.getSafeMobile()))) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员信息有误，请重试");
		}
		String mobile = StringUtils.isBlank(member.getSafeMobile()) ? member.getMobile() : member.getSafeMobile();
		// 发送验证码，不进行判重
		smsRemindService.sendVerifyCode(request, mobile, false, TYPE_SMS_BIND_USER);
		request.getSession().setAttribute("cacheMobile", mobile);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	@RequestMapping(value = "/bindUser", method = RequestMethod.POST)
	@ResponseBody
	public void bindUser(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String memberCode = object.getString("memberCode");
		String captcha = object.getString("captcha");
		if (StringUtils.isBlank(memberCode)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员信息有误，请重试");
		}
		Member member = memberService.getByMemberCode(memberCode);
		if (member == null || StringUtils.isBlank(member.getId()) || StringUtils.isBlank(member.getMobile())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员信息有误，请重试");
		}
		String mobile = StringUtils.isBlank(member.getSafeMobile()) ? member.getMobile() : member.getSafeMobile();
		if (smsRemindService.checkVerifyCode(mobile, captcha)) {
			memberService.bindUser(memberCode, UserUtils.getLoginUser().getLoginName(), null);
			RESTResponse result = new RESTResponse();
			ServletUtils.writeResponse(response, result);
		} else {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "验证码错误，请重试");
		}
	}

	/**
	 *
	 * @description: 会员充值-微信
	 * @author: laiguanglong
	 * @date: 2016年10月18日 下午3:42:25
	 */
	@RequestMapping(value = "/rechargeWeiXin", method = RequestMethod.POST)
	@ResponseBody
	public void rechargeWeiXin(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String memberCode = object.getString("memberCode");
		String name = object.getString("name");
		String amount = object.getString("amount");
		String paymentWay = object.getString("paymentWay");
		String id = memberService.recharge(memberCode, name, amount, paymentWay);
		JSONObject jo = new JSONObject();
		jo.put("id", id);
		ServletUtils.writeResponse(response, new RESTResponse("data", jo));
	}

	/**
	 *
	 * @description: 会员充值-支付宝
	 * @author: laiguanglong
	 * @date: 2016年10月18日 下午3:42:11
	 */
	@RequestMapping(value = "/rechargeAlipay", method = RequestMethod.POST)
	public void rechargeAlipay(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String memberCode = object.getString("memberCode");
		String name = object.getString("name");
		String amount = object.getString("amount");
		String paymentWay = object.getString("paymentWay");
		String id = memberService.recharge(memberCode, name, amount, paymentWay);
		JSONObject jo = new JSONObject();
		jo.put("id", id);
		ServletUtils.writeResponse(response, new RESTResponse("data", jo));
	}

	/**
	 *
	 * @description: 会员充值-支付宝-手机端
	 * @author: lyy
	 */
	@RequestMapping(value = "/rechargeAlipayMobile", method = RequestMethod.POST)
	public void rechargeAlipayMobile(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String memberCode = object.getString("memberCode");
		String name = object.getString("name");
		String amount = object.getString("amount");
		String paymentWay = object.getString("paymentWay");
		String id = memberService.recharge(memberCode, name, amount, paymentWay);
		JSONObject jo = new JSONObject();
		jo.put("id", id);
		ServletUtils.writeResponse(response, new RESTResponse("data", jo));
	}

	/**
	 * @Description： 发送旧手机换绑验证码
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/22 14:33
	 */
	@RequestMapping(value = "/sendVerificationCode/changeMobile/old", method = RequestMethod.GET)
	@ResponseBody
	public void sendVerificationCodeChangeMobileOld(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String safeMobile = UserUtils.getLoginMember().getSafeMobile();
		smsRemindService.sendVerifyCode(request, safeMobile, false, TYPE_SMS_CHANGE_MOBILE + "Old");
		request.getSession().setAttribute("cacheMobile", safeMobile);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 * @Description： 验证旧手机验证码
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/22 15:22
	 */
	@RequestMapping(value = "/smsValidate/changeMobile/old", method = RequestMethod.POST)
	@ResponseBody
	public void validateSMSChangeMobileOld(@RequestBody String json, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String key = object.getString("key");
		Member member = UserUtils.getLoginMember();
		RESTResponse result;
		if (smsRemindService.checkVerifyCode(member.getSafeMobile(), key)) {
			result = new RESTResponse();
			CacheUtils.put("fiveMinuteCache", TYPE_SMS_CHANGE_MOBILE + member.getSafeMobile(), member.getName());
			request.getSession().removeAttribute("cacheMobile");
		} else {
			result = new RESTResponse(1, "验证短信失败");
		}
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @Description： 发送新手机换绑验证码
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/22 14:33
	 */
	@RequestMapping(value = "/sendVerificationCode/changeMobile/new", method = RequestMethod.GET)
	@ResponseBody
	public void sendVerificationCodeChangeMobileNew(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String mobile = request.getParameter("mobile");
		Member member = UserUtils.getLoginMember();
		String name = (String) CacheUtils.get("fiveMinuteCache", TYPE_SMS_CHANGE_MOBILE + member.getSafeMobile());
		if (name == null) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "等待时间过长，请重新操作");
		}
		if (StringUtils.isBlank(mobile) || mobile.equals(member.getSafeMobile())) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "新手机号有误或与原手机号码一致");
		}
		smsRemindService.sendVerifyCode(request, mobile, true, TYPE_SMS_CHANGE_MOBILE + "New");
		request.getSession().setAttribute("cacheMobile", mobile);
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 * @Description： 验证新手机验证码
	 * 
	 * @author: yuanshuai
	 * @date: 2017/12/22 15:22
	 */
	@RequestMapping(value = "/smsValidate/changeMobile/new", method = RequestMethod.POST)
	@ResponseBody
	public void validateSMSChangeMobileNew(@RequestBody String json, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String mobile = object.getString("mobile");
		String key = object.getString("key");
		User user = UserUtils.getLoginUser();
		Member member = UserUtils.getLoginMember();
		String name = (String) CacheUtils.get("fiveMinuteCache", TYPE_SMS_CHANGE_MOBILE + member.getSafeMobile());
		if (name == null) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "等待时间过长，请重新操作");
		}
		RESTResponse result;
		if (smsRemindService.checkVerifyCode(mobile, key)) {
			// 记录会员手机变更日志
			memberMobileLogService.saveMobileLog(member.getMemberCode(), MemberMobileLog.MOBILE_TYPE_CHANG,
					member.getSafeMobile(), mobile);
			// 修改绑定手机和安全手机
			userService.updateBindMobile(user, mobile);
			memberService.updateMemberSafeMobile(member, mobile);
			result = new RESTResponse();
			request.getSession().removeAttribute("cacheMobile");
		} else {
			result = new RESTResponse(1, "验证短信失败");
		}
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/qrCode")
	public void qrCode(HttpServletResponse response) throws WriterException, IOException {
		// CKU+前八+会员号+后六
		Member member = UserUtils.getLoginMember();
		StringBuilder sb = new StringBuilder("CKU");
		sb.append(RandomStringUtils.randomNumeric(8));
		sb.append(member.getMemberCode());
		sb.append(RandomStringUtils.randomNumeric(6));

		String imagesPath = RestUserController.class.getResource("/images/memberQRCode/").getPath();
		BufferedImage qrCodeTemplate = ImageIO.read(new FileInputStream(imagesPath + "qrCodeTemplate.png"));
		int width = qrCodeTemplate.getWidth();
		int height = qrCodeTemplate.getHeight();
		BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);

		Graphics2D g = image.createGraphics();
		g.setBackground(Color.WHITE);
		g.clearRect(0, 0, width, height);

		g.drawImage(qrCodeTemplate, 0, 0, width, height, null);

		g.setFont(new Font("黑体", Font.BOLD, 20));
		g.setColor(new Color(4, 157, 94));
		g.drawString(member.getName(), 148, 190);

		String memberType = "";
		if (MemberType.basic.toString().equals(member.getMemberType())) {
			memberType = "基础会员";
		} else if (MemberType.professional.toString().equals(member.getMemberType())) {
			memberType = "专业会员";
		}
		g.drawString(memberType, 223, 190);

		if (StringUtils.isNotBlank(member.getGroomerType())) {
			BufferedImage groomerIcon = ImageIO.read(new FileInputStream(imagesPath + "groomerIcon.png"));
			g.drawImage(groomerIcon, 310, 153, groomerIcon.getWidth(), groomerIcon.getHeight(), null);
		}

		int bitMatrixWidth = 338;
		BitMatrix bitMatrix = new MultiFormatWriter().encode(sb.toString(), BarcodeFormat.QR_CODE, bitMatrixWidth,
				bitMatrixWidth, ImmutableMap.of(EncodeHintType.CHARACTER_SET, "UTF-8"));
		g.drawImage(MatrixToImageWriter.toBufferedImage(bitMatrix), 58, 220, bitMatrixWidth, bitMatrixWidth, null);
		g.dispose();

		response.setContentType("application/octet-stream; charset=utf-8");
		response.setHeader("Content-Disposition", "attachment; filename=" + Encodes.urlEncode("MemberQRCode.png"));
		ImageIO.write(image, "png", response.getOutputStream());
	}

	/**
	 * @Description： 上传证件照
	 * 
	 * @author: chaixueteng
	 * @date: 2018/02/05 15:22
	 */
	@RequestMapping(value = "/updateImg", method = RequestMethod.POST)
	@ResponseBody
	public void updateImg(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		String avatar = request.getParameter("avatar");
		if (StringUtils.isBlank(avatar)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "证件照信息读取失败,请重新上传!");
		}
		Member member = UserUtils.getLoginMember();
		memberService.updateAvatar(avatar, member.getId());
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	@RequestMapping(value = "/dogNoseDetection", method = RequestMethod.GET)
	@ResponseBody
	public void getDogNoseDetection(HttpServletRequest request, HttpServletResponse response) throws IOException {
		User user = UserUtils.getLoginUser();
		Member member = null;
		if (user == null || StringUtils.isBlank(user.getId())) {
			PartnerLoginUserInfo partnerLoginUserInfo = UserUtils.getLoginPartner();
			member = memberService.getByMemberCode(partnerLoginUserInfo.getMemberCode());
		} else {
			member = memberService.getByUserId(user.getId());
		}
		JSONObject data = new JSONObject();
		if (member != null) {
			data.put("dogNoseRepeatedDetection", member.getDogNoseRepeatedDetection());
			data.put("dogNoseLivenessDetection", member.getDogNoseLivenessDetection());
		} else {
			data.put("dogNoseRepeatedDetection", null);
			data.put("dogNoseLivenessDetection", null);
		}
		RESTResponse result = new RESTResponse("data", data);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * 账户注销验证
	 */
	@RequestMapping(value = "/cancel/verify", method = RequestMethod.GET)
	@ResponseBody
	public void cancelVerify(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String flag = request.getParameter("flag");
		CancelVerifyResp resp = memberService.cancelVerify(StringUtils.isEmpty(flag) ? "0" : flag);
		RESTResponse result = new RESTResponse("data", resp);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "/cancel/sms", method = RequestMethod.GET)
	@ResponseBody
	public void sms(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		Member member = UserUtils.getLoginMember();
		smsRemindService.sendUserCancelSMSCode(member.getSafeMobile());
		ServletUtils.writeResponse(response, new RESTResponse());
	}

	/**
	 * 账户注销
	 */
	@RequestMapping(value = "/cancel", method = RequestMethod.POST)
	@ResponseBody
	public ResultDto<String> cancel(@RequestBody String json,HttpServletRequest request, HttpServletResponse response) throws IOException {
		JSONObject object = JSONObject.fromObject(json);
		String flag = object.getString("flag");
		String smsCode = object.getString("smsCode");
		Member member = UserUtils.getLoginMember();
		smsRemindService.checkUserCancelSmsCode(member.getSafeMobile(), smsCode);
		return memberService.cancel(flag, smsCode);
	}

}
