package com.cku.restful.v1.shop.service;

import java.util.ArrayList;
import java.util.List;

import com.cku.oa.shop.dao.ShopCartsDao;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.shop.entity.ShopCarts;
import com.cku.oa.shop.entity.ShopGoods;
import com.cku.oa.shop.service.ShopCartsService;
import com.cku.oa.shop.service.ShopGoodsService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.shop.model.RestShopCarts;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 商城购物车临时Service
 * 
 * @author lyy
 * @version 2016-08-23
 */
@Service
@Transactional(readOnly = true)
public class RestShopCartsService {
	@Autowired
	private ShopCartsService shopCartsService;
	@Autowired
	private ShopGoodsService shopGoodsService;
	@Autowired
	private ShopCartsDao shopCartsDao;

	public RESTResponse getList() {
		List<ShopCarts> shopCartsList = shopCartsService
				.findListByMemberCode(UserUtils.getLoginMember()
						.getMemberCode());
		List<RestShopCarts> list = new ArrayList<RestShopCarts>();
		for (ShopCarts shopCarts : shopCartsList) {
			RestShopCarts vo = new RestShopCarts();
			BeanUtil.copyProperties(vo, shopCarts, "yyyy-MM-dd");
			list.add(vo);
		}
		long count = shopCartsList.size();
		return new RESTResponse("list", new PageBeanResult<RestShopCarts>(list,
				count));
	}


	@Transactional(readOnly = false)
	public RESTResponse subtractGoods(String id) {
		Member member = UserUtils.getLoginMember();
		ShopCarts po = shopCartsService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		shopCartsService.subtractGoods(po);
		return new RESTResponse();
	}
	@Transactional(readOnly = false)
	public RESTResponse addGoods(String id) {
		Member member = UserUtils.getLoginMember();
		ShopCarts po = shopCartsService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		shopCartsService.addGoods(po);
		return new RESTResponse();
	}


	@Transactional(readOnly = false)
	public RESTResponse delete(String id) {
		Member member = UserUtils.getLoginMember();
		ShopCarts po = shopCartsService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		shopCartsService.delete(po);
		return new RESTResponse();
	}
	
	@Transactional(readOnly = false)
	public RESTResponse put(String json) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		ShopCarts vo = BeanUtil.toBean(json, ShopCarts.class);
		ShopCarts temp = shopCartsService.get(vo.getId());
		if (temp == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(temp.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if(StringUtils.isBlank(vo.getGoodsNum())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品数量为空");
		}
		try {
			int goodsNum = Integer.valueOf(vo.getGoodsNum());
			if (goodsNum < 1) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品数量必须为正整数");
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品数量必须为数字");
		}
		//先删除购物车
		shopCartsService.delete(temp);
		vo.setGoodsId(temp.getGoodsId());
		vo.setBuyGiftsGoods(temp.getBuyGiftsGoods());
		// 构造持久对象
		ShopCarts po = buildPo(vo);
		// 从新写入购物车
		shopCartsService.save(po,"client");
		JSONObject jo = new JSONObject();
		jo.put("id", po.getId());
		return new RESTResponse(jo);
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		if(true){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商城功能暂未开放，无法购买商品！");
		}
		// 获取参数
		ShopCarts vo = BeanUtil.toBean(json, ShopCarts.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		ShopCarts po = buildPo(vo);
		// 写入购物车
		shopCartsService.save(po,"client");
		return new RESTResponse();
	}

	/**
	 * 
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(ShopCarts vo) {
		if (StringUtils.isBlank(vo.getGoodsId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品id为空");
		}
		if (StringUtils.isBlank(vo.getGoodsNum())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品数量为空");
		}
		try {
			int goodsNum = Integer.valueOf(vo.getGoodsNum());
			if (goodsNum < 1) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品数量必须为正整数");
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品数量必须为数字");
		}
	}

	/**
	 * 
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private ShopCarts buildPo(ShopCarts vo) {
		Member member = UserUtils.getLoginMember();
		ShopGoods shopGoods = shopGoodsService.get(vo.getGoodsId());
		if (shopGoods == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商品id有误");
		}
		ShopCarts po = new ShopCarts();
		po.setGoodsId(vo.getGoodsId());
		po.setGoodsNum(vo.getGoodsNum());
		po.setGoodsName(shopGoods.getName());
		po.setGoodsPrice(shopGoods.getPrice());
		po.setMemberCode(member.getMemberCode());
		po.setMemberName(member.getName());
		if (!"0".equals(shopGoods.getBuyGifts())) {
			po.setBuyGiftsGoods(vo.getBuyGiftsGoods());
			ShopGoods buyGiftsGoods = shopGoodsService.get(vo.getBuyGiftsGoods());
			if (buyGiftsGoods == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "买赠商品有误");
			}
			if (Double.valueOf(buyGiftsGoods.getPrice()) > Double
					.valueOf(shopGoods.getPrice())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"买赠商品不能比原商品贵");
			}
			int goodsNum = Integer.valueOf(vo.getGoodsNum());
			int ownGoodNum = 0;
			ShopCarts shopCarts = shopCartsDao.getShopCarts(member.getMemberCode(),vo.getGoodsId(),vo.getBuyGiftsGoods());
			if(shopCarts!=null){
				if(shopCarts.getBuyGiftsContent()!=null && !"".equals(shopCarts.getBuyGiftsContent())){
					JSONArray ja = JSONArray.fromObject(shopCarts.getBuyGiftsContent());
					for(int i=0;i<ja.size();i++){
						JSONObject jo = ja.getJSONObject(i);
						if(jo.getString("id").equals(vo.getBuyGiftsGoods())){
							ownGoodNum = jo.getInt("num");
							break;
						}
					}
				}
				if ("1".equals(shopGoods.getBuyGifts())) {
					if(ownGoodNum<=1){
						goodsNum = goodsNum+5;
					}else{
						if(ownGoodNum%3==0){
							goodsNum = goodsNum+ownGoodNum/3*10;
						}else{
							goodsNum = goodsNum+ownGoodNum/3*10+5;
						}
					}

				} else if ("2".equals(shopGoods.getBuyGifts())) {
					goodsNum = goodsNum+ownGoodNum/2*10;
				}
			}
			int num = 0;
			if ("1".equals(shopGoods.getBuyGifts())) {
				// 5返1，10返3
				if (goodsNum >= 10) {
					if(goodsNum-((goodsNum/10)*10)>=5){
						num = (goodsNum / 10 * 3)+1;
					}else{
						num = goodsNum / 10 * 3;
					}

				} else if (goodsNum >= 5) {
					num = 1;
				}
			} else if ("2".equals(shopGoods.getBuyGifts())) {
				// 10返2
				if (goodsNum >= 10) {
					num = goodsNum / 10 * 2;
				}
			}
			po.setBuyGiftsNum(num-ownGoodNum + "");
		}
		return po;
	}
}