/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.handler.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.handler.entity.HandlerDiploma;
import com.cku.oa.handler.service.HandlerDiplomaService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.cku.oa.trainschool.service.TrainingInstitutionService;
import com.cku.restful.v1.groomer.model.RestGroomerDiploma;
import com.cku.restful.v1.handler.model.RestHandlerDiploma;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 结业证书Service
 * 
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Service
@Transactional(readOnly = true)
public class RestHandlerDiplomaService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_A = "handler_qualification_certificate@A";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_B = "handler_qualification_certificate@B";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_C = "handler_qualification_certificate@C";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_JY = "handler_qualification_certificate@JY";

	@Autowired
	private HandlerDiplomaService handlerDiplomaService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private TrainingInstitutionService trainingInstitutionService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		RestHandlerDiploma vo = BeanUtil.toBean(json, RestHandlerDiploma.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		HandlerDiploma po = buildPo(vo);
		// 业务校验
		handlerDiplomaService.validateBusiness(po);
		// 写入业务表
		handlerDiplomaService.save(po);
		// 写入购物车
		PaymentCart paymentCart = buildPaymentCart(po);
		paymentCartService.addToCart(paymentCart, "1054");
		return new RESTResponse("data",paymentCart.getId());
	}

	/**
	 * 
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(RestHandlerDiploma vo) {
		if (StringUtils.isBlank(vo.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号为空");
		}
		if (StringUtils.isBlank(vo.getStartDate())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "开始时间为空");
		}
		if (StringUtils.isBlank(vo.getEndDate())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "结束时间为空");
		}
		if (StringUtils.isBlank(vo.getTeacher())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "培训教师为空");
		}
		if (StringUtils.isBlank(vo.getCertificateLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书级别为空");
		}
		if (StringUtils.isBlank(vo.getHandlerType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "培训类型为空");
		}
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		try {
			sdf.parse(vo.getStartDate());
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "开始时间格式有误");
		}
		try {
			sdf.parse(vo.getEndDate());
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "结束时间格式有误");
		}
		if (!"牵犬师A级".equals(vo.getCertificateLevel())
				&& !"牵犬师B级".equals(vo.getCertificateLevel())
				&& !"牵犬师C级".equals(vo.getCertificateLevel())
				&& !"精英培训班".equals(vo.getCertificateLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书级别只能为牵犬师A级,牵犬师B级,牵犬师C级,精英培训班");
		}
		if (!"0".equals(vo.getHandlerType())
				&& !"1".equals(vo.getHandlerType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "培训类型只能为0或1");
		}
	}

	/**
	 * 
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private HandlerDiploma buildPo(RestHandlerDiploma vo) {
		Member member = memberService.getByMemberCode(vo.getMemberCode());
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号有误");
		}
		Member loginMember = UserUtils.getLoginMember();
		TrainingInstitution trainingInstitution = trainingInstitutionService
				.getByMemberCode(loginMember.getMemberCode());
		if (trainingInstitution == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前登录会员没有关联机构");
		}
		HandlerDiploma po = new HandlerDiploma();
		po.setMemberCode(member.getMemberCode());
		po.setName(member.getName());
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			po.setStartDate(sdf.parse(vo.getStartDate()));
			po.setEndDate(sdf.parse(vo.getEndDate()));
		} catch (ParseException e) {
			e.printStackTrace();
		}
		po.setSchoolId(trainingInstitution.getId());
		po.setTeacher(vo.getTeacher());
		po.setCertificateLevel(vo.getCertificateLevel());
		po.setPaymentMembershipCode(loginMember.getMemberCode());
		po.setPrintState("0");
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setHandlerType(vo.getHandlerType());
		po.setSchoolNameEn(trainingInstitution.getSchoolNameEn());
		po.setSchoolNameCn(trainingInstitution.getSchoolNameCn());
		return po;
	}

	private PaymentCart buildPaymentCart(HandlerDiploma po) {
		PaymentCart paymentCart = new PaymentCart();
		String shortName = "";
		if ("牵犬师A级".equals(po.getCertificateLevel())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_A;
		} else if ("牵犬师B级".equals(po.getCertificateLevel())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_B;
		} else if ("牵犬师C级".equals(po.getCertificateLevel())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_C;
		} else if ("精英培训班".equals(po.getCertificateLevel())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_JY;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("handler_diploma");
		paymentCart.setBusinessIds(po.getId());
		return paymentCart;
	}

	/**
	 * 批量提交列表
	 * @Author chaixueteng
	 * @2016年9月23日下午3:40:25
	 */
	public RESTResponse getList(HttpServletRequest request) {
		Member loginMember = UserUtils.getLoginMember();
		TrainingInstitution trainingInstitution = trainingInstitutionService
				.getByMemberCode(loginMember.getMemberCode());
		if (trainingInstitution == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前登录会员没有关联机构");
		}
		String schoolNameCn = trainingInstitution.getSchoolNameCn();
		// 获取参数
		String paymentState = request.getParameter("paymentState");
		String handlerType=request.getParameter("handlerType");
		String memberCode=request.getParameter("memberCode");
		String name=request.getParameter("name");
		String certificateLevel=request.getParameter("certificateLevel");
		String certificateCode = request.getParameter("certificateCode");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"pageNo和pageSize必须都为数字");
		}
		HandlerDiploma handlerDiploma = new HandlerDiploma();
		// 设置分页参数
		Page<HandlerDiploma> page = new Page<HandlerDiploma>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		handlerDiploma.setSchoolNameCn(schoolNameCn);
		handlerDiploma.setHandlerType(handlerType);
		if (StringUtils.isNotBlank(paymentState)) {
			handlerDiploma.setPaymentState(paymentState);
		}
		if (StringUtils.isNotBlank(memberCode)) {
			handlerDiploma.setMemberCode(memberCode);
		}
		if (StringUtils.isNotBlank(name)) {
			handlerDiploma.setName(name);
		}
		if (StringUtils.isNotBlank(certificateLevel)) {
			handlerDiploma.setCertificateLevel(certificateLevel);
		}
		if (StringUtils.isNotBlank(certificateCode)) {
			handlerDiploma.setCertificateCode(certificateCode);
		}
		handlerDiploma.setDelFlag("0");
		handlerDiploma.setPage(page);
		List<HandlerDiploma> findList = handlerDiplomaService.findList(handlerDiploma);
		List<RestHandlerDiploma> list = new ArrayList<RestHandlerDiploma>();
		for (HandlerDiploma hd : findList) {
			RestHandlerDiploma vo = new RestHandlerDiploma();
			BeanUtil.copyProperties(vo, hd, "yyyy-MM-dd");
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(),
					"review_state", ""));
			list.add(vo);
		}
		long count = list.size();
		return new RESTResponse("list",
				new PageBeanResult<RestHandlerDiploma>(list, count));
	}


}