package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogDloodDnaService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

@Controller
@RequestMapping(value = "/api/v1/dog")
@Api(value = "手机App-配种证明-血样留存", tags = { "手机App-配种证明-血样留存-xuxue" })
public class RestDogDloodDnaController extends BaseRestController {

	@Autowired
	private RestDogDloodDnaService restDogDloodDnaService;

	/**
	 * 是否已有血样留存
	 * 
	 * @param keyword
	 *            血统证书号或者芯片号
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "App-配种证明-血样留存-查询是否有血样留存", notes = " 入参：\n" + "keyword   -- 血统证书号或者芯片号\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"data\": {\n" + "        \"mine\": true,     -- true是本人的  false不是本人的\n"
			+ "        \"dogDloodDna\": false    -- true有留存  false无留存\n" + "    }\n" + "}\n"))
	@RequestMapping(value = "/dogDloodDna", method = RequestMethod.GET)
	@ResponseBody
	public void isDogDloodDna(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String keyword = request.getParameter("keyword");
		ServletUtils.writeResponse(response, restDogDloodDnaService.isDogDloodDna(keyword));
	}

	@ApiOperation(value = "App-配种证明-血样留存-提交页面狗详情", notes = " 入参：\n" + "keyword   -- 血统证书号或者芯片号\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"data\": {\n" + "        \"colorFlagName\": \"黑色\", -- 颜色\n"
			+ "        \"birthdate\": \"2017-12-16 00:00:00\", -- 生日\n" + "        \"gender\": \"1\",\n"
			+ "        \"pedigreeCertifiedCode\": \"CKU-343463134/19\", -- 血统证书号\n"
			+ "        \"breeder\": \"吴小剑\", -- 繁殖人\n" + "        \"nickname\": \"\", -- 呼名\n"
			+ "        \"nameCn\": \"\",  -- 中文姓名\n" + "        \"dogOwner\": \"刘载春\", -- 犬主\n"
			+ "        \"dogBreed\": \"343\",  -- 种类代码\n" + "        \"nameEn\": \"Bao Jian  Keleis\",   -- 英文姓名\n"
			+ "        \"dogBreedCnName\": \"意大利凯因克尔索犬\"  -- 种类名称\n" + "    }\n" + "}\n" + ""))
	@RequestMapping(value = "/dogDloodDna/detail", method = RequestMethod.GET)
	@ResponseBody
	public void detail(HttpServletRequest request, HttpServletResponse response) throws IOException {
		String keyword = request.getParameter("keyword");
		ServletUtils.writeResponse(response, restDogDloodDnaService.getDogDetail(keyword));
	}

	/**
	 * 提交血样留存
	 * 
	 * @param json
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "App-配种证明-血样留存-提交", notes = "入参：\n" + "{\n"
			+ "	\"pedigreeCertifiedCode\": \"CKU-111463171/20\", -- 血统证书号\n"
			+ "	\"hospitalCode\": \"a61cf0c2cbb44bc893a5f6c90109836c\", -- 合作机构代码\n"
			+ "	\"dnaSaveWay\": \"1\"  -- DNA留存方式:血样留存0；DNA位点分析1\n" + "}\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"data\": \"b7d0fb8fa6164826bf24cda2d8250364,6c4c7b24291a45b9b1fb5d1b2ba778fc\"\n"
			+ "-- 购物车条目ID，可能多个\n" + "}\n" + ""))
	@RequestMapping(value = "/dogDloodDna", method = RequestMethod.POST)
	@ResponseBody
	public void postDogDloodDna(@RequestBody String json, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogDloodDnaService.post(json);
		ServletUtils.writeResponse(response, result);
	}
}