package com.cku.oa.sys.zalog;

import com.cku.core.ZAException;

/**
 * Created with IntelliJ IDEA.
 * User: lyy
 * Date: 2016/7/6
 * Time: 10:09
 */
public interface SysState {
    /**
     * 状态机只控制这几个状态，其余状态不控制 :
     * payment_state 0,未生成订单，1 未支付，2已支付，3超时
     * review_state 0 未审核，1，已通过，2，未通过
     * proccess_state 0 未处理，1已处理
     * 1，未生成订单 payout 0
     * 2,未付款 payout 1
     * 3，已付款-未审核  payout 2-info-confirm 0
     * 4，审核通过 info-confirm 1
     * 5，审核未通过 info-confirm 2
     * 6，end结束
     */

    //封装动作

    /**
     * 状态：未生成订单 payout 0
     * 动作：生成订单
     */
    public void createOrder(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String, ZAException> consumer) throws ZAException;
    /**
     * 状态：未付款 payout 1
     * 动作：付款
     */
    public void payment(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException;
    /**
     * 状态：未付款 payout 1
     * 动作：取消申请 del_flag =1 物理删除
     */
    public void cancelApply(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException;
    /**
     * 状态：已付款-未审核  payout 2-info-confirm 0
     * 动作：审核通过
     */
    public void confirmSuccess(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException;
    /**
     * 状态：已付款-未审核  payout 2-info-confirm 0
     * 动作：审核失败
     */
    public void confirmFail(SysContext ckuContext, String info,String errorInfo,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException;
    /**
     * 状态：审核未通过 info-confirm 2
     * 动作：修改资料
     */
    public void updateInfo(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException;
    /**
     * 状态：审核通过 info-confirm 1
     * 动作：变更数据
     */
    public void updateData(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException;
    /**
     * 状态：已付款-未审核 后都有此操作
     * 动作：线下退费
     */
    public void offlineRefund(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException;

    /**
     * 状态机以外的状态，不由状态机控制，只负责入库
     * @param ckuContext
     * @param info
     * @param consumer
     * @throws ZAException
     */
    public void noStateExecute(SysContext ckuContext, String info,String memberCode,String tableName,String businessId,String runningNumber, SysConsumer<String,ZAException> consumer) throws ZAException;
}
