package com.cku.oa.sys.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.statistics.dao.ClubStatisticsDao;
import com.cku.oa.statistics.entity.ClubStatisticsInfo;
import com.cku.oa.sys.dao.OrgChipDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.orgIncome.CatRenZhengIncome;
import com.cku.oa.sys.entity.orgIncome.ChongjihemendianIncome;
import com.cku.oa.sys.entity.orgIncome.ClubIncome;
import com.cku.oa.sys.entity.orgIncome.HospitalIncome;
import com.cku.oa.sys.service.OrgService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 合作机构、合作医院Controller
 * 
 * @author fanhuibin
 * @version 2016-08-22
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/org")
public class OrgController extends BaseController {

	@Autowired
	private OrgService orgService;
	@Autowired
	private OrgChipDao orgChipDao;
	@Autowired
	public ClubStatisticsDao clubStatisticsDao;

	@ModelAttribute
	public Org get(@RequestParam(required = false) String id) {
		Org entity = null;
		if (StringUtils.isNotBlank(id)) {
			entity = orgService.get(id);
		}
		if (entity == null) {
			entity = new Org();
		}
		return entity;
	}

	@RequiresPermissions("sys:org:view")
	@RequestMapping(value = { "list", "" })
	public String list(Org org, HttpServletRequest request, HttpServletResponse response, Model model) {
		if (StringUtils.isBlank(org.getOrgType())) {
			org.setOrgType("club");
		}
		Page<Org> page = orgService.findPage(new Page<Org>(request, response), org);
		List<Org> list = page.getList().stream().map(data -> {
			if (StringUtils.isNotBlank(data.getOrgSite())) {
				data.setOrgSiteArr(data.getOrgSite().split(","));
			}
			return data;
		}).collect(Collectors.toList());
		page.setList(list);
		model.addAttribute("page", page);
		Date currentDate = new Date();
		model.addAttribute("currentDate", currentDate);
		return "oa/sys/orgList";
	}

	@RequiresPermissions("sys:org:view")
	@RequestMapping(value = "form")
	public String form(Org org, Model model) {
		model.addAttribute("org", org);
		model.addAttribute("province", UserUtils.getProvince());
		model.addAttribute("city", UserUtils.getCityByProvince(org.getProvince()));
		Org orgs = new Org();
		orgs.setOrgType("club");
		model.addAttribute("orgType", orgService.findList(orgs));
		if (StringUtils.isEmpty(org.getId())) {
			org.setDisplayOnWeb("0");
//			合作机构录入时默认选中cku
			org.setOrgSite("1,2");
			org.setOrgSiteArr(org.getOrgSite().split(","));
			return "oa/sys/orgAdd";
		} else {
			if (StringUtils.isNotBlank(org.getOrgSite())) {
				org.setOrgSiteArr(org.getOrgSite().split(","));
			}
			Map<String, String> chipCountByOrg = orgChipDao.getChipCountByOrg(org.getId());
			model.addAttribute("count_over", chipCountByOrg.get("count_over"));
			model.addAttribute("count_off", chipCountByOrg.get("count_off"));
			Map<String, String> bloodCountByOrg = orgChipDao.getBloodCountByOrg(org.getId());
			model.addAttribute("blood_card_sum", bloodCountByOrg.get("blood_card_sum"));// 采血器材数量
			model.addAttribute("draw_blood_sum", bloodCountByOrg.get("draw_blood_sum"));// 采血卡数量
			model.addAttribute("dna_blood", bloodCountByOrg.get("dna_blood"));// 血样留存数量
			model.addAttribute("dna_archive", bloodCountByOrg.get("dna_archive"));// 位点分析数量
			return "oa/sys/orgForm";
		}
	}

	@RequiresPermissions("sys:org:view")
	@RequestMapping(value = "save")
	public String save(Org org, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if (StringUtils.isEmpty(org.getId())) {
			hasPermission = SecurityUtils.getSubject().isPermitted("sys:org:add");
		} else {
			hasPermission = SecurityUtils.getSubject().isPermitted("sys:org:edit");
		}
		if (!hasPermission) {
			throw new AuthorizationException("用户权限不足");
		}

		if (!beanValidator(model, org)) {
			return form(org, model);
		}
		orgService.save(org);
		addMessage(redirectAttributes, "保存合作机构成功");
		return "redirect:" + Global.getAdminPath() + "/sys/org/?repage";
	}

	@RequiresPermissions("sys:org:edit")
	@RequestMapping(value = "delete")
	public String delete(Org org, RedirectAttributes redirectAttributes) {
		orgService.delete(org);
		addMessage(redirectAttributes, "删除合作机构、合作医院成功");
		return "redirect:" + Global.getAdminPath() + "/sys/org/?repage";
	}

	@RequestMapping(value = "getHospital")
	@ResponseBody
	public List<Org> getHospital(HttpServletRequest request) {
		String provinceName = request.getParameter("province");
		Org example = new Org();
		example.setOrgType("hospital");
		example.setAddress(provinceName);
		List<Org> result = orgService.findList(example);
		return result;
	}

	@RequestMapping(value = "getOrg")
	@ResponseBody
	public List<Org> getOrg(HttpServletRequest request) {
		String provinceName = request.getParameter("province");
		String oaOrder = request.getParameter("oaOrder");
		Org example = new Org();
		example.setAddress(provinceName);
		example.setOaOrder(oaOrder);
		List<Org> result = orgService.findList(example);
		return result;
	}

	@RequestMapping(value = "getOrgForPedigreeCertifiedChange")
	@ResponseBody
	public List<Org> getOrgForPedigreeCertifiedChange(HttpServletRequest request) {
		List<Org> result = this.getOrg(request);
		// add by zjw 2023-02-24 只显示机构类型为：地方合作机构、合作医院，状态为：开放的合作机构。状态为关闭 【ID1005148】
		// hospital 合作医院
		// club 地方合作机构
		// org.endDate>=currentDate 开放 org.endDate<currentDate 关闭
		if (!CollectionUtils.isEmpty(result)) {
			result = result.stream()
					.filter(org -> Objects.nonNull(org.getEndDate())
							&& DateUtils.isAfterMounth(org.getEndDate(), new Date(), Boolean.TRUE)
							&& ("club".equals(org.getOrgType()) || "hospital".equals(org.getOrgType())))
					.collect(Collectors.toList());
		}
		return result;
	}

	@RequestMapping(value = "/income")
	public String income(HttpServletRequest request, HttpServletResponse response, Model model) throws ParseException {
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String nowDate = request.getParameter("nowDate");
		String memberCode = request.getParameter("memberCode");
		String orgType = request.getParameter("orgType");
		String name = request.getParameter("name");
		String tuijiansren = request.getParameter("tuijiansren");
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if (nowDate == null) {
			nowDate = "";
		}
		if (!nowDate.equals("")) {
			if (nowDate.equals("year")) {
				startDate = String.valueOf(year) + "-01-01 00:00:00:";
				endDate = String.valueOf(year) + "-12-31 23:59:59";
			} else if (nowDate.equals("month")) {
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-01 00:00:00";
				endDate = String.valueOf(year) + "-" + String.valueOf(month + 1) + "-01 23:59:59";
			}
		} else {
			if (startDate == null || startDate.equals(""))
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day)
						+ " 00:00:00";
			if (endDate == null || endDate.equals(""))
				endDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 23:59:59";
		}
		if (StringUtils.isBlank(orgType)) {
			orgType = "club";
		}
		List<Map> results = clubStatisticsDao.income(startDate, endDate, name, memberCode, orgType, tuijiansren);
		if (!"chongjihemendian".equals(orgType) && !"hospital".equals(orgType) && !CollectionUtils.isEmpty(results)) {
			List<String> memberCodes = results.stream().filter(data -> Objects.nonNull(data.get("member_code")))
					.map(data -> data.get("member_code").toString()).collect(Collectors.toList());
			List<ClubStatisticsInfo> statisticsInfoList = clubStatisticsDao.getCertifiedByMemberCodes(startDate,
					endDate, memberCodes, orgType);
			Map<String, ClubStatisticsInfo> statisticsInfoMap = new HashMap<>();
			if (!CollectionUtils.isEmpty(statisticsInfoList)) {
				statisticsInfoMap.putAll(statisticsInfoList.stream()
						.collect(Collectors.toMap(ClubStatisticsInfo::getMemberCode, Function.identity())));
			}
			results.forEach(map -> {
				if (statisticsInfoMap.containsKey(map.get("member_code"))) {
					map.put("certified_price", statisticsInfoMap.get(map.get("member_code")).getTotalPrice());
					map.put("certified_count", statisticsInfoMap.get(map.get("member_code")).getCount());
				} else {
					map.put("certified_price", "0");
					map.put("certified_count", "0");
				}
			});
		}
		model.addAttribute("size", results.size());
		model.addAttribute("results", results);
		model.addAttribute("startDate", startDate);
		model.addAttribute("endDate", endDate);
		model.addAttribute("name", name);
		model.addAttribute("memberCode", memberCode);
		model.addAttribute("tuijiansren", tuijiansren);
		model.addAttribute("orgList", orgService.findAll());
		Page<Object> page = new Page<Object>(request, response);
		page.setCount(results.size());
		page.initialize();// 重新计算页码信息
		model.addAttribute("page", page);
		if ("hospital".equals(orgType)) {
			return "oa/sys/orgStatistics/hospitalStatistics";
		} else if ("chongjihemendian".equals(orgType)) {
			return "oa/sys/orgStatistics/chongjihemendianStatistics";
		} else if ("catRenZheng".equals(orgType)) {
			return "oa/sys/orgStatistics/catRenZhengStatistics";
		} else {
			return "oa/sys/orgStatistics/clubStatistics";
		}
	}

	@RequestMapping(value = "exportIncome")
	public void exportIncome(HttpServletRequest request, HttpServletResponse response,
			RedirectAttributes redirectAttributes) {
		String startDate = request.getParameter("startDate");
		String endDate = request.getParameter("endDate");
		String nowDate = request.getParameter("nowDate");
		String memberCode = request.getParameter("memberCode");
		String orgType = request.getParameter("orgType");
		String name = request.getParameter("name");
		String tuijiansren = request.getParameter("tuijiansren");
		Calendar cal = Calendar.getInstance();
		int year = cal.get(Calendar.YEAR);
		int month = cal.get(Calendar.MONTH) + 1;
		int day = cal.get(Calendar.DAY_OF_MONTH);
		if (nowDate == null) {
			nowDate = "";
		}
		if (!nowDate.equals("")) {
			if (nowDate.equals("year")) {
				startDate = String.valueOf(year) + "-01-01 00:00:00:";
				endDate = String.valueOf(year) + "-12-31 23:59:59";
			} else if (nowDate.equals("month")) {
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-01 00:00:00";
				endDate = String.valueOf(year) + "-" + String.valueOf(month + 1) + "-01 23:59:59";
			}
		} else {
			if (startDate == null || startDate.equals(""))
				startDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day)
						+ " 00:00:00";
			if (endDate == null || endDate.equals(""))
				endDate = String.valueOf(year) + "-" + String.valueOf(month) + "-" + String.valueOf(day) + " 23:59:59";
		}
		if (StringUtils.isBlank(orgType)) {
			orgType = "club";
		}
		List<Map> results = clubStatisticsDao.income(startDate, endDate, name, memberCode, orgType, tuijiansren);
		if (!"chongjihemendian".equals(orgType) && !"hospital".equals(orgType)) {
			List<String> memberCodes = results.stream().filter(data -> Objects.nonNull(data.get("member_code")))
					.map(data -> data.get("member_code").toString()).collect(Collectors.toList());
			List<ClubStatisticsInfo> statisticsInfoList = clubStatisticsDao.getCertifiedByMemberCodes(startDate,
					endDate, memberCodes, orgType);
			Map<String, ClubStatisticsInfo> statisticsInfoMap = new HashMap<>();
			if (!CollectionUtils.isEmpty(statisticsInfoList)) {
				statisticsInfoMap.putAll(statisticsInfoList.stream()
						.collect(Collectors.toMap(ClubStatisticsInfo::getMemberCode, Function.identity())));
			}
			results.forEach(map -> {
				if (map.containsKey(map.get("member_code"))) {
					map.put("certified_price", statisticsInfoMap.get(map.get("member_code")).getTotalPrice());
					map.put("certified_count", statisticsInfoMap.get(map.get("member_code")).getCount());
				}
			});
		}
		try {
			if ("hospital".equals(orgType)) {
				List<HospitalIncome> list = new ArrayList<>();
				for (Map map : results) {
					HospitalIncome data = new HospitalIncome();
					BeanUtils.populate(data, map);
					list.add(data);
				}
				new ExportExcel("", HospitalIncome.class, 2).setDataList(list).write(response, "合作机构统计.xlsx").dispose();
			} else if ("chongjihemendian".equals(orgType)) {
				List<ChongjihemendianIncome> list = new ArrayList<>();
				for (Map map : results) {
					ChongjihemendianIncome data = new ChongjihemendianIncome();
					BeanUtils.populate(data, map);
					list.add(data);
				}
				new ExportExcel("", ChongjihemendianIncome.class, 2).setDataList(list).write(response, "合作机构统计.xlsx")
						.dispose();
			} else if ("catRenZheng".equals(orgType)) {
				List<CatRenZhengIncome> list = new ArrayList<>();
				for (Map map : results) {
					CatRenZhengIncome data = new CatRenZhengIncome();
					BeanUtils.populate(data, map);
					list.add(data);
				}
				new ExportExcel("", CatRenZhengIncome.class, 2).setDataList(list).write(response, "合作机构统计.xlsx")
						.dispose();
			} else {
				List<ClubIncome> list = new ArrayList<>();
				for (Map map : results) {
					ClubIncome data = new ClubIncome();
					BeanUtils.populate(data, map);
					list.add(data);
				}
				new ExportExcel("", ClubIncome.class, 2).setDataList(list).write(response, "合作机构统计.xlsx").dispose();
			}
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出信息失败！失败信息：" + e.getMessage());
		}
	}

	@RequiresPermissions("sys:org:dogNoseEdit")
	@RequestMapping(value = "dogNose/form")
	public String dogNoseEdit(Org org, Model model) {
		model.addAttribute("org", org);
		return "oa/sys/dogNoseEditForm";
	}

	@RequiresPermissions("sys:org:dogNoseEdit")
	@RequestMapping(value = "dogNose/edit")
	@ResponseBody
	public void dogNoseEdit(@RequestParam String memberCode, @RequestParam String dogNoseRepeatedDetection,
			@RequestParam String dogNoseLivenessDetection, Model model, HttpServletResponse response)
			throws IOException {
		JSONObject result = new JSONObject();
		try {
			orgService.dogNoseEdit(memberCode, dogNoseRepeatedDetection, dogNoseLivenessDetection);
			String mes = "合作机构：" + memberCode + "修改身份信息成功";
			result.put("rc", 0);
			result.put("msg", mes);
			result.put("successUrl", "/sys/org/list?message=" + URLEncoder.encode(mes));
		} catch (ZAException e) {
			result.put("rc", 1);
			result.put("msg", e.getMessage());

		}
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(result.toString());
	}
}