package com.cku.oa.order.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.order.entity.BusinessOrder;
import com.cku.oa.order.service.BusinessOrderService;

/**
 * 商品订单Controller
 * @author yuanshuai
 * @version 2023-06-20
 */
@Controller
@RequestMapping(value = "${adminPath}/order/businessOrder")
public class BusinessOrderController extends BaseController {

	@Autowired
	private BusinessOrderService businessOrderService;
	
	@ModelAttribute
	public BusinessOrder get(@RequestParam(required=false) String id) {
		BusinessOrder entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = businessOrderService.get(id);
		}
		if (entity == null){
			entity = new BusinessOrder();
		}
		return entity;
	}
	
	@RequiresPermissions("order:businessOrder:view")
	@RequestMapping(value = {"list", ""})
	public String list(BusinessOrder businessOrder, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<BusinessOrder> page = businessOrderService.findPage(new Page<BusinessOrder>(request, response), businessOrder); 
		model.addAttribute("page", page);
		return "oa/order/businessOrderList";
	}

	@RequiresPermissions("order:businessOrder:view")
	@RequestMapping(value = "viewForm")
	public String viewForm(BusinessOrder businessOrder, Model model) {
		model.addAttribute("isView", 1);
		model.addAttribute("businessOrder", businessOrder);
		return "oa/order/businessOrderForm";
	}

	@RequiresPermissions("order:businessOrder:edit")
	@RequestMapping(value = "editForm")
	public String editForm(BusinessOrder businessOrder, Model model) {
		model.addAttribute("isView", 0);
		model.addAttribute("businessOrder", businessOrder);
		return "oa/order/businessOrderForm";
	}

	@RequiresPermissions("order:businessOrder:edit")
	@RequestMapping(value = "save")
	public String save(BusinessOrder businessOrder, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, businessOrder)){
			return editForm(businessOrder, model);
		}
		businessOrderService.save(businessOrder);
		addMessage(redirectAttributes, "保存商品订单成功");
		return "redirect:"+Global.getAdminPath()+"/order/businessOrder/?repage";
	}
	
	@RequiresPermissions("order:businessOrder:del")
	@RequestMapping(value = "delete")
	public String delete(BusinessOrder businessOrder, RedirectAttributes redirectAttributes) {
		businessOrderService.delete(businessOrder);
		addMessage(redirectAttributes, "删除商品订单成功");
		return "redirect:"+Global.getAdminPath()+"/order/businessOrder/?repage";
	}

}