/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.logUtil.JSONObjectUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.groomer.entity.GroomerShowReferee;
import com.cku.oa.groomer.service.GroomerShowRefereeService;

/**
 * 赛事裁判表Controller
 * @author lgl
 * @version 2016-07-14
 */
@Controller
@RequestMapping(value = "${adminPath}/groomer/groomerShowReferee")
public class GroomerShowRefereeController extends BaseController {

	@Autowired
	private GroomerShowRefereeService showRefereeService;
	
	@ModelAttribute
	public GroomerShowReferee get(@RequestParam(required=false) String id) {
		GroomerShowReferee entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showRefereeService.get(id);
		}
		if (entity == null){
			entity = new GroomerShowReferee();
		}
		return entity;
	}
	
	@RequiresPermissions("groomer:groomerShowReferee:view")
	@RequestMapping(value = {"list", ""})
	public String list(GroomerShowReferee showReferee, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<GroomerShowReferee> page = showRefereeService.findPage(new Page<GroomerShowReferee>(request, response), showReferee); 
		model.addAttribute("page", page);
		return "oa/groomer/groomerShowRefereeList";
	}

	@RequiresPermissions("groomer:groomerShowReferee:view")
	@RequestMapping(value = "form")
	public String form(GroomerShowReferee showReferee, Model model) {
		model.addAttribute("groomerShowReferee", showReferee);
		return "oa/groomer/groomerShowRefereeForm";
	}

	@RequiresPermissions("groomer:groomerShowReferee:edit")
	@RequestMapping(value = "save")
	public String save(GroomerShowReferee showReferee, Model model, RedirectAttributes redirectAttributes) {
		logger.info("-----------------showReferee : {}-------------", JSONObjectUtils.toJsonString(showReferee));
		if (showReferee == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审查员信息不能为null");
		}
		if (!beanValidator(model, showReferee)){
			return form(showReferee, model);
		}
		showReferee.setType("0");
		showRefereeService.save(showReferee);
		addMessage(redirectAttributes, "保存赛事裁判成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerShowReferee/?repage";
	}
	
	@RequiresPermissions("groomer:groomerShowReferee:edit")
	@RequestMapping(value = "delete")
	public String delete(GroomerShowReferee showReferee, RedirectAttributes redirectAttributes) {
		showRefereeService.delete(showReferee);
		addMessage(redirectAttributes, "删除赛事裁判成功");
		return "redirect:"+Global.getAdminPath()+"/groomer/groomerShowReferee/?repage";
	}

	@RequiresPermissions("groomer:groomerShowReferee:view")
	@RequestMapping(value = "view")
	public String view(GroomerShowReferee showReferee, Model model) {
		model.addAttribute("groomerShowReferee", showReferee);
		return "oa/groomer/groomerShowRefereeView";
	}

}