package com.cku.oa.groomer.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.apache.commons.lang3.StringEscapeUtils;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 美容师活动Entity
 * 
 * @author cxt
 * @version 2016-07-14
 */
public class GroomerShow extends DataEntity<GroomerShow> {

	private static final long serialVersionUID = 1L;
	private String showCode; // 赛事编号
	private Date startTime; // 开始日期
	private Date endTime; // 结束日期
	private String showName; // 活动名称
	private String showAddress; // 活动地点
	private String showType; // 活动类型
	private String[] showTypeSpare; //
	private String showCategory;// 活动类别
	private String registerState; // 报名状态(已废除)
	private Date registerEndTime; // 截止时间
	private String topicLink; // 专题链接
	private String registerImage; // 报名图片
	private String reviewImage; // 回顾图片
	private String topicImage; // 专题图片
	private String referee; // 裁判id
	private String hotelTel; // 酒店电话
	private String showIntroduce; // 活动介绍
	private String venueRoute; // 场馆路线
	private String accommodationIntroduce; // 住宿介绍
	private String timeTableLink; // 时间表链接
	private String rewardImageLink; // 赏励照链接
	private String championQualifactionLink; // 冠军登录链接
	private String creditsLink; // 积分链接
	private String discount; // 报名优惠
	private String fee; // 报名费
	private Boolean freeFee; // 免报名费
	private String testLevel; // 考试级别

	private Date beginDate; // 开始时间
	private Date endDate; // 结束时间
	private String recommend;// 美容师活动推荐（APP使用）
	private String venueId;// 场馆id
	private String hotelId;// 酒店id
	private String excludeType;// 排除条件-活动类型
	private String excludeCode;// 排除条件-活动编码
	private boolean oneYear; // 是否查询一年内
	private String showPhoto;// 活动图片

	private String registerType;
	private String schools;

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((beginDate == null) ? 0 : beginDate.hashCode());
		result = prime * result + ((endDate == null) ? 0 : endDate.hashCode());
		result = prime * result + ((fee == null) ? 0 : fee.hashCode());
		result = prime * result + ((registerEndTime == null) ? 0 : registerEndTime.hashCode());
		result = prime * result + ((registerType == null) ? 0 : registerType.hashCode());
		result = prime * result + ((schools == null) ? 0 : schools.hashCode());
		result = prime * result + ((showAddress == null) ? 0 : showAddress.hashCode());
		result = prime * result + ((showCategory == null) ? 0 : showCategory.hashCode());
		result = prime * result + ((showCode == null) ? 0 : showCode.hashCode());
		result = prime * result + ((showName == null) ? 0 : showName.hashCode());
		result = prime * result + ((showType == null) ? 0 : showType.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		GroomerShow other = (GroomerShow) obj;
		if (beginDate == null) {
			if (other.beginDate != null)
				return false;
		} else if (!beginDate.equals(other.beginDate))
			return false;
		if (endDate == null) {
			if (other.endDate != null)
				return false;
		} else if (!endDate.equals(other.endDate))
			return false;
		if (fee == null) {
			if (other.fee != null)
				return false;
		} else if (!fee.equals(other.fee))
			return false;
		if (registerEndTime == null) {
			if (other.registerEndTime != null)
				return false;
		} else if (!registerEndTime.equals(other.registerEndTime))
			return false;
		if (registerType == null) {
			if (other.registerType != null)
				return false;
		} else if (!registerType.equals(other.registerType))
			return false;
		if (schools == null) {
			if (other.schools != null)
				return false;
		} else if (!schools.equals(other.schools))
			return false;
		if (showAddress == null) {
			if (other.showAddress != null)
				return false;
		} else if (!showAddress.equals(other.showAddress))
			return false;
		if (showCategory == null) {
			if (other.showCategory != null)
				return false;
		} else if (!showCategory.equals(other.showCategory))
			return false;
		if (showCode == null) {
			if (other.showCode != null)
				return false;
		} else if (!showCode.equals(other.showCode))
			return false;
		if (showName == null) {
			if (other.showName != null)
				return false;
		} else if (!showName.equals(other.showName))
			return false;
		if (showType == null) {
			if (other.showType != null)
				return false;
		} else if (!showType.equals(other.showType))
			return false;
		return true;
	}

	public String getSchools() {
		return schools;
	}

	public void setSchools(String schools) {
		this.schools = schools;
	}

	public boolean isOneYear() {
		return oneYear;
	}

	public void setOneYear(boolean oneYear) {
		this.oneYear = oneYear;
	}

	public GroomerShow() {
		super();
	}

	public GroomerShow(String id) {
		super(id);
	}

	@Length(min = 0, max = 64, message = "赛事编号长度必须介于 0 和 64 之间")
	public String getShowCode() {
		return showCode;
	}

	public void setShowCode(String showCode) {
		this.showCode = showCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getEndTime() {
		return endTime;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	@Length(min = 0, max = 255, message = "活动名称长度必须介于 0 和 255 之间")
	public String getShowName() {
		return showName;
	}

	public void setShowName(String showName) {
		this.showName = showName;
	}

	@Length(min = 0, max = 255, message = "活动地点长度必须介于 0 和 255 之间")
	public String getShowAddress() {
		return showAddress;
	}

	public void setShowAddress(String showAddress) {
		this.showAddress = showAddress;
	}

	@Length(min = 0, max = 64, message = "活动类型长度必须介于 0 和 64 之间")
	public String getShowType() {
		return showType;
	}

	public void setShowType(String showType) {
		this.showType = showType;
	}

	@Length(min = 0, max = 20, message = "报名状态长度必须介于 0 和 20 之间")
	public String getRegisterState() {
		return registerState;
	}

	public void setRegisterState(String registerState) {
		this.registerState = registerState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getRegisterEndTime() {
		return registerEndTime;
	}

	public void setRegisterEndTime(Date registerEndTime) {
		this.registerEndTime = registerEndTime;
	}

	@Length(min = 0, max = 255, message = "专题链接长度必须介于 0 和 255 之间")
	public String getTopicLink() {
		return topicLink;
	}

	public void setTopicLink(String topicLink) {
		this.topicLink = topicLink;
	}

	@Length(min = 0, max = 255, message = "报名图片长度必须介于 0 和 255 之间")
	public String getRegisterImage() {
		return registerImage;
	}

	public void setRegisterImage(String registerImage) {
		this.registerImage = registerImage;
	}

	@Length(min = 0, max = 255, message = "回顾图片长度必须介于 0 和 255 之间")
	public String getReviewImage() {
		return reviewImage;
	}

	public void setReviewImage(String reviewImage) {
		this.reviewImage = reviewImage;
	}

	@Length(min = 0, max = 255, message = "专题图片长度必须介于 0 和 255 之间")
	public String getTopicImage() {
		return topicImage;
	}

	public void setTopicImage(String topicImage) {
		this.topicImage = topicImage;
	}

	@Length(min = 0, max = 100, message = "裁判id长度必须介于 0 和 100 之间")
	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	@Length(min = 0, max = 64, message = "酒店电话长度必须介于 0 和 64 之间")
	public String getHotelTel() {
		return hotelTel;
	}

	public void setHotelTel(String hotelTel) {
		this.hotelTel = hotelTel;
	}

	public String getShowIntroduce() {
		return showIntroduce;
	}

	public void setShowIntroduce(String showIntroduce) {
		this.showIntroduce = showIntroduce;
	}

	public String getVenueRoute() {
		return venueRoute;
	}

	public void setVenueRoute(String venueRoute) {
		this.venueRoute = venueRoute;
	}

	public String getAccommodationIntroduce() {
		return accommodationIntroduce;
	}

	public void setAccommodationIntroduce(String accommodationIntroduce) {
		this.accommodationIntroduce = accommodationIntroduce;
	}

	@Length(min = 0, max = 64, message = "时间表链接长度必须介于 0 和 64 之间")
	public String getTimeTableLink() {
		return timeTableLink;
	}

	public void setTimeTableLink(String timeTableLink) {
		this.timeTableLink = timeTableLink;
	}

	@Length(min = 0, max = 255, message = "赏励照链接长度必须介于 0 和 255 之间")
	public String getRewardImageLink() {
		return rewardImageLink;
	}

	public void setRewardImageLink(String rewardImageLink) {
		this.rewardImageLink = rewardImageLink;
	}

	@Length(min = 0, max = 255, message = "冠军登录链接长度必须介于 0 和 255 之间")
	public String getChampionQualifactionLink() {
		return championQualifactionLink;
	}

	public void setChampionQualifactionLink(String championQualifactionLink) {
		this.championQualifactionLink = championQualifactionLink;
	}

	@Length(min = 0, max = 255, message = "积分链接长度必须介于 0 和 255 之间")
	public String getCreditsLink() {
		return creditsLink;
	}

	public void setCreditsLink(String creditsLink) {
		this.creditsLink = creditsLink;
	}

	@Length(min = 0, max = 255, message = "报名优惠长度必须介于 0 和 255 之间")
	public String getDiscount() {
		return discount;
	}

	public void setDiscount(String discount) {
		this.discount = discount;
	}

	public String getFee() {
		return fee;
	}

	public void setFee(String fee) {
		this.fee = fee;
	}

	@Length(min = 0, max = 64, message = "考试级别长度必须介于 0 和 64 之间")
	public String getTestLevel() {
		return testLevel;
	}

	public void setTestLevel(String testLevel) {
		this.testLevel = StringEscapeUtils.unescapeHtml4(testLevel);
	}

	public Date getBeginDate() {
		return beginDate;
	}

	public void setBeginDate(Date beginDate) {
		this.beginDate = beginDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getRecommend() {
		return recommend;
	}

	public void setRecommend(String recommend) {
		this.recommend = recommend;
	}

	///////////////////////////////////// --------------统计-----------------------------/////////////////////

	private long dogNum; // 参赛犬只
	private long feeNum; // 总报名费收入
	private long memberNum;// 报名人数
	private long leaveNum;// 退赛人数
	private long cancel; // 请假人数
	private long cancelFeeNum;// 退赛费
	private long allFeeNum;// 实际总额
	private long allShow = 0;// 场次
	private long allfee = 0;// 收入总计
	private long shower = 0;// 报名人数

	public long getDogNum() {
		return dogNum;
	}

	public void setDogNum(long dogNum) {
		this.dogNum = dogNum;
	}

	public long getFeeNum() {
		return feeNum;
	}

	public void setFeeNum(long feeNum) {
		this.feeNum = feeNum;
	}

	public long getMemberNum() {
		return memberNum;
	}

	public void setMemberNum(long memberNum) {
		this.memberNum = memberNum;
	}

	public long getLeaveNum() {
		return leaveNum;
	}

	public void setLeaveNum(long leaveNum) {
		this.leaveNum = leaveNum;
	}

	public long getCancel() {
		return cancel;
	}

	public void setCancel(long cancel) {
		this.cancel = cancel;
	}

	public long getCancelFeeNum() {
		return cancelFeeNum;
	}

	public void setCancelFeeNum(long cancelFeeNum) {
		this.cancelFeeNum = cancelFeeNum;
	}

	public long getAllFeeNum() {
		return allFeeNum;
	}

	public void setAllFeeNum(long allFeeNum) {
		this.allFeeNum = allFeeNum;
	}

	public long getAllShow() {
		return allShow;
	}

	public void setAllShow(long allShow) {
		this.allShow = allShow;
	}

	public long getAllfee() {
		return allfee;
	}

	public void setAllfee(long allfee) {
		this.allfee = allfee;
	}

	public long getShower() {
		return shower;
	}

	public void setShower(long shower) {
		this.shower = shower;
	}

	public String getVenueId() {
		return venueId;
	}

	public void setVenueId(String venueId) {
		this.venueId = venueId;
	}

	public String getHotelId() {
		return hotelId;
	}

	public void setHotelId(String hotelId) {
		this.hotelId = hotelId;
	}

	public String getExcludeType() {
		return excludeType;
	}

	public void setExcludeType(String excludeType) {
		this.excludeType = excludeType;
	}

	public String getExcludeCode() {
		return excludeCode;
	}

	public void setExcludeCode(String excludeCode) {
		this.excludeCode = excludeCode;
	}

	public String getShowPhoto() {
		return showPhoto;
	}

	public void setShowPhoto(String showPhoto) {
		this.showPhoto = showPhoto;
	}

	@Length(min = 0, max = 64, message = "活动类别长度必须介于 0 和 64 之间")
	public String getShowCategory() {
		return showCategory;
	}

	public void setShowCategory(String showCategory) {
		this.showCategory = showCategory;
	}

	public String[] getShowTypeSpare() {
		return showTypeSpare;
	}

	public void setShowTypeSpare(String[] showTypeSpare) {
		this.showTypeSpare = showTypeSpare;
	}

	public String getRegisterType() {
		return registerType;
	}

	public void setRegisterType(String registerType) {
		this.registerType = registerType;
	}

	public Boolean getFreeFee() {
		return freeFee;
	}

	public void setFreeFee(Boolean freeFee) {
		this.freeFee = freeFee;
	}

}