/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import com.cku.oa.sys.entity.user.Member;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.common.utils.excel.annotation.ExcelField;
import com.thinkgem.jeesite.modules.sys.entity.User;
import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

/**
 * 美容师资格证书Entity
 * 
 * @author cxt
 * @version 2016-07-22
 */
public class FciGroomerQualificationCertificate extends DataEntity<FciGroomerQualificationCertificate> {

	private static final long serialVersionUID = 1L;

	@ExcelField(title = "会员号", align = 2, sort = 7)
	private String memberCode; // 会员号
	private String registerId; // 报名序号
	@ExcelField(title = "取证日期", align = 2, sort = 4)
	private Date takeCertificateDate; // 取证日期
	@ExcelField(title = "fci证书号", align = 2, sort = 6)
	private String fciCertificateCode; // fci证书编号
	private Date issueDate; // 签发日期
	private String printState; // 打印状态
	private String runningNumber; // 流水号
	private String paymentState; // 支付状态
	private Date paymentTime; // 支付时间
	private String isFree;// 0 免费 1收费
	private String certificateState; // 申领状态
	private String paper; // 0:纸质版 1:电子版
	private String certificateType;// 证书类型 资格证书、 高级 、宠物

	/**
	 * cku资格证书id
	 */
	private String certificateId;

	/**
	 * @SEE DogCategorysEnum
	 * 注册报名对应的组别
	 */
	private String dogCategorys;

	/**
	 * 裁判签名
	 */
	private String refereeSignaturePhotoBase64;
	/**
	 * @SEE DogCategorysEnum
	 * 注册报名对应的组别
	 */
	private String dogCategory;

	/**
	 * fci证书来源 1、cku增发 2、fci活动
	 */
	private String sourceType;

	/**
	 * 证书级别
	 * @return
	 */
	private String levelEn;

	private GroomerRegister groomerRegister;

	private GroomerShow groomerShow;

	private Member member;

	private String schoolType;

	private String referee;

	private String taskDate;



	public String getTaskDate() {
		return taskDate;
	}

	public void setTaskDate(String taskDate) {
		this.taskDate = taskDate;
	}

	public String getReferee() {
		return referee;
	}

	public void setReferee(String referee) {
		this.referee = referee;
	}

	public String getSchoolType() {
		return schoolType;
	}

	public void setSchoolType(String schoolType) {
		this.schoolType = schoolType;
	}

	public Member getMember() {
		return member;
	}

	public void setMember(Member member) {
		this.member = member;
	}

	public GroomerRegister getGroomerRegister() {
		return groomerRegister;
	}

	public void setGroomerRegister(GroomerRegister groomerRegister) {
		this.groomerRegister = groomerRegister;
	}

	public GroomerShow getGroomerShow() {
		return groomerShow;
	}

	public void setGroomerShow(GroomerShow groomerShow) {
		this.groomerShow = groomerShow;
	}

	public String getLevelEn() {
		return levelEn;
	}

	public void setLevelEn(String levelEn) {
		this.levelEn = levelEn;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public String getDogCategory() {
		return dogCategory;
	}

	public void setDogCategory(String dogCategory) {
		this.dogCategory = dogCategory;
	}

	public List<String> getRefereeSignaturePhotoBase64List() {
		return refereeSignaturePhotoBase64List;
	}

	public void setRefereeSignaturePhotoBase64List(List<String> refereeSignaturePhotoBase64List) {
		this.refereeSignaturePhotoBase64List = refereeSignaturePhotoBase64List;
	}

	/**
	 * 裁判签名集合
	 */
	private List<String> refereeSignaturePhotoBase64List;

	public FciGroomerQualificationCertificate() {
		super();
	}

	public FciGroomerQualificationCertificate(String id) {
		super(id);
	}

	public String getId() {
		return super.id;
	}

	public void setId(String id) {
		super.id = id;
	}

	@Length(min = 1, max = 100, message = "会员号长度必须介于 1 和 100 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	public String getRegisterId() {
		return registerId;
	}

	public void setRegisterId(String registerId) {
		this.registerId = registerId;
	}
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getTakeCertificateDate() {
		return takeCertificateDate;
	}

	public void setTakeCertificateDate(Date takeCertificateDate) {
		this.takeCertificateDate = takeCertificateDate;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getIssueDate() {
		return issueDate;
	}

	public void setIssueDate(Date issueDate) {
		this.issueDate = issueDate;
	}

	@Length(min = 0, max = 20, message = "打印状态长度必须介于 0 和 20 之间")
	public String getPrintState() {
		return printState;
	}

	public void setPrintState(String printState) {
		this.printState = printState;
	}
	@Length(min = 0, max = 64, message = "流水号长度必须介于 0 和 64 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 0, max = 64, message = "支付状态长度必须介于 0 和 64 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	public String getIsFree() {
		return isFree;
	}

	public void setIsFree(String isFree) {
		this.isFree = isFree;
	}

	public String getCertificateState() {
		return certificateState;
	}

	public void setCertificateState(String certificateState) {
		this.certificateState = certificateState;
	}

	public String getPaper() {
		return paper;
	}

	public void setPaper(String paper) {
		this.paper = paper;
	}

	public String getFciCertificateCode() {
		return fciCertificateCode;
	}

	public void setFciCertificateCode(String fciCertificateCode) {
		this.fciCertificateCode = fciCertificateCode;
	}

	public String getCertificateId() {
		return certificateId;
	}

	public void setCertificateId(String certificateId) {
		this.certificateId = certificateId;
	}

	public String getCertificateType() {
		return certificateType;
	}

	public void setCertificateType(String certificateType) {
		this.certificateType = certificateType;
	}

	public String getDogCategorys() {
		return dogCategorys;
	}

	public void setDogCategorys(String dogCategorys) {
		this.dogCategorys = dogCategorys;
	}

	public String getRefereeSignaturePhotoBase64() {
		return refereeSignaturePhotoBase64;
	}

	public void setRefereeSignaturePhotoBase64(String refereeSignaturePhotoBase64) {
		this.refereeSignaturePhotoBase64 = refereeSignaturePhotoBase64;
	}
}