package com.cku.oa.dog.service;

import java.util.List;
import java.util.Objects;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogNoseCheckinDao;
import com.cku.oa.dog.entity.DogNoseCheckin;
import com.cku.restful.v1.dogNose.enums.NoseCheckinStatusEnum;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 鼻纹识别登记Service
 * @author Sunny
 * @version 2021-04-14
 */
@Service
@Transactional(readOnly = true)
public class DogNoseCheckinService extends CrudService<DogNoseCheckinDao, DogNoseCheckin> {

	public DogNoseCheckin get(String id) {
		return super.get(id);
	}
	
	public List<DogNoseCheckin> findList(DogNoseCheckin dogNoseCheckin) {
		return super.findList(dogNoseCheckin);
	}
	
	public Page<DogNoseCheckin> findPage(Page<DogNoseCheckin> page, DogNoseCheckin dogNoseCheckin) {
		return super.findPage(page, dogNoseCheckin);
	}
	
	@Transactional(readOnly = false)
	public void save(DogNoseCheckin dogNoseCheckin) {
		super.save(dogNoseCheckin);
	}
	
	@Transactional(readOnly = false)
	public void delete(DogNoseCheckin dogNoseCheckin) {
		super.delete(dogNoseCheckin);
	}
	
	public String findNoseCodeByNoseId(String noseId) {
		DogNoseCheckin dogNoseCheckin = dao.selectByNoseId(noseId);
		if(Objects.isNull(dogNoseCheckin)) {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"未查询到鼻纹识别记录");
		}
		if(NoseCheckinStatusEnum.SUCCESS.code().equals(dogNoseCheckin.getCheckinStatus())) {
			return dogNoseCheckin.getNoseCode();
		}else {
			throw new ZAException(ZAErrorCode.ZA_ERROR,"鼻纹识别未成功，无法获取识别号");
		}
	}

}