/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.entity;

import java.util.Date;

import org.hibernate.validator.constraints.Length;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 犬只精子Entity
 *
 * @author lgl
 * @version 2017-08-28
 */
public class DogSemen extends DataEntity<DogSemen> {

	private static final long serialVersionUID = 1L;
	private String dogId; // 犬只表主键
	private String pedigreeCertified; // 犬只血统证书号
	private String dogChip; // 犬只芯片
	private String dogBreed; // 犬种号
	private String dogName; // 犬名
	private String semenBatchCode; // 冷冻精子批次号
	private String memberCode; // 犬主人会员号
	private String memberName; // 犬主人姓名
	private String originalSemenCode; // 原精子编号
	private String semenCode; // CKU精子编号
	private Date acquisitionTime; // 采集时间
	private String breedCertifiedCode; // 配种证明编号
	private String runningNumber; // 流水号
	private String paymentState; // 付款的状态
	private Date paymentTime; // 付款时间
	private String reviewState; // 审核状态
	private Date reviewTime; // 审核时间
	private String reviewRemarks; // 审核的意见
	private String processState; // 流程状态
	private Date processTime; // 流程变更的时间
	private String keyword; // cku证书号或者cku精子编号

	public String getKeyword() {
		return keyword;
	}

	public void setKeyword(String keyword) {
		this.keyword = keyword;
	}

	public DogSemen() {
		super();
	}

	public DogSemen(String id) {
		super(id);
	}

	@Length(min = 1, max = 64, message = "犬只表主键长度必须介于 1 和 64 之间")
	public String getDogId() {
		return dogId;
	}

	public void setDogId(String dogId) {
		this.dogId = dogId;
	}

	@Length(min = 1, max = 64, message = "犬只血统证书号长度必须介于 1 和 64 之间")
	public String getPedigreeCertified() {
		return pedigreeCertified;
	}

	public void setPedigreeCertified(String pedigreeCertified) {
		this.pedigreeCertified = pedigreeCertified;
	}

	@Length(min = 1, max = 64, message = "犬只芯片长度必须介于 1 和 64 之间")
	public String getDogChip() {
		return dogChip;
	}

	public void setDogChip(String dogChip) {
		this.dogChip = dogChip;
	}

	@Length(min = 1, max = 64, message = "犬种号长度必须介于 1 和 64 之间")
	public String getDogBreed() {
		return dogBreed;
	}

	public void setDogBreed(String dogBreed) {
		this.dogBreed = dogBreed;
	}

	@Length(min = 1, max = 64, message = "犬名长度必须介于 1 和 64 之间")
	public String getDogName() {
		return dogName;
	}

	public void setDogName(String dogName) {
		this.dogName = dogName;
	}

	@Length(min = 1, max = 64, message = "冷冻精子批次号长度必须介于 1 和 64 之间")
	public String getSemenBatchCode() {
		return semenBatchCode;
	}

	public void setSemenBatchCode(String semenBatchCode) {
		this.semenBatchCode = semenBatchCode;
	}

	@Length(min = 1, max = 64, message = "犬主人会员号长度必须介于 1 和 64 之间")
	public String getMemberCode() {
		return memberCode;
	}

	public void setMemberCode(String memberCode) {
		this.memberCode = memberCode;
	}

	@Length(min = 1, max = 64, message = "犬主人姓名长度必须介于 1 和 64 之间")
	public String getMemberName() {
		return memberName;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public String getOriginalSemenCode() {
		return originalSemenCode;
	}

	public void setOriginalSemenCode(String originalSemenCode) {
		this.originalSemenCode = originalSemenCode;
	}

	public String getSemenCode() {
		return semenCode;
	}

	public void setSemenCode(String semenCode) {
		this.semenCode = semenCode;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getAcquisitionTime() {
		return acquisitionTime;
	}

	public void setAcquisitionTime(Date acquisitionTime) {
		this.acquisitionTime = acquisitionTime;
	}

	@Length(min = 1, max = 64, message = "配种证明编号长度必须介于 1 和 64 之间")
	public String getBreedCertifiedCode() {
		return breedCertifiedCode;
	}

	public void setBreedCertifiedCode(String breedCertifiedCode) {
		this.breedCertifiedCode = breedCertifiedCode;
	}

	@Length(min = 1, max = 100, message = "流水号长度必须介于 1 和 100 之间")
	public String getRunningNumber() {
		return runningNumber;
	}

	public void setRunningNumber(String runningNumber) {
		this.runningNumber = runningNumber;
	}

	@Length(min = 1, max = 20, message = "付款的状态长度必须介于 1 和 20 之间")
	public String getPaymentState() {
		return paymentState;
	}

	public void setPaymentState(String paymentState) {
		this.paymentState = paymentState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getPaymentTime() {
		return paymentTime;
	}

	public void setPaymentTime(Date paymentTime) {
		this.paymentTime = paymentTime;
	}

	@Length(min = 1, max = 20, message = "审核状态长度必须介于 1 和 20 之间")
	public String getReviewState() {
		return reviewState;
	}

	public void setReviewState(String reviewState) {
		this.reviewState = reviewState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReviewTime() {
		return reviewTime;
	}

	public void setReviewTime(Date reviewTime) {
		this.reviewTime = reviewTime;
	}

	@Length(min = 1, max = 200, message = "审核的意见长度必须介于 1 和 200 之间")
	public String getReviewRemarks() {
		return reviewRemarks;
	}

	public void setReviewRemarks(String reviewRemarks) {
		this.reviewRemarks = reviewRemarks;
	}

	@Length(min = 1, max = 20, message = "流程状态长度必须介于 1 和 20 之间")
	public String getProcessState() {
		return processState;
	}

	public void setProcessState(String processState) {
		this.processState = processState;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getProcessTime() {
		return processTime;
	}

	public void setProcessTime(Date processTime) {
		this.processTime = processTime;
	}

	// 后台查询条件
	private String semenBatchCodeLike; // 冷冻精子批次号模糊查询条件
	private String pedigreeCertifiedAndDogChipLike; // 血统证书号和芯片号模糊查询条件
	private String semenCodeLike; // CKU精子编号模糊查询条件
	private String memberCodeAndMemberNameLike; // 会员号和会员姓名模糊查询条件
	private String dogBreedLike; // 犬种号模糊查询条件
	private String dogNameLike; // 犬名模糊查询条件
	private String haveSemenCode; // 有精子编号：0无精子编号；1有精子编号

	public String getSemenBatchCodeLike() {
		return semenBatchCodeLike;
	}

	public void setSemenBatchCodeLike(String semenBatchCodeLike) {
		this.semenBatchCodeLike = semenBatchCodeLike;
	}

	public String getPedigreeCertifiedAndDogChipLike() {
		return pedigreeCertifiedAndDogChipLike;
	}

	public void setPedigreeCertifiedAndDogChipLike(String pedigreeCertifiedAndDogChipLike) {
		this.pedigreeCertifiedAndDogChipLike = pedigreeCertifiedAndDogChipLike;
	}

	public String getSemenCodeLike() {
		return semenCodeLike;
	}

	public void setSemenCodeLike(String semenCodeLike) {
		this.semenCodeLike = semenCodeLike;
	}

	public String getMemberCodeAndMemberNameLike() {
		return memberCodeAndMemberNameLike;
	}

	public void setMemberCodeAndMemberNameLike(String memberCodeAndMemberNameLike) {
		this.memberCodeAndMemberNameLike = memberCodeAndMemberNameLike;
	}

	public String getDogBreedLike() {
		return dogBreedLike;
	}

	public void setDogBreedLike(String dogBreedLike) {
		this.dogBreedLike = dogBreedLike;
	}

	public String getDogNameLike() {
		return dogNameLike;
	}

	public void setDogNameLike(String dogNameLike) {
		this.dogNameLike = dogNameLike;
	}

	public String getHaveSemenCode() {
		return haveSemenCode;
	}

	public void setHaveSemenCode(String haveSemenCode) {
		this.haveSemenCode = haveSemenCode;
	}
}