package com.cku.oa.components.rule.validation.dog;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogBreedCertifiedDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBreedCertified;
import com.cku.oa.dog.entity.DogNewborn;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * Created by laiguanglong on 2017/4/24.
 */
@Component
public class DogNewbornCondition {

    @Autowired
    private DogNewbornDao dogNewbornDao;
    @Autowired
    private DogBreedCertifiedDao dogBreedCertifiedDao;

    /**
     * @description: 是否母犬在最近的X个月里没有配种
     * @author: laiguanglong
     * @date: 2017/4/27 15:27
     */
    public boolean isMotherDogNotBreedInXMounth(DogNewborn po, Integer x) {
        boolean flag = true;
        if (po != null
                && StringUtils.isNotBlank(po.getFemalePedigreeCertified())
                && po.getBreedDate() != null
                && x != null
                && x > 0) {
            Calendar startDay = Calendar.getInstance();
            startDay.setTime(po.getBreedDate());
            startDay.add(Calendar.MONTH, -x);
            Calendar endDay = Calendar.getInstance();
            endDay.setTime(po.getBreedDate());
            endDay.add(Calendar.MONTH, x);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            int count = dogNewbornDao.getByFemalePedigreeCertified(po.getFemalePedigreeCertified(), sdf.format(startDay.getTime()), sdf.format(endDay.getTime()), po.getId());
            if (count > 0) {
                return false;
            }
        }
        return flag;
    }

    /**
     * @description: 是否配种日期是在当前时间之前
     * @author: laiguanglong
     * @date: 2017/4/27 15:54
     */
    public boolean isBreedDateBeforeNow(Date breedDate) {
        boolean flag = false;
        if (breedDate != null
                && breedDate.getTime() < System.currentTimeMillis()) {
            flag = true;
        }
        return flag;
    }

    /**
     * @description: 是否藏獒配种日期当年没有配种
     * @author: laiguanglong
     * @date: 2017/4/27 16:38
     */
    public boolean isZangaoNotBreedThatYear(DogNewborn po) {
        boolean flag = true;
        if (po != null
                && StringUtils.isNotBlank(po.getFemalePedigreeCertified())
                && po.getBreedDate() != null) {
            SimpleDateFormat sdfZangao = new SimpleDateFormat("yyyy");
            int countZangao = dogNewbornDao.getByFemalePedigreeCertifiedZangao(po.getFemalePedigreeCertified(), sdfZangao.format(po.getBreedDate()), po.getId());
            if (countZangao > 0) {
                flag = false;
            }
        }
        return flag;
    }

    /**
     * @description: 藏獒校验繁育证书
     * @author: laiguanglong
     * 出生日期在2016年1月1日之后的藏獒申请配种证明需取得繁育证书
     * @date: 2017/4/27 17:12
     */
    public boolean validateZangaoDogBreedCertified(Dog fatherDog, Dog motherDog) {
        boolean flag = true;
        if (fatherDog == null
                || motherDog == null
                || fatherDog.getBirthdate() == null
                || motherDog.getBirthdate() == null
                || StringUtils.isBlank(fatherDog.getId())
                || StringUtils.isBlank(motherDog.getId())) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date date;
        try {
            date = sdf.parse("20160101");
        } catch (ParseException e) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "格式化20160101日期出错，请联系协会");
        }
        if (fatherDog.getBirthdate().getTime() > date.getTime()) {
            DogBreedCertified dogBreedCertified = dogBreedCertifiedDao.getByDogId(fatherDog.getId());
            if (dogBreedCertified == null || com.thinkgem.jeesite.common.utils.StringUtils.isBlank(dogBreedCertified.getBreedCertifiedCode())) {
                return false;
            }
        }
        if (motherDog.getBirthdate().getTime() > date.getTime()) {
            DogBreedCertified dogBreedCertified = dogBreedCertifiedDao.getByDogId(motherDog.getId());
            if (dogBreedCertified == null || com.thinkgem.jeesite.common.utils.StringUtils.isBlank(dogBreedCertified.getBreedCertifiedCode())) {
                return false;
            }
        }
        return flag;
    }
}