package com.cku.oa.clubdog.service;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.clubdog.dao.ClubDogDao;
import com.cku.oa.clubdog.entity.ClubDog;
import com.cku.oa.kennel.dao.KennelDao;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.sys.code.SysCodeUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 淘宠宝犬只信息Service
 * @author cxt
 * @version 2017-10-12
 */
@Service
@Transactional(readOnly = true)
public class ClubDogService extends CrudService<ClubDogDao, ClubDog> {
	
	@Autowired
	private KennelDao kennelDao;
	
	public ClubDog get(String id) {
		return super.get(id);
	}
	
	public List<ClubDog> findList(ClubDog clubDog) {
		return super.findList(clubDog);
	}
	
	public Page<ClubDog> findPage(Page<ClubDog> page, ClubDog clubDog) {
		return super.findPage(page, clubDog);
	}
	
	@Transactional(readOnly = false)
	public void save(ClubDog clubDog) {
		if(StringUtils.isBlank(clubDog.getId())){//初始化状态
			clubDog.setPaymentState("1");
			clubDog.setReviewState("0");
			clubDog.setProcessState("0");
			clubDog.setPrintState("0");
			clubDog.setFirstPrint("0");
			Kennel kennel = kennelDao.getKennelByMemberCode(clubDog.getMemberCode());
			if(kennel==null){
				clubDog.setNameEn(clubDog.getNameEn()+" of Shang Hai Public Kennel");
			}else{
				clubDog.setNameEn(clubDog.getNameEn()+" of "+kennel.getNameEn());
			}
		}
		super.save(clubDog);
	}
	
	@Transactional(readOnly = false)
	public void delete(ClubDog clubDog) {
		super.delete(clubDog);
	}

	
	/**
	 * 淘宠宝地方俱乐部缴费后自动审核生成证书
	 * @Author chaixueteng
	 * @2017年10月13日下午2:34:48
	 */
	public  void clubDogToCreate(StringBuffer buffer, String businessIds) {
		ClubDog clubDog = super.get(businessIds);
        String pedigreeCertified = SysCodeUtil.getClubPedigreeCertifiedCode(clubDog.getDogBreed());
        clubDog.setPedigreeCertifiedCode(pedigreeCertified);
		clubDog.setReviewState("1");
		clubDog.setReviewTime(new Date());
		clubDog.setReviewRemarks("缴费自动审核");
		clubDog.setProcessState("1");
		clubDog.setProcessTime(new Date());
        User u = UserUtils.getLoginUser();
		if (u!=null) {
			clubDog.setOperator(u.getName()+":"+DateUtils.formatDate(new Date(), "yyyy-MM-dd"));//操作人
		}
		super.save(clubDog);
    	buffer.append("UPDATE club_dog SET payment_state = 2,payment_time = now() WHERE id = '").append(businessIds).append("'");
	}

	/**
	 * 查询芯片
	 * @Author chaixueteng
	 * @2017年10月17日上午11:00:40
	 */
	public ClubDog getByIdentificationFlag(String identificationFlag) {
		return dao.getByIdentificationFlag(identificationFlag.trim());
	}

	/**
	 * 查询证书
	 * @Author chaixueteng
	 * @2017年10月18日上午10:36:43
	 */
	public ClubDog getByPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		return dao.getByPedigreeCertifiedCode(pedigreeCertifiedCode.trim());
	}
	
}