/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.breeder.dao;

import com.cku.oa.breeder.entity.Pup;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 幼犬信息表DAO接口
 *
 * @author lgl
 * @version 2018-01-12
 */
@MyBatisDao
public interface PupDao extends CrudDao<Pup> {
    List<Pup> getByMemberCode(@Param("memberCode") String memberCode,
                              @Param("pageNo") Integer pageNo,
                              @Param("pageSize") Integer pageSize);

    long getCountByMemberCode(@Param("memberCode") String memberCode);

    List<Pup> search(Map map);

    long getSearchCount(Map map);

    int addViewCount(@Param("id") String id);

    List<Pup> topList(@Param("pageSize") Integer pageSize);
}