package com.cku.config;

import java.io.InputStream;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import com.cku.restful.v1.sys.utils.WXSignUtils;
import com.github.wxpay.sdk.WXPayConfig;

import lombok.Data;

@Data
@Configuration
public class WxPayConfig implements WXPayConfig {

	@Value("${appid}")
	private String appID;

	@Value("${mch_id}")
	private String mchID;

	private String key = WXSignUtils.Key;

	private String secret;

	private String certFile;

	@Override
	public InputStream getCertStream() {

		try {
			return new PathMatchingResourcePatternResolver().getResources(this.getCertFile())[0].getInputStream();
		}
		catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public int getHttpConnectTimeoutMs() {
		return 0;
	}

	@Override
	public int getHttpReadTimeoutMs() {
		return 0;
	}
	
}
