/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.apidoc.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 接口Entity
 * @author fanhuibin
 * @version 2016-09-06
 */
public class ApiInterface extends DataEntity<ApiInterface> {
	
	private static final long serialVersionUID = 1L;
	private String interName;		// inter_name
	private String interUrl;		// inter_url
	private String interOwn;		// inter_own
	private Date createTime;		// create_time
	private String description;		// 接口描述
	private String version;		// version
	private String method;		// 请求方式
	private String categoryId;		// category_id
	private String params;		// 参数信息
    private List<ApiParams> paramList; 
	
	public List<ApiParams> getParamList() {
		return paramList;
	}

	public void setParamList(List<ApiParams> paramList) {
		this.paramList = paramList;
	}

	public ApiInterface() {
		super();
	}

	public ApiInterface(String id){
		super(id);
	}

	@Length(min=0, max=50, message="inter_name长度必须介于 0 和 50 之间")
	public String getInterName() {
		return interName;
	}

	public void setInterName(String interName) {
		this.interName = interName;
	}
	
	@Length(min=0, max=50, message="inter_url长度必须介于 0 和 50 之间")
	public String getInterUrl() {
		return interUrl;
	}

	public void setInterUrl(String interUrl) {
		this.interUrl = interUrl;
	}
	
	@Length(min=0, max=50, message="inter_own长度必须介于 0 和 50 之间")
	public String getInterOwn() {
		return interOwn;
	}

	public void setInterOwn(String interOwn) {
		this.interOwn = interOwn;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	@Length(min=0, max=11, message="version长度必须介于 0 和 11 之间")
	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}
	
	@Length(min=0, max=30, message="请求方式长度必须介于 0 和 30 之间")
	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}
	
	@Length(min=0, max=11, message="category_id长度必须介于 0 和 11 之间")
	public String getCategoryId() {
		return categoryId;
	}

	public void setCategoryId(String categoryId) {
		this.categoryId = categoryId;
	}
	
	public String getParams() {
		return params;
	}

	public void setParams(String params) {
		this.params = params;
	}
	
}