//商城订单
define(["knockout"],function(ko){
    return function(context){
        var me = this;

        me.shopOrderList = ko.observableArray([]);
        //支付状态：未支付1；已支付2
        me.paymentState = ko.observable("");
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);
        //页码列表
        me.pageArray = ko.observableArray();
        //商城购物车
        me.shopGoodList = ko.observableArray([]);
        me.shopNum = ko.observable("0");
        me.shopTotalPrice = ko.observable("0");
        //订单数量
        me.paymentStateAllTotal = ko.observable("0");
        me.paymentState1Total = ko.observable("0");
        me.paymentState2Total = ko.observable("0");
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findShopOrderList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findShopOrderList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findShopOrderList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findShopOrderList(false);
            }
            return false;
        }
        /**
         * 跳转到详情
         * @param data
         */
        me.toDetail = function(data){
            location.href = location.href.split("#")[0]+"#/shop/orderdetail?id="+data.id;
        }
        /**
         * 展现收费方式
         * @param data
         */
        me.toPayment = function(data){
            if(data.paymentState=='未缴费'){
                location.href = location.href.split("#")[0]+"#/payment/payment?id="+data.id+"&type=shop";
            }

        }
        /**
         * 订单状态切换
         * @param type
         */
        me.changePaymentState = function(type){
            $("#paymentStateAll").removeClass("active");
            $("#paymentState1").removeClass("active");
            $("#paymentState2").removeClass("active");
            if(type==""){
                $("#paymentStateAll").addClass("active");
            }else if(type=="1"){
                $("#paymentState1").addClass("active");
            }else{
                $("#paymentState2").addClass("active");
            }
            me.paymentStateAllTotal("0");
            me.paymentState1Total("0");
            me.paymentState2Total("0");
            me.paymentState(type);
            me.findShopOrderList(true);
        }
        /**
         * 查询订单
         */
        me.findShopOrderList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["paymentState"] = me.paymentState();
            sendData["pageNo"] = me.pageNo();
            sendData["pageSize"] = me.pageSize();
            util.sendAjax({
                url:'shop/shopOrder',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.list!=null && json.list.length>0){
                            var list = json.list;
                            me.shopOrderList(list);
                            for(var i=0;i<list.length;i++){
                                if(list[i].paymentState=="未缴费"){
                                    me.paymentState1Total(parseInt(me.paymentState1Total())+1);
                                }else{
                                    me.paymentState2Total(parseInt(me.paymentState2Total())+1);
                                }
                                me.paymentStateAllTotal(parseInt(me.paymentStateAllTotal())+1);
                            }
                        }else{
                            me.shopOrderList([]);
                            layer.msg("订单列表数据为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),json.total,me.pageSize()));
                    }else{
                        layer.msg("查询订单失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });
        }
        /**
         * 展现购物车
         */
        me.showCarts = function(){
            if($("#cartsDiv").css("display")=="none"){
                $("#cartsDiv").css("display","block");
            }else{
                $("#cartsDiv").css("display","none");
            }
        }
        $(function(){
            me.findShopOrderList(false);
            me.shopGoodList(context.app.shopGoodList());
            me.shopNum(context.app.shopNum());
            me.shopTotalPrice(context.app.shopTotalPrice());
        })
        //什么都没干，就是个演示
        context.app.loading(false);
        context.app.isShop(true);
    }
});