//订单列表页
define(["knockout"],function(ko){
    return function(context){
        var me = this;
        //订单状态
        me.paymentState = ko.observable("");
        //订单列表数据
        me.listData = ko.observableArray([]);
        //订单详情列表
        me.listDataItem = ko.observable({
            paymentWay:''
        });
        me.listDataItem2 = ko.observableArray([]);
        me.orderMaskVisble = ko.observable(false);
        me.orderMaskVisble2 = ko.observable(false);
        //每页多少条数据
        me.pageSize = ko.observable(10);
        //第几页
        me.pageNo = ko.observable(1);

        me.businessId = ko.observable("");
        me.orderCode = ko.observable("");

        var itemData = {};
        //页码列表
        me.pageArray = ko.observableArray();
        //上一页
        me.pagePre = function(){
            if(me.pageNo()>1){
                me.pageNo(me.pageNo()-1);
            }
            me.findorderList(false);
        }

        me.pageNext = function(){
            if(me.pageNo()<parseInt(me.pageArray().pop()["pageNo"])){
                me.pageNo(me.pageNo()+1);
            }

            me.findorderList(false);
        }

        me.pageAction = function(data){
            if(data.pageNo == -1){
                //什么都不做
            }else if(me.pageNo() == data.pageNo){
                //alert("当前选中的就是该页");
                me.findorderList(false);
            }else{
                //alert(data.pageNo);//做一些分页啥的
                me.pageNo(data.pageNo);
                me.findorderList(false);
            }
            return false;
        }
        /**
         * 展现收费方式
         * @param data
         */
        me.toPayment = function(data){
            if(data.paymentState=='1'){
                location.href = location.href.split("#")[0]+"#/payment/payment?id="+data.id+"&type=order";
            }

        }
        /**
         * 改变状态
         * @param type
         */
        me.changeType = function(type){
            $("#totalAll").removeClass("active");
            $("#total1").removeClass("active");
            $("#total2").removeClass("active");
            if(type==""){
                $("#totalAll").addClass("active");
            }else if(type=="1"){
                $("#total1").addClass("active");
            }else{
                $("#total2").addClass("active");
            }
            me.paymentState(type);
            me.findorderList(true);
        }
        /**
         * 删除订单
         */
        me.delOrder = function(data){
            //询问框
            var delOrderLayer=layer.confirm('确认删除此订单么！', {
                btn: ['确定','关闭'] //按钮
            }, function(){
                util.sendAjax({
                    url:'finance/order/'+data.id,
                    data:{},
                    async:true,
                    loadFlag:true,
                    type:'DELETE',
                    cache:false,
                    success:function(json){
                        layer.close(delOrderLayer);
                        if(json.rc==0){
                            me.findorderList(true);
                            //解决删除犬舍注册订单后点击我的犬舍页面由于个人信息没有更新导致还显示犬舍信息
                            userInfo.refresh();
                        }else{
                            layer.msg("删除订单失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                        }
                    }
                });
            })
        }
        //展现详细数据
        me.showDetail = function(data){
            itemData = data;
            me.listDataItem(data);
            me.orderMaskVisble(true);
            // var html = '<div class="orderpop">'+
            //     '<p>会员号<span>'+data.memberCode+'</span>会员名称<span>'+data.memberName+'</span>支付方式<span>'+(data.paymentWay==''?'无':data.paymentWay)+'</span></span>支付状态<span><strong class="green">'+data.paymentStateName+'</strong></span></p>'+
            //     '<p>订单编号<span>'+data.orderCode+'</span>订单总金额<span>'+data.totalPrice+'元</span>提交时间<span>'+data.addTime+'</span></p>'+
            //     '<table><thead><tr><th>业务编号</th><th>业务名称</th><th>业务数量</th><th>业务价格</th><th>售后</th></tr></thead>'+
            //     '<tbody>';
            // if(data.items!=null && data.items.length>0){
            //     $.each(data.items,function(index,item){
            //         html+='<tr><td>'+item.chargingItemId+'</td><td>';
            //         html+=item.chargingItemName;
            //         html+='</td><td>'+item.num+'</td><td>'+item.price+'</td><td><a class="applyForA" href="javascript:void(0);" item="'+ item +'" data-bind="click:$parent.showDetail2">申请</a></td></tr>';
            //     });
            // }
            //
            // html+='</tbody></table></div>';
            // layer.open({
            //     title:'订单详细',
            //     area: ['800px', '500px'],
            //     content:html
            // });
        }
        me.closeOrderMask = function(){
            me.orderMaskVisble(false);
        }
        me.closeOrderMask2 = function(){
            me.orderMaskVisble2(false);
        }
        me.showDetail2 = function(b,item){
            me.orderCode('');
            me.businessId('');
            var  sendData = {
                orderCode:b,
                businessId:item.chargingItemId
            };
            util.sendAjax({
                url:'open/refund/refundApply',
                data:JSON.stringify(sendData),
                async:true,
                loadFlag:true,
                type:'POST',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        me.listDataItem2(json.data);
                        me.orderMaskVisble2(true);
                        me.orderCode(b);
                        me.businessId(item.chargingItemId);
                    }else{
                        layer.msg(json.msg);
                        me.orderCode(b);
                        me.businessId(item.chargingItemId);
                    }
                }
            });



            // layer.open({
            //     title:'订单详细',
            //     area: ['800px', '500px'],
            //     content:html
            // });
        }
        me.applyRefund = function(data){
            //页面层-自定义
            var html = "<div style='padding: 30px;line-height: 50px;text-align: center;'>"+
                '<p>业务退款后将停止办理，确认继续退款？</p>'+
                "<p>退款原因：<select class='refundSelect'><option value='0'>请选择退款原因</option><option value='业务信息填写错误'>业务信息填写错误</option><option value='参赛犬只赛前退费'>参赛犬只赛前退费</option><option value='参赛犬只赛场请假'>参赛犬只赛场请假</option><option value='美容考试赛前退费'>美容考试赛前退费</option></select></p>"+
                "</div>";

            var sendData = {
                orderCode:me.orderCode(),
                businessId:me.businessId(),
                businessIds:data.id,
                businessRefundReason:''
            };
            var applyRefundLayer  = layer.open({
                type: 1,
                title: false,
                closeBtn: 0,
                shadeClose: false,
                content: html,
                area: ['369px', '214px'],
                btn: ['确认退款', '关闭返回'],
                btnAlign: 'c'
                ,yes: function(index, layero){
                    sendData.businessRefundReason = $('.refundSelect').val();
                    if(sendData.businessRefundReason == 0){
                        layer.msg("请选择退款原因")
                        return
                    }
                    util.sendAjax({
                        url:'open/refund/refundApplyOperation',
                        data:JSON.stringify(sendData),
                        async:true,
                        loadFlag:true,
                        type:'POST',
                        cache:false,
                        success:function(json){
                            if(json.rc==0){
                                layer.close(applyRefundLayer);
                                me.orderMaskVisble2(false);
                                layer.msg("申请成功");
                                console.log(me.orderCode(),me.businessId())
                                me.showDetail2(me.orderCode(),{chargingItemId:me.businessId()});
                            }else{
                                layer.msg(json.msg);
                            }
                        }
                    });

                }
                ,btn2: function(index, layero){
                    //return false 开启该代码可禁止点击该按钮关闭
                }
            });
        }
        /**
         * 查询订单
         * @param isreset
         */
        me.findorderList = function(isreset){
            if(isreset){
                me.pageNo(1);
            };
            var sendData = {};
            sendData["paymentState"] = me.paymentState();
            sendData["pageSize"] = me.pageSize();
            sendData["pageNo"] = me.pageNo();
            util.sendAjax({
                url:'finance/order',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(json){
                    if(json.rc==0){
                        if(json.list!=null && json.list.length>0){
                            me.listData(json.list);
                        }else{
                            me.listData([]);
                            layer.msg("订单列表数据为空！");
                        }
                        //计算总页数和分页的参数
                        me.pageArray(util.getPageArray(me.pageNo(),json.total,me.pageSize()));
                    }else{
                        layer.msg("查询订单失败,错误代码:"+json.rc+"错误信息:"+json.msg);
                    }
                }
            });

        }
        $(function(){
            me.findorderList(false);
        })
        //什么都没干，就是个演示
        context.app.loading(false);
        context.app.isShop(false);
    }
});