require.config({
	baseUrl: 'scripts',
	paths: {
    "jquery": "lib/jquery-1.9.1",
    "jquery.cookie":"lib/jquery.cookie",
    "text": "lib/text",
    "knockout":"lib/knockout-3.1.0.debug",
    "ko-amd":"lib/knockout-amd-helpers",
    "sammy":"lib/sammy-0.7.4",
    "layer":"lib/layer/layer",
    "util":"lib/util",
    "My97DatePicker":"lib/My97DatePicker/WdatePicker",
    "app":"modules/app",
    "userService":"lib/service/user",
        "select2":"lib/select2.full",
        "cropper":'lib/Cropper3.1.3.min',
        "citySelect":"lib/citySelect",
        "canvasToBlob":"lib/canvas-to-blob"
  },
  shim: {
    "jquery":{
      exports:"jquery"
    },
    "layer":{
      deps:["jquery"]
    },
    "jquery.pagination":{
      deps:["jquery"]
    },
    "sammy": {
      deps:["jquery"]
    }
  }
});

require(["knockout", "app", "ko-amd","layer","util","jquery.cookie","My97DatePicker","userService","select2","cropper","citySelect","canvasToBlob"], function(ko, app){
	ko.bindingHandlers.module.baseDir = "modules";
	ko.amdTemplateEngine.defaultPath = "templates";
    ko.bindingHandlers.select2 = {
        init: function(element, valueAccessor, allBindingsAccessor) {
            var obj = valueAccessor(),
                allBindings = allBindingsAccessor(),
                lookupKey = allBindings.lookupKey;
            $(element).select2();

            if (lookupKey) {
                var value = ko.utils.unwrapObservable(allBindings.value);
                $(element).select2('data', ko.utils.arrayFirst(obj.data.results, function(item) {
                    return item[lookupKey] === value;
                }));
            }

            ko.utils.domNodeDisposal.addDisposeCallback(element, function() {
                $(element).select2('destroy');
            });
        },
        update: function (element, valueAccessor, allBindingsAccessor) {
            $(element).on("change", function () {
                var id = $(this).val();
                var valAccesor = valueAccessor();
                if (valAccesor && id && id > 0)
                    valAccesor(id);
            });
        }
    };
	ko.applyBindings(new app());
});