<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>敏感词管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/badword/demandSensitiveWord/">敏感词列表</a></li>
		<shiro:hasPermission name="badword:demandSensitiveWord:edit"><li><a href="${ctx}/badword/demandSensitiveWord/form">敏感词添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="demandSensitiveWord" action="${ctx}/badword/demandSensitiveWord/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>敏感词：</label>
				<form:input path="badWord" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>id</th>
				<th>敏感词</th>
				<shiro:hasPermission name="badword:demandSensitiveWord:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="demandSensitiveWord">
			<tr>
				<td><a href="${ctx}/badword/demandSensitiveWord/form?id=${demandSensitiveWord.id}">
					${demandSensitiveWord.id}
				</a></td>
				<td>
					${demandSensitiveWord.badWord}
				</td>
				<shiro:hasPermission name="badword:demandSensitiveWord:edit"><td>
    				<a href="${ctx}/badword/demandSensitiveWord/form?id=${demandSensitiveWord.id}">修改</a>
					<a href="${ctx}/badword/demandSensitiveWord/delete?id=${demandSensitiveWord.id}" onclick="return confirmx('确认要删除该敏感词吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>