<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxDc}/user/member/">会员列表</a></li>
		<li class="active"><a href="#">会员详情</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="member" action="${ctx}/sys/user/member/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>	
		<h3>会员基本信息</h3>
		<div class="control-group" style="width:80%">
			<label class="control-label">1寸照：</label> 
			<div class="controls">
				<img alt="证件照" style="max-width:200px;" src="${ctx }/sys/file/image/${member.avatar }">
			</div>
		</div>
		<div style="clear:both;"></div>
		<div class="control-group">
			<label class="control-label">会员编号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-xlarge required" readonly="true"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge required" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">姓名拼音：</label>
			<div class="controls">
				<form:input path="nameEn" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:select path="gender" class="input-small" readonly="readonly">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.birthday}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				<form:input path="cardNo" htmlEscape="false" maxlength="50" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<form:input path="postcode" htmlEscape="false" maxlength="60" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">QQ：</label>
			<div class="controls">
				<form:input path="qq" htmlEscape="false" maxlength="50" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">固定电话：</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">传真：</label>
			<div class="controls">
				<form:input path="fax" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮箱：</label>
			<div class="controls">
				<form:input path="email" htmlEscape="false" maxlength="200" class="input-xlarge email" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				${member.province }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				${member.city }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<c:if test="${!empty member.contractCode}">
			<div class="control-group">
				<label class="control-label">淘宠合同编号：</label>
				<div class="controls">
					<form:input path="contractCode" htmlEscape="false" maxlength="255" class="input-xlarge" readonly="true"/>
				</div>
			</div>
		</c:if>
		<div class="control-group">
			<label class="control-label">账户余额：</label>
			<div class="controls">
				${ member.accountBalance}
				<c:if test="${member.balanceBlockedFlag=='0'}">未冻结</c:if>
				<c:if test="${member.balanceBlockedFlag=='1'}">已冻结</c:if>
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>会员缴费信息</h3>
		<div class="control-group">
			<label class="control-label">会员类型：</label>
			<div class="controls">
				<form:select path="memberType" class="input-small" readonly="true">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_member_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">缴费状态：</label>
			<div class="controls">
				<input type="text" value="${fns:getDictLabels(member.paymentState, 'user_payment_state', '未缴费')}" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">第一次缴费时间：</label>
			<div class="controls">
				<fmt:formatDate value="${member.firstPaymentTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员截止时间：</label>
			<div class="controls">
				<input name="" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.memberEndDate}" pattern="yyyy-MM-dd"/>"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">美容师类型：</label>
			<div class="controls">
				${fns:getDictLabels(member.groomerType, 'user_groomer_type', '非会员')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">美容师结束时间：</label>
			<div class="controls">
				<input name="" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.groomerEndDate}"  pattern="yyyy-MM-dd"/>"/>

			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬运动会员类型：</label>
			<div class="controls">
				${fns:getDictLabels(member.dgMemberType, 'dg_member_type', '非会员')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬运动会员过期时间：</label>
			<div class="controls">
				<input type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.dgEndDate}" pattern="yyyy-MM-dd"/>"/>
					
			</div>
		</div>
		<div style="clear:both;"></div>
		<h3>其他信息</h3>
		<div class="control-group">
			<label class="control-label">推荐人会员号：</label>
			<div class="controls">
				<form:input path="referee" htmlEscape="false"  maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<!-- 
		<div class="control-group">
			<label class="control-label">杂志邮寄方式：</label>
			<div class="controls">
				<form:input path="deliveryMagazine" htmlEscape="false"  maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		 -->
		 
		<div class="control-group">
			<label class="control-label">证书邮寄方式：</label>
			<div class="controls">
				<input  value="${member.deliveryCertified }" type="text"  maxlength="255" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">通知邮寄方式：</label>
			<div class="controls">
				<input  value="${member.deliveryNotice }" type="text"  maxlength="255" class="input-xlarge " readonly="readonly"/>
			</div>
		</div>
		
		<div class="control-group">
			<label class="control-label">最后联系时间：</label>
			<div class="controls">
				<input name="lastCall" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.lastCall}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">禁赛截至时间：</label>
			<div class="controls">
				<input name="banEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.banEndDate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:input path="remarks" htmlEscape="false"  maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">登记人：</label>
			<div class="controls">
				<form:input path="registrant" htmlEscape="false"  maxlength="255" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记日期：</label>
			<div class="controls">
				<input name="banEndDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${member.createDate}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">所属俱乐部：</label>
			<div class="controls">
				<form:input path="ckuClub" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div style="clear:both;"></div>
<%--		<h3>审核信息</h3>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-small" disabled="true" >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('diploma_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>--%>
		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:input path="remarks" disabled="true" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div style = "clear:both;"></div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<h3>会员收支记录</h3>
	<div style="color:red;font-size: 20px;float:right"> 充值:${in_price} 第三方支付${three_price} 支出:${out_price}  余额:${ member.accountBalance}</div>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>订单编号</th>
				<th>会员编号</th>
				<th>订单金额</th>
				<th>申请时间</th>
				<th>项目名称</th>
				<th>订单状态</th>
				<th>订单备注</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="paymentOrder">
			<tr>
				<td>
					${fns:escapeHtml(paymentOrder.orderCode)}
				</td>
				<td>
					${fns:escapeHtml(paymentOrder.memberCode)}
				</td>
				<td>
					${fns:escapeHtml(paymentOrder.totalPrice)}
				</td>
				<td>
					<fmt:formatDate value="${paymentOrder.addTime}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(paymentOrder.projectName)}
				</td>
				<td>
					${fns:getDictLabel(paymentOrder.paymentState,'user_payment_state' ,'' )}
				</td>
				<td>
					${fns:escapeHtml(paymentOrder.remarks)}
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>