<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>繁育证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					var obj = document.getElementsByName("showResults");
		            var results = "";
		            for (var int = 0; int < obj.length; int++) {
		                if(obj[int].checked) results+=obj[int].value+',';
		            }
		            if(results!=""){
		                $("#breedResults").val(results);
		            }
		            //拼接繁育成绩
		            var s = $("#date").val()+"&nbsp;&nbsp;"+$("#address").val()+"&nbsp;&nbsp;"+$("#referee").val()+"&nbsp;&nbsp;"+$("input[name='results']:checked").val()
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			if($("#reviewState").val()==2){
                $("#reviewDiv").show();
            } else {
                $("#reviewDiv").hide();
            }
			if($("#childShowsHid").val()!=""){
				$("#showResultsDiv").show();
				$("#resultsDiv").hide();
			} else {
				$("#showResultsDiv").hide();
                $("#resultsDiv").show();
			}
		});
		function changeState(val){
            if(val==2){
                $("#reviewDiv").show();
            } else {
                $("#reviewDiv").hide();
                $("#reviewRemarks").val('');
            }
       }
		
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctxDc}/dogBreedCertified">繁育证书列表</a></li>
		<li class="active"><a href="${ctxDc}/dogBreedCertified/form?id=${dogBreedCertified.id}">繁育证书<shiro:hasPermission name="dogbreed:dogBreedCertified:view">${not empty dogBreedCertified.id?'查看':'添加'}</shiro:hasPermission><shiro:lacksPermission name="dogbreed:dogBreedCertified:edit">查看</shiro:lacksPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="dogBreedCertified" action="${ctxDc}/dogBreedCertified" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<input type="hidden" id="resultsHid" value="${dogBreedCertified.breedResults}">
		<sys:message content="${message}"/>		
		<div class="control-group" style="float: left">
			<label class="control-label">犬只id：</label>
			<div class="controls">
				<form:input path="dogId" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">血统证书号：</label>
            <div class="controls">
                <form:input path="dog.pedigreeCertifiedCode" htmlEscape="false" maxlength="64" class="input-xlarge " readonly="true"/>
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label">繁育期限：</label>
			<div class="controls">
				<form:input path="breedDeadline" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">繁育证书编号：</label>
            <div class="controls">
                <form:input path="breedCertifiedCode" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
            </div>
        </div>
        <div class="control-group" style="float: left">
            <label class="control-label">近亲繁殖：</label>
            <div class="controls">
                <form:textarea path="kinBreed" htmlEscape="false" rows="4" class="input-xxlarge " style="width:270px;" readonly="true"/>
            </div>
        </div>
        <div class="control-group">
            <label class="control-label">已存繁殖成绩：</label>
            <div class="controls">
                <form:textarea path="breedResults" htmlEscape="false" rows="4" class="input-xxlarge " style="width:270px;" readonly="true"/>
            </div>
        </div>
        <div class="control-group" id="showResultsDiv">
            <label class="control-label">比赛成绩：</label>
            <div class="controls" style="overflow-y:auto; overflow-x:auto; width:500px; max-height:300px;">
                <input type="hidden" value="${childShowsList}" id ="childShowsHid"/>
                <c:forEach items="${childShowsList}" var="list">
                    <input  disabled="disabled" type="checkbox" name="showResults" value="${list}&nbsp;&nbsp;&nbsp;&nbsp;特优<br>"/>${list}&nbsp;&nbsp;&nbsp;&nbsp;特优<br>
                </c:forEach>
            </div>
        </div>
        <div class="control-group" id="resultsDiv">
            <label class="control-label">繁育成绩：</label>
            <div class="controls">
                <label>日期：</label><input id="date" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
                     />&nbsp;
                <label>地址：</label><input id="address" htmlEscape="false" type="text" class="input-xlarge " readonly="true"><br>
                <div>&nbsp;</div>
                <label>裁判：</label><input id="referee" htmlEscape="false" type="text" class="input-xlarge" style="width: 164px" readonly="true">&nbsp;
                <label>裁判评价：</label><input type="radio" checked="checked" name="results" value="特优" disabled="disabled">特优<input type="radio" name="results" value="优"disabled="disabled">优<input type="radio" name="results" value="良"disabled="disabled">良
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label">繁育级别：</label>
			<div class="controls">
				<form:input path="breedGrade" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
            <label class="control-label">睾丸：</label>
            <div class="controls">
                <form:input path="testicles" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
            </div>
        </div>
		<div class="control-group" style="float: left">
			<label class="control-label">肩高：</label>
			<div class="controls">
				<form:input path="shoulder" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">体长：</label>
			<div class="controls">
				<form:input path="bodyLength" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">胸深：</label>
			<div class="controls">
				<form:input path="chestDepth" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">体重：</label>
			<div class="controls">
				<form:input path="weight" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">总体评价：</label>
			<div class="controls">
				<form:textarea path="appraises" htmlEscape="false" rows="4" maxlength="20" class="input-xxlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">毛色与毛质：</label>
			<div class="controls">
				<form:textarea path="dogFurColor" htmlEscape="false" rows="4" maxlength="20" class="input-xxlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">性情：</label>
			<div class="controls">
				<form:input path="disposition" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">注意力：</label>
			<div class="controls">
				<form:input path="attention" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">神经状况：</label>
			<div class="controls">
				<form:input path="nerveSituation" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">自然程度：</label>
			<div class="controls">
				<form:input path="naturalDegree" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">本能自信和承受力：</label>
			<div class="controls">
				<form:input path="instinctConfidenceSuffer" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">性别特性：</label>
			<div class="controls">
				<form:input path="sexTypical" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">体格：</label>
			<div class="controls">
				<form:input path="physique" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">表现力：</label>
			<div class="controls">
				<form:input path="expressive" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">躯干情况：</label>
			<div class="controls">
				<form:input path="trunk" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">骨骼：</label>
			<div class="controls">
				<form:input path="bones" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">肌肉：</label>
			<div class="controls">
				<form:input path="muscles" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">前肢：</label>
			<div class="controls">
				<form:input path="forelimbs" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">后肢：</label>
			<div class="controls">
				<form:input path="hindlimbs" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">背部：</label>
			<div class="controls">
				<form:input path="back" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">肘关节连接：</label>
			<div class="controls">
				<form:input path="elbowJoint" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">前系强度：</label>
			<div class="controls">
				<form:input path="strengthOfPasterns" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">正面：</label>
			<div class="controls">
				<form:input path="front" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">尻部：</label>
			<div class="controls">
				<form:input path="croup" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">飞节强度：</label>
			<div class="controls">
				<form:input path="strengthOfHocks" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">步态：</label>
			<div class="controls">
				<form:input path="gait" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">步幅_前展：</label>
			<div class="controls">
				<form:input path="stepsForward" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">步幅_后蹬：</label>
			<div class="controls">
				<form:input path="stepsBackward" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">趾甲：</label>
			<div class="controls">
				<form:input path="nails" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">趾：</label>
			<div class="controls">
				<form:input path="feet" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">头部：</label>
			<div class="controls">
				<form:input path="head" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">眼睛颜色：</label>
			<div class="controls">
				<form:input path="colourOfTeeth" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">上颚：</label>
			<div class="controls">
				<form:input path="upperJaw" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">下颚：</label>
			<div class="controls">
				<form:input path="underjaw" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">牙齿：</label>
			<div class="controls">
				<form:input path="teeth" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">牙齿缺陷：</label>
			<div class="controls">
				<form:input path="faultsOfTeeth" htmlEscape="false" maxlength="20" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">其他优缺点：</label>
			<div class="controls">
				<form:textarea path="otherStrengthsWcaknesses" htmlEscape="false" rows="3" class="input-xxlarge " style="width:270px;" readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">种犬繁育的意见：</label>
			<div class="controls">
				<form:textarea path="suggestionsOnBreeding" htmlEscape="false" rows="3" class="input-xxlarge " style="width:270px;" readonly="true"/>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">繁育鉴定日期：</label>
			<div class="controls">
				<input name="breedIdentifyTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate "
					value="<fmt:formatDate value="${dogBreedCertified.breedIdentifyTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">繁育鉴定地点：</label>
			<div class="controls">
				<form:input path="breedIdentifyLocation" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">繁育鉴定裁判：</label>
			<div class="controls">
				<form:input path="breedIdentifyReferee" htmlEscape="false" maxlength="100" class="input-xlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " readonly="true"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">审核状态：</label>
			<div class="controls">
				<form:select path="reviewState" class="input-xlarge " style="width: 80px;" onclick="changeState(this.value)" disabled="true">
					<form:options items="${fns:getDictList('review_state')}" itemLabel="label" itemValue="value" htmlEscape="false" />
				</form:select>
			</div>
		</div>
		<div class="control-group" id="reviewDiv">
			<label class="control-label">审核的意见：</label>
			<div class="controls">
				<form:textarea path="reviewRemarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge " readonly="true"/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>