<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师结业证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:美容师结业证书添加</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="groomerDiploma" action="${ctxSchools}/schoolsCourse/diplomaSave" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="schoolId" value="${schoolId }"/>
		<form:hidden path="schoolNameCn" value="${schoolNameCn }"/>
		<form:hidden path="schoolNameEn" value="${schoolNameEn }"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">培训课程：</label>
			<div class="controls">
				<form:select id="groomerCourseId" path="groomerCourseId" class="input-xlarge required" onchange="selectCourse()" >
					<form:option value="" label=""/>
	             	<form:options items="${findList}" itemLabel="courseName" itemValue="id" htmlEscape="false"/>
	   		  </form:select>
	   		  <span id="Msg"></span>
			</div>
		</div>
		<script type="text/javascript">
		//回显所选课程的信息
			function selectCourse(){
				var  groomerCourseId = $("#groomerCourseId").val();
				if(groomerCourseId!=''){
					$.ajax({
						   type:"POST",
			                url: "${ctxSchools}/schoolsCourse/rockMsg",
			                data : {'id':groomerCourseId},
			                dataType: 'json',
			                async: false, 
			                success: function(json){
			                	if(json.rc==true){
			                		$("#Msg").html("");
			                		$("#Msg").html("开始时间 ：<font style='color:green'>"+json.startDate+"</font>&nbsp;&nbsp;&nbsp;"+
			                				"结束时间: <font style='color:green'>"+json.endDate+"</font>");
			                		$("#certificateLevel").val(json.diplomaLevel);
			                		$("#teacher").val(json.teacher);
			                		$("#certificateLevel").trigger("change"); 
			                	}else if(json.rc==false){
			                		$.jBox.alert(json.msg,"提示");
			                	}
			                }
					});
				}
			}
		</script>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
				<form:select path="certificateLevel" class="input-xlarge required" disabled="true">
					<form:option value="" label=""/>
					<form:options items="${fns:getDictList('groomer_level')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">培训教师：</label>
			<div class="controls">
				<form:input path="teacher" htmlEscape="false" maxlength="64" readonly="true" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学生数量：</label>
			<div class="controls">
				<input type="text" name="studentCount" id="studentCount"  maxlength="50" class=" required"  />
				<span class="help-inline"><a href="#" class="btn btn-primary" onclick="addItem()">确认</a> </span>
				<div id="studentArea"></div>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
	<script>
    //打开查询用户的弹窗
 	function addItem(){
				var value=$("#studentCount").val();
				try{
					value= parseInt(value);
					$("#studentArea").html("");
					for(var i=0;i<value;i++){
						$("#studentArea").append("学生会员号:<input style='width:70px;' class='required' type='text' id='"+i+"'  onblur='checkItem("+i+");return false;' name='studentNo'/><span id='c"+i+"'></span>&nbsp;&nbsp;");
						
						if((i+1)%4==0){
							$("#studentArea").append("<br/>")
						}
					}
				}catch(e){
					$("#studentCount").val("");
				}
			}
	//验证会员有效性
 	function checkItem(i){
		var code=$("#"+i+"").val();
 		if(code!=''){
			$.ajax({
				   type:"POST",
	                url: "${ctxSchools}/schoolsMember/checkStudent",
	                data : {'memberCode':code},
	                dataType: 'json',
	                async: false, 
	                success: function(json){
	                	if(json.rc==true){
	                		if(json.paymentState==1){
		                		$.jBox.alert("此会员无效!","提示");
		                		$("#"+i+"").val("");
	                		}else if(json.paymentState==2){
	                			alert(json.name);
	                			$("#c"+i+"").html("<font style='color:green;'>"+json.name+"</font>");
	                		}
	                	}else if(json.rc==false){
	                		$.jBox.alert(json.msg,"提示");
	                		$("#"+i+"").val("");
	                	}
	                }
			});
		} 
	} 
</script>
</body>
</html>