<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
	<title>门店添加</title>
	<meta name="decorator" content="default"/>
	<link href="${ctxStatic}/layui_2/layui/css/layui.css" type="text/css" rel="stylesheet"/>
	<script src="${ctxStatic}/layui_2/layui/layui.all.js" type="text/javascript"></script>
	<style>
		.picDiv{
			overflow: hidden;
		}
		.picDiv>div{
			width:33%;
		}
	</style>
	<script type="text/javascript">
		$(document).ready(function () {
			//悬浮提示插件
			$(document).tooltip();
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function (form) {
					var yingyePic = $("#yingyePic").val();
					if(yingyePic == null || yingyePic == ''){
						alertx("营业执照照片为空");
						return;
					}
					var shouYiPic = $("#shouYiPic").val();
					if(shouYiPic == null || shouYiPic == ''){
						alertx("兽医资格照片为空");
						return;
					}
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function (error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
		function deleteImg(type){
			$("#"+type+"Show").attr("src","");
			$("#"+type+"Show").removeAttr("style");
			$("#"+type).val("");
		}
		function showImg(type){
			var src = $("#"+type+"Show").attr("src");
			if(src=="")
				return;
			parent.layer.open({
				type: 1,
				title: false,
				area: ['800px', '600px'],
				closeBtn: 0,
				skin: 'layui-layer-nobg', //没有背景色
				shadeClose: true,
				content: "<img src='"+src+"'>"
			});
			;
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>

</head>
<body>
<ul class="nav nav-tabs">
	<li><a href="${ctxPartner}/org/list">门店列表</a></li>
	<li class="active"><a href="${ctxPartner}/org/form">门店添加</a></li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="org" action="${ctxPartner}/org/save" method="post"
		   class="form-horizontal">
	<form:hidden path="id"/>

	<div class="control-group">
		<label class="control-label">门店类型：</label>
		<div class="controls">
			${fns:getDictLabel(org.orgType, 'sys_org_type', '')}
			<form:hidden path="orgType" htmlEscape="false" maxlength="64" class="input-medium required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">登录账号：</label>
		<div class="controls">
			${fns:escapeHtml(org.user.name)}
			<form:hidden path="user.id" htmlEscape="false" maxlength="64" class="input-medium required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">密码：</label>
		<div class="controls">
			<input type="password" name="user.password" class="input-medium" />
			<span class="help-inline"><font color="red">空值为不修改</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">门店名称：</label>
		<div class="controls">
			<form:input path="name" htmlEscape="false" maxlength="64" class="input-medium required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">负责人：</label>
		<div class="controls">
			<form:input path="contact" htmlEscape="false" maxlength="64" class="input-medium required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">联系电话：</label>
		<div class="controls">
			<form:input path="tel" htmlEscape="false" maxlength="64" class="input-medium required isTel"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">座机电话：</label>
		<div class="controls">
			<form:input path="landlinePhone" htmlEscape="false" maxlength="64" class="input-medium"/>
		</div>
	</div>
	<div class="control-group">
		<label class="control-label">门店地址：</label>
		<div class="controls">
			<form:select id="province" path="province" class="input-small required">
				<form:option value=""></form:option>
				<c:forEach items="${province}" var="p">
					<form:option value="${fns:escapeHtml(p.name) }">${fns:escapeHtml(p.name) }</form:option>
				</c:forEach>
			</form:select>
			<form:select id="city" path="city" class="input-small required required">
				<form:option value=""></form:option>
				<c:forEach items="${city}" var="c">
					<form:option value="${fns:escapeHtml(c.name) }">${fns:escapeHtml(c.name) }</form:option>
				</c:forEach>
			</form:select>
			<form:input path="street" htmlEscape="false" maxlength="200" class="input-medium required"/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
		<script>
			$("#province").change(function(){
				var extId = $("#province").val();
				extId = encodeURI(extId);
				//异步请求数据
				var url="${ctxPartner}/org/treeData";
				$.get(url,{extId:extId},function(data){
					var content = "<option value=''></option>";
					for(var i in data){
						content+="<option value='"+data[i].name+"'>"+data[i].name+"</option>"
					}
					$("#city").html(content).trigger("change");
				},"json")

			})
		</script>
	</div>
	<div class="control-group" >
		<label class="control-label">C级鉴定师：</label>
		<div class="controls">
			<form:input path="jianDingshi1" htmlEscape="false" maxlength="50" class="input-medium required"/>
			<form:input path="jianDingshi2" htmlEscape="false" maxlength="50" class="input-medium "/>
			<span class="help-inline"><font color="red">*</font> </span>
		</div>
	</div>
	<div class="control-group" >
		<label class="control-label">推荐人：</label>
		<div class="controls">
				${org2.name}
		</div>
	</div>
	<%--<div style = "clear:both;"></div>--%>
	<%--<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>--%>

	<div class="picDiv" >
		<div class="control-group" style="float: left">
			<label class="control-label">营业执照照片：</label>
			<div class="controls">
				<div style="">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
						<c:if test="${empty org.yingyePic }">
							<center><img id="img1" alt="" src="" style="padding:10px;height:130px;"/></center>
						</c:if>
						<c:if test="${not empty org.yingyePic }">
							<center><img id="img1" alt="" src="${pageContext.request.contextPath}/api/v1/open/image/${org.yingyePic}" style="padding:10px;height:130px;"/></center>
						</c:if>
						<div style="position:relative;color: #cccccc;font-size: 18px;">
							<center>图片预览</center>
						</div>
					</div>
				</div>
				<div style="">
					<div style="border: 0px dashed #e6e6e6;margin:20px;min-height: 50px;position:relative;">
						<button type="button" style="height:40px;left:36%; position:absolute;  top:38%;" class="layui-btn"
								id="catImgUpload">
							<i class="layui-icon">&#xe67c;</i>上传图片
						</button>
						<form:input path="yingyePic" htmlEscape="false" maxlength="255" class="input-xlarge required"
									type="hidden"/>
					</div>
				</div>
				<script type="text/javascript">
					layui.use('upload', function () {
						var upload = layui.upload;
						//执行实例
						var uploadInst = upload.render({
							elem: '#catImgUpload' //绑定元素
							, url: '${ctxPartner}/org/layupload' //上传接口ctxPartner
							, done: function (res) {//上传完毕回调
								$("#yingyePic").val(res.id);
								$("#img1").attr("src", res.url);
							}
							, error: function () {
								//请求异常回调
							}
						});
					});
				</script>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">兽医资格照片：</label>
			<div class="controls">
				<div style="">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
						<c:if test="${empty org.shouYiPic }">
							<center><img id="img2" alt="" src="" style="padding:10px;height:130px;"/></center>
						</c:if>
						<c:if test="${not empty org.shouYiPic }">
							<center><img id="img2" alt="" src="${pageContext.request.contextPath}/api/v1/open/image/${org.shouYiPic}" style="padding:10px;height:130px;"/></center>
						</c:if>
						<div style="position:relative;color: #cccccc;font-size: 18px;">
							<center>图片预览</center>
						</div>
					</div>
				</div>
				<div style="">
					<div style="border: 0px dashed #e6e6e6;margin:20px;min-height: 50px;position:relative;">
						<button type="button" style="height:40px;left:36%; position:absolute;  top:38%;" class="layui-btn"
								id="catImgUploads">
							<i class="layui-icon">&#xe67c;</i>上传图片
						</button>
						<form:input path="shouYiPic" htmlEscape="false" maxlength="255" class="input-xlarge required"
									type="hidden"/>
					</div>
				</div>
				<script type="text/javascript">
					layui.use('upload', function () {
						var upload = layui.upload;
						//执行实例
						var uploadInst = upload.render({
							elem: '#catImgUploads' //绑定元素
							, url: '${ctxPartner}/org/layupload' //上传接口ctxPartner
							, done: function (res) {//上传完毕回调
								$("#shouYiPic").val(res.id);
								$("#img2").attr("src", res.url);
							}
							, error: function () {
								//请求异常回调
							}
						});
					});
				</script>
			</div>
		</div>
		<div class="control-group" style="float: left">
			<label class="control-label">门店照片：</label>
			<div class="controls">
				<div style="">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
						<c:if test="${empty org.mendian1Pic }">
							<center><img id="img3" alt="" src="" style="padding:10px;height:130px;"/></center>
						</c:if>
						<c:if test="${not empty org.mendian1Pic }">
							<center><img id="img3" alt="" src="${pageContext.request.contextPath}/api/v1/open/image/${org.mendian1Pic}" style="padding:10px;height:130px;"/></center>
						</c:if>
						<div style="position:relative;color: #cccccc;font-size: 18px;">
							<center>图片预览</center>
						</div>
					</div>
				</div>
				<div style="">
					<div style="border: 0px dashed #e6e6e6;margin:20px;min-height: 50px;position:relative;">
						<button type="button" style="height:40px;left:36%; position:absolute;  top:38%;" class="layui-btn"
								id="catImgUploadss">
							<i class="layui-icon">&#xe67c;</i>上传图片
						</button>
						<form:input path="mendian1Pic" htmlEscape="false" maxlength="255" class="input-xlarge required"
									type="hidden"/>
					</div>
				</div>
				<script type="text/javascript">
					layui.use('upload', function () {
						var upload = layui.upload;
						//执行实例
						var uploadInst = upload.render({
							elem: '#catImgUploadss' //绑定元素
							, url: '${ctxPartner}/org/layupload' //上传接口ctxPartner
							, done: function (res) {//上传完毕回调
								$("#mendian1Pic").val(res.id);
								$("#img3").attr("src", res.url);
							}
							, error: function () {
								//请求异常回调
							}
						});
					});
				</script>
			</div>
		</div>
	</div>

	<div class="form-actions">
		<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
		<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
	</div>
</form:form>
</body>
</html>