<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>待邮寄物品管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
	</script>
</head>
<body>
	<form:form id="searchForm" modelAttribute="expressQueue" action="${ctx}/sys/expressQueue/search" method="post" class="breadcrumb form-search">
		<ul class="ul-form">
			<li><label style="width:60px;">会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="60" style="width:80px;"/>
				
			</li>
			<li>
				<label style="width:60px;">姓名：</label>
				<form:input path="memberName" htmlEscape="false" maxlength="60" style="width:80px;"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns"><input id="btnSubmit" class="btn toSelect" type="submit" value="直接添加"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>收件人</th>
				<th>省份</th>
				<th>城市</th>
				<th>区域</th>
				<th>街道</th>
				<th>待邮寄物品数</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:if test="${count eq 0 }">
			<tr> <td colspan="6">请输入会员号进行查询</td></tr>
		</c:if>
		<c:forEach items="${result}" var="expressQueue">
			<tr>
			
			<c:forEach items = "${expressQueue.value }" var="item" varStatus="status">
				
				<c:if test="${status.count eq 1 }">
					<td>${item.memberCode }</td>
					<td>${item.receiver }</td>
					<td>${item.province }</td>
					<td>${item.city }</td>
					<td>${item.area }</td>
					<td>${item.street }</td>
					<td>${fn:length(expressQueue.value) }</td>
					<input class="memberCode" value="${item.memberCode }" type="hidden"/>
				</c:if>
				<input class="ids" value="${item.id }" type="hidden"/>
				
				<c:if test= "${status.last }">
					<td ><a href="#" class="toSelect" >选择</a></td>
				</c:if>
			</c:forEach>
			
			</tr>
		</c:forEach>
		</tbody> 
	</table>
	<script type="text/javascript">
		$(".toSelect").click(function(){
			var selectValue = ""; 
			$(this).parent().parent().find(".ids").each(function(index,element){
				selectValue+=$(this).val()+",";
			})
			var memberCode = $(this).parent().parent().find(".memberCode").val();
			select(selectValue,memberCode);
			return false;
		});
		function select(ids,memberCode){
			var index = parent.layer.getFrameIndex(window.name); //获取窗口索引
			if(parent.document.getElementById("mainFrame").contentWindow.QueueCallback != undefined){
				parent.document.getElementById("mainFrame").contentWindow.QueueCallback(ids,memberCode);
			}
			parent.layer.close(index);
		}
	</script>
</body>
</html>