<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展裁判管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
<!--引入wangEditor.css-->
<link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
<link href="${ctxStatic}/layui/css/layui.css" rel="stylesheet" />
<script src="${ctxStatic}/layui/layui.js" type="text/javascript"></script>
<script src="${ctxStatic}/layui/lay/dest/layui.all.js" type="text/javascript"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/judge/showJudge/">犬展裁判列表</a></li>
		<li class="active"><a href="#">犬展裁判<shiro:hasPermission name="judge:showJudge:add">${not empty showJudge.id?'修改':'添加'}</shiro:hasPermission></a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="showJudge" action="${ctx}/judge/showJudge/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">裁判姓名：</label>
			<div class="controls">
				<form:input path="judgeName" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判图片：</label>
	        <div class="controls">
		        <div style="float:left;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
						<c:if test="${empty showJudge.judgePicture }">
							<center><img id="previewCatImg" alt="" src="" style="padding:10px;height:130px;"/></center>
						</c:if>
						<c:if test="${not empty showJudge.judgePicture }">
							<center><img id="previewCatImg" alt="" src="${ctx }/sys/file/image/${showJudge.judgePicture }" style="padding:10px;height:130px;"/></center>
						</c:if>
						<div style="position:relative;color: #cccccc;font-size: 18px;"><center>图片预览</center></div>
					</div>
				</div>
		        <div style="float:right;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;position:relative;">
						<div style="height:40px;left:36%; position:absolute;  top:38%;" >
							<input id="judgePictureBtn" type="file" name="file" lay-type="image" lay-title="请上传裁判图" class="layui-upload-file">
						</div>
					<form:input path="judgePicture" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					</div>
				</div>
				<script type="text/javascript">
					  layui.upload({
						    url: '${ctx}/sys/file/uploadJudge'
						    ,elem: '#judgePictureBtn' //指定原始元素，默认直接查找class="layui-upload-file"
						    ,method: 'POST' //上传接口的http类型
						    ,success: function(res){
						    	$("#judgePicture").val(res.id);
						    	$("#previewCatImg").attr("src",res.url);
						    }
						  }); 
				</script>
	        </div>
		</div>
		
		<div class="control-group">
			<label class="control-label">国秀展裁判照：</label>
	        <div class="controls">
		        <div style="float:left;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;">
						<c:if test="${empty showJudge.showTypeJudgePicture }">
							<center><img id="showTypeJudgePictureImg" alt="" src="" style="padding:10px;height:130px;"/></center>
						</c:if>
						<c:if test="${not empty showJudge.showTypeJudgePicture }">
							<center><img id="showTypeJudgePictureImg" alt="" src="${ctx }/sys/file/image/${showJudge.showTypeJudgePicture }" style="padding:10px;height:130px;"/></center>
						</c:if>
						<div style="position:relative;color: #cccccc;font-size: 18px;"><center>图片预览</center></div>
					</div>
				</div>
		        <div style="float:right;width:50%;">
					<div style="border: 3px dashed #e6e6e6;margin:20px;min-height: 178px;position:relative;">
						<div style="height:40px;left:36%; position:absolute;  top:38%;" >
							<input id="showTypeJudgePictureBtn" type="file" name="file" lay-type="image" lay-title="请上传裁判图" class="layui-upload-file">
						</div>
					<form:input path="showTypeJudgePicture" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
					</div>
				</div>
				<script type="text/javascript">
					  layui.upload({
						    url: '${ctx}/sys/file/uploadJudge'
						    ,elem: '#showTypeJudgePictureBtn' //指定原始元素，默认直接查找class="layui-upload-file"
						    ,method: 'POST' //上传接口的http类型
						    ,success: function(res){
						    	$("#showTypeJudgePicture").val(res.id);
						    	$("#showTypeJudgePictureImg").attr("src",res.url);
						    }
						  }); 
				</script>
	        </div>
		</div>
		
		
		<div class="control-group">
			<label class="control-label">裁判介绍：</label>
			<div class="controls">
				<form:textarea  htmlEscape="true" path="introduce" style="height:400px"   />     
<%-- 				<sys:ckeditor replace="introduce" uploadPath="/judge/showJudge " /> --%>				    
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判头衔：</label>
			<div class="controls">
				<form:input path="judgeTitle" htmlEscape="false" maxlength="500" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判国籍：</label>
			<div class="controls">
				<form:input path="citizenship" htmlEscape="false" maxlength="50" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">裁判性别：</label>
			<div class="controls">
				<form:select path="judgeSex" class="input-small required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('sex')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">头衔缩写：</label>
			<div class="controls">
				<form:input path="judgeTitleShort" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">备注信息：</label>
			<div class="controls">
				<form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="255" class="input-xxlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
    				<!--引入jquery和wangEditor.js-->   <!--注意：javascript必须放在body最后，否则可能会出现问题-->
<script type="text/javascript" src="${ctxStatic }/wangEditor/js/wangEditor.min.js"></script>
<script type="text/javascript">
		var editor = new wangEditor('introduce');
		   // 上传图片（举例）
		   editor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';
		   
		   editor.config.uploadImgFileName = 'editorImg';
		   // 设置 headers（举例）
		   editor.config.uploadHeaders = {
		       'Accept' : 'text/x-json'
		   };
		   
		   // 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
		   editor.config.hideLinkImg = true;
		   editor.create();
</script>
</body>
</html>