<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>结业证书管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出数据吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/handler/handlerDiploma/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").attr("action","${ctx}/handler/handlerDiploma/");
			$("#searchForm").submit();
        	return false;
        }
	/* 	function showLayer(id){
			var remarks = "";
			parent.layer.prompt({
				title: ['拒绝原因', 'font-size:18px;text-align: center;'],
				formType: 2
			}, function(text){
				remarks = text;
				window.location.href="${ctx}/handler/handlerDiploma/review?id="+id+"&type=fail&remarks="+remarks;
				parent.layer.closeAll();
			});

		} */
		
		//批量生成
		function listCreate(){
				var id="";
				$(".checkedId:checked").each(function(){
					id+=$(this).attr("handlerId")+',';
				});
				if (id!="") {
					$.ajax({
		                type:"POST",
		                url: ctx+"/handler/handlerDiploma/createCode",
		                data : {'id':id},
		                dataType: 'json',
		                success: function(json){
		                	if (json.rc==0) {
		                		$("#searchForm").submit();
							}else{
								$.jBox.alert(json.msg,"提示");
							}
		                }
					}); 
				}else{
					$.jBox.alert("请勾选需要生成的结业证书记录!");
				}
			}
		
		//批量审核通过
		function listSubmit(){
				var id="";
				$(".checkedId:checked").each(function(){
					id+=$(this).attr("handlerId")+',';
				});
				if (id!="") {
					$.ajax({
		                type:"POST",
		                url: ctx+"/handler/handlerDiploma/listSubmit",
		                data : {'id':id},
		                dataType: 'json',
		                success: function(json){
		                	if (json.rc==0) {
		                		$("#searchForm").submit();
							}else{
								$.jBox.alert(json.msg,"提示");
							}
		                }
					}); 
				}else{
					$.jBox.alert("请勾选需要通过的结业记录");
				}
			}
		//全选事件 选中/取消选中
		var b=false;
		function allCheck(){
			if (!b) {
				b=true;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}else{
				b=false;
				$(".checkedId").each(function(){
					$(this).attr("checked", b);
				});
			}
		}
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/handler/handlerDiploma/">牵犬师结业证书管理</a></li>
		<shiro:hasPermission name="handler:trainDiploma:view"><li><a href="${ctx}/handler/trainDiploma/">训犬师结业证书管理</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="handlerDiploma" action="${ctx}/handler/handlerDiploma/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-medium"/>
			</li>
			<li><label>培训机构：</label>
				<form:input path="schoolNameCn" htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>证书级别：</label>
				<form:select path="certificateLevel" class="input-medium">
					<form:option value="" label="全部"/>
					<form:option value="牵犬师C级" label="牵犬师C级"/>
					<form:option value="牵犬师B级" label="牵犬师B级"/>
					<form:option value="牵犬师A级" label="牵犬师A级"/>
					<form:option value="精英培训班" label="精英培训班"/>
					<form:option value="牵犬师C级-西藏獒犬" label="牵犬师C级-西藏獒犬"/>
				</form:select>
			</li>
			<li><label>证书编号：</label>
				<form:input path="certificateCode" htmlEscape="false" maxlength="255" class="input-medium"/>
			</li>
			<li><label>缴费状态：</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>审核状态：</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('diploma_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询" onclick="return page();"/>
			<shiro:hasPermission name="handler:handlerDiploma:export"><button id="btnExport" type="button" class="btn btn-primary" >导出</button></shiro:hasPermission>
			<shiro:hasPermission name="handler:handlerDiploma:audit"><a href="#" onclick="listSubmit()"><input class="btn btn-primary" type="button" value="批量通过" /></a></shiro:hasPermission>
			<shiro:hasPermission name="handler:handlerDiploma:create"><a href="#" onclick="listCreate()"><input class="btn btn-primary" type="button" value="批量生成" /></a></shiro:hasPermission>
			<shiro:hasPermission name="handler:handlerDiploma:edit"><a href="${ctx}/handler/handlerDiploma/addForm"><input class="btn btn-primary" type="button" value="添加牵犬师" /></a></shiro:hasPermission>
			</li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th><a href="#" onclick="allCheck()">全选</a></th>
				<th>姓名</th>
				<th>会员号</th>
				<th>开始时间</th>
				<th>结束时间</th>
				<th>培训教师</th>
				<th>证书级别</th>
				<th>中文学校名</th>
				<th>学校英文名</th>
				<shiro:hasPermission name="handler:handlerDiploma:create"><th>证书编号</th></shiro:hasPermission>
				<shiro:hasPermission name="handler:handlerDiploma:create"><th>签发日期</th></shiro:hasPermission>
				<th>缴费状态</th>
				<th>操作</th>
				<shiro:hasPermission name="handler:handlerDiploma:audit"><th>审核状态</th></shiro:hasPermission>
				<th>打印</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="handlerDiploma">
			<tr>
				<td><input type="checkbox" class="checkedId" handlerId="${fns:escapeHtml(handlerDiploma.id)}"></td>
				<td>
					${fns:escapeHtml(handlerDiploma.name)}
				</td>
				<td>
					<a href="${ctx}/sys/user/member/toMemberView?memberCode=${handlerDiploma.memberCode}">
					${fns:escapeHtml(handlerDiploma.memberCode)}
					</a>
				</td>
				<td>
					<fmt:formatDate value="${handlerDiploma.startDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${handlerDiploma.endDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(handlerDiploma.teacher)}
				</td>
				<td>
					${fns:escapeHtml(handlerDiploma.certificateLevel)}
				</td>
				<td>
					${fns:escapeHtml(handlerDiploma.schoolNameCn)}
				</td>
				<td>
					${fns:escapeHtml(handlerDiploma.schoolNameEn)}
				</td>
				<shiro:hasPermission name="handler:handlerDiploma:create"><td>
					<c:if test="${empty fns:escapeHtml(handlerDiploma.certificateCode) &&handlerDiploma.reviewState=='1' }">
						<a href="${ctx}/handler/handlerDiploma/createCodeOne?id=${fns:escapeHtml(handlerDiploma.id)}">点击生成</a>
					</c:if>
					<c:if test="${not empty fns:escapeHtml(handlerDiploma.certificateCode)}">
						${fns:escapeHtml(handlerDiploma.certificateCode)}
					</c:if>
				</td>
				<td>
					<c:if test="${empty handlerDiploma.issueDate==null  &&handlerDiploma.reviewState=='1'}">
						<a href="${ctx}/handler/handlerDiploma/createCodeOne?id=${fns:escapeHtml(handlerDiploma.id)}">点击生成</a>
					</c:if>
					<c:if test="${not empty handlerDiploma.issueDate!=null}">
						<fmt:formatDate value="${handlerDiploma.issueDate}" pattern="yyyy-MM-dd"/>
					</c:if>
				</td></shiro:hasPermission>
				<td>
					<c:choose>
						<c:when test="${handlerDiploma.paymentState=='2' }">
							<font color="green">${fns:getDictLabel(handlerDiploma.paymentState, 'user_payment_state', '')}</font>
						</c:when>
						<c:otherwise>
							<a onclick="util.pay('${fns:escapeHtml(handlerDiploma.id)}','handler_diploma@all',1,'','${fns:escapeHtml(handlerDiploma.memberCode)}')">
								<font color="red">${fns:getDictLabel(handlerDiploma.paymentState,'user_payment_state','')}</font>
							</a>
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<a href="${ctx}/handler/handlerDiploma/handlerView?id=${fns:escapeHtml(handlerDiploma.id)}">查看</a>&nbsp;
					<shiro:hasPermission name="handler:handlerDiploma:edit">
						<a href="${ctx}/handler/handlerDiploma/form?id=${fns:escapeHtml(handlerDiploma.id)}">编辑</a>&nbsp;
					</shiro:hasPermission>
				</td>
				<shiro:hasPermission name="handler:handlerDiploma:audit">
				<td>
					<c:choose>
						<c:when test="${fns:escapeHtml(handlerDiploma.reviewState)=='0' }">
							<a style="color:red" href="${ctx}/handler/handlerDiploma/review?id=${handlerDiploma.id}">未审核</a>
						</c:when>
						<c:when test="${fns:escapeHtml(handlerDiploma.reviewState)=='2' }">
							<a style="color:red" title="${fns:escapeHtml(handlerDiploma.reviewRemarks)}">
							${fns:getDictLabel(handlerDiploma.reviewState, 'diploma_review_state', '')}
							</a>
						</c:when>
						<c:otherwise>
							<font color="green">${fns:getDictLabel(handlerDiploma.reviewState, 'diploma_review_state', '')}</font>
						</c:otherwise>
					</c:choose>
				</td>
				</shiro:hasPermission>
				<td>
				<shiro:hasPermission name="handler:handlerDiploma:print">
					<c:if test="${handlerDiploma.printState=='0' && handlerDiploma.paymentState=='2' && handlerDiploma.reviewState=='1'}">
							<a href="${ctx}/handler/handlerDiploma/handlerDiplomaPrint?id=${fns:escapeHtml(handlerDiploma.id)}">打印</a>&nbsp;&nbsp;
					</c:if>
					</shiro:hasPermission>
					<shiro:hasPermission name="handler:handlerDiploma:resetPrint">
						<c:if test="${handlerDiploma.printState=='1'}">
								<a href="${ctx}/handler/handlerDiploma/resetPrint?id=${fns:escapeHtml(handlerDiploma.id)}">重置</a>&nbsp;&nbsp;
						</c:if>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>