<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>美容师结业证书</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
	
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/groomer/groomerDiploma/view?id=${groomerDiploma.id}">美容师结业证书查看</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="groomerDiploma"  class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				${fns:escapeHtml(groomerDiploma.name) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				${fns:escapeHtml(groomerDiploma.memberCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">开始时间：</label>
			<div class="controls">
				<fmt:formatDate value="${groomerDiploma.startDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">结束时间：</label>
			<div class="controls">
				<fmt:formatDate value="${groomerDiploma.endDate}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">授课教师：</label>
			<div class="controls">
				${not empty fns:escapeHtml(groomerDiploma.teacher)?fns:escapeHtml(groomerDiploma.teacher):'无' }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">签发日期：</label>
			<div class="controls">
				<fmt:formatDate value="${groomerDiploma.issueDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">中文学校名：</label>
			<div class="controls">
				${not empty fns:escapeHtml(groomerDiploma.schoolNameCn)?fns:escapeHtml(groomerDiploma.schoolNameCn):'无' }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">学校英文名：</label>
			<div class="controls">
				${not empty fns:escapeHtml(groomerDiploma.schoolNameEn)?fns:escapeHtml(groomerDiploma.schoolNameEn):'无' }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书编号：</label>
			<div class="controls">
				${fns:escapeHtml(groomerDiploma.certificateCode) }
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证书级别：</label>
			<div class="controls">
				美容师${fns:getDictLabel(groomerDiploma.certificateLevel, 'groomer_test_level', '')}级
			</div>
		</div>
		<div class="form-actions">
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>