<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>业务服务管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/goods/sysBusinessService/">业务服务列表</a></li>
		<shiro:hasPermission name="goods:sysBusinessService:add"><li><a href="${ctx}/goods/sysBusinessService/editForm">业务服务添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="sysBusinessService" action="${ctx}/goods/sysBusinessService/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>分类名称：</label>
				<form:select id="cateId" path="cateId" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${businessCateList}" itemLabel="cateName" itemValue="id" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>服务编号：</label>
				<form:input path="businessCode" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li><label>服务名称：</label>
				<form:input path="businessName" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<shiro:hasPermission name="goods:sysBusinessService:registerService">
			<li><label>处理类：</label>
				<form:input path="serviceName" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			</shiro:hasPermission>
			<li><label>财务配置ID：</label>
				<form:input path="financeId" htmlEscape="false" maxlength="50" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>分类名称</th>
				<th>服务名称</th>
				<th>服务编号</th>
				<shiro:hasPermission name="goods:sysBusinessService:registerService">
				<th>处理类</th>
				</shiro:hasPermission>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="sysBusinessService">
			<tr>
				<td>
					${sysBusinessService.cateName}
				</td>
				<td>
						${sysBusinessService.businessName}
				</td>
				<td>
					${sysBusinessService.businessCode}
				</td>
				<shiro:hasPermission name="goods:sysBusinessService:registerService">
				<td>
					${sysBusinessService.serviceName}
				</td>
				</shiro:hasPermission>
				<td>
					<a href="${ctx}/goods/sysBusinessService/viewForm?id=${sysBusinessService.id}">查看</a>
					<shiro:hasPermission name="goods:sysBusinessService:edit">
						<a href="${ctx}/goods/sysBusinessService/editForm?id=${sysBusinessService.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="goods:sysBusinessService:del">
						<a href="${ctx}/goods/sysBusinessService/delete?id=${sysBusinessService.id}"
						   onclick="return confirmx('确认要删除该业务服务吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>