<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>美容官网人才库管理</title>
    <meta name="decorator" content="default"/>
    <link rel="stylesheet" type="text/css" href="${ctxStatic }/wangEditor/css/wangEditor.min.css">
    <script type="text/javascript" src="${ctxStatic}/wangEditor/js/wangEditor.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            //富文本
            //履历
            const cvEditor = new wangEditor('cv');
            // 上传图片
            cvEditor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';
            cvEditor.config.uploadParams = {module:'gcWeb'};
            cvEditor.config.uploadImgFileName = 'editorImg';
            // 设置 headers
            cvEditor.config.uploadHeaders = {
                'Accept': 'text/x-json'
            };
            // 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
            cvEditor.config.hideLinkImg = true;
            cvEditor.create();
            //美容
            const groomerEditor = new wangEditor('groomer');
            // 上传图片
            groomerEditor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';
            groomerEditor.config.uploadParams = {module:'gcWeb'};
            groomerEditor.config.uploadImgFileName = 'editorImg';
            // 设置 headers
            groomerEditor.config.uploadHeaders = {
                'Accept': 'text/x-json'
            };
            // 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
            groomerEditor.config.hideLinkImg = true;
            groomerEditor.create();
            //裁判
            const refereeEditor = new wangEditor('referee');
            // 上传图片
            refereeEditor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';
            refereeEditor.config.uploadParams = {module:'gcWeb'};
            refereeEditor.config.uploadImgFileName = 'editorImg';
            // 设置 headers
            refereeEditor.config.uploadHeaders = {
                'Accept': 'text/x-json'
            };
            // 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
            refereeEditor.config.hideLinkImg = true;
            refereeEditor.create();
            //繁殖
            const breedEditor = new wangEditor('breed');
            // 上传图片
            breedEditor.config.uploadImgUrl = '${ctx}/sys/file/editorUpload';
            breedEditor.config.uploadParams = {module:'gcWeb'};
            breedEditor.config.uploadImgFileName = 'editorImg';
            // 设置 headers
            breedEditor.config.uploadHeaders = {
                'Accept': 'text/x-json'
            };
            // 隐藏掉插入网络图片功能。该配置，只有在你正确配置了图片上传功能之后才可用。
            breedEditor.config.hideLinkImg = true;
            breedEditor.create();


            //表单
            $("#inputForm").validate({
                submitHandler: function (form) {
                    loading('正在提交，请稍等...');
                    form.submit();
                },
                errorContainer: "#messageBox",
                errorPlacement: function (error, element) {
                    $("#messageBox").text("输入有误，请先更正。");
                    if (element.is(":checkbox") || element.is(":radio") || element.parent().is(".input-append")) {
                        error.appendTo(element.parent().parent());
                    } else {
                        error.insertAfter(element);
                    }
                }
            });
        });
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li><a href="${ctx}/gcWeb/talent/">美容师人才库列表</a></li>
    <li class="active">
        <a href="${ctx}/gcWeb/talent/form?id=${gcWebTalent.id}">美容师人才库
            <shiro:hasPermission name="gcWeb:talent:edit">${not empty gcWebTalent.id?'修改':'添加'}</shiro:hasPermission>
            <shiro:lacksPermission name="gcWeb:talent:edit">查看</shiro:lacksPermission>
        </a>
    </li>
</ul>
<br/>
<form:form id="inputForm" modelAttribute="gcWebTalent" action="${ctx}/gcWeb/talent/save" method="post"
           class="form-horizontal">
    <form:hidden path="id"/>
    <sys:message content="${message}"/>
    <div class="control-group">
        <label class="control-label">标题：</label>
        <div class="controls">
            <form:input path="title" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">图片：</label>
        <div class="controls">
            <c:choose>
                <c:when test="${!empty gcWebTalent.image}">
                    <img id="previewImage" src="${gcWebTalent.image}" style="padding:10px;height:130px;"/>
                </c:when>
                <c:otherwise>
                    <img id="previewImage"/>
                </c:otherwise>
            </c:choose>
            <div style="width: 300px">
                <sys:ossUpload module="gcWebTalentImage" maxCount="1" maxSize="5" successHideFile="true"
                               successCallback="uploadImageCallBack"/>
            </div>
            <form:input path="image" htmlEscape="false" maxlength="255" class="input-xlarge " type="hidden"/>
            <!-- 文件上传成功的回调方法 -->
            <script type="text/javascript">
                function uploadImageCallBack(file, res) {
                    $("#image").val(res.fileUrl);
                    $("#previewImage").attr("src", res.fileUrl)
                    $("#previewImage").attr("style", "padding:10px;height:130px;");
                }
            </script>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">履历：</label>
        <div class="controls">
            <form:textarea path="cv" htmlEscape="true" style="height:400px"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">美容经历：</label>
        <div class="controls">
            <form:textarea path="groomer" htmlEscape="true" style="height:400px"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">执裁经历：</label>
        <div class="controls">
            <form:textarea path="referee" htmlEscape="true" style="height:400px"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">繁殖经历：</label>
        <div class="controls">
            <form:textarea path="breed" htmlEscape="true" style="height:400px"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">显示标记：</label>
        <div class="controls">
            <form:select path="showFlag" class="input-xlarge required">
                <form:option value="" label=""/>
                <form:options items="${fns:getDictList('show_hide')}" itemLabel="label" itemValue="value"
                              htmlEscape="false"/>
            </form:select>
            <span class="help-inline"><font color="red">*</font> </span>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">排序：</label>
        <div class="controls">
            <form:input path="sort" htmlEscape="false" maxlength="11" class="input-xlarge  digits"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label">备注：</label>
        <div class="controls">
            <form:textarea path="remarks" htmlEscape="false" rows="4" maxlength="1000" class="input-xxlarge "/>
        </div>
    </div>
    <div class="form-actions">
        <shiro:hasPermission name="gcWeb:talent:edit"><input id="btnSubmit" class="btn btn-primary" type="submit"
                                                             value="保 存"/>&nbsp;</shiro:hasPermission>
        <input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
    </div>
</form:form>
</body>
</html>