<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>会员支付流水管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/finance/paymentRecord/">会员支付流水列表</a></li>
		<shiro:hasPermission name="finance:paymentRecord:edit"><li><a href="${ctx}/finance/paymentRecord/form">会员支付流水添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="paymentRecord" action="${ctx}/finance/paymentRecord/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="60" class="input-medium"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>付款项目</th>
				<th>实付金额</th>
				<th>付款服务的价格</th>
				<th>支付类型</th>
				<th>流水号</th>
				<th>付款状态</th>
				<th>更新时间</th>
				<th>备注</th>
				<shiro:hasPermission name="finance:paymentRecord:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentRecord">
			<tr>
				<td><a href="${ctx}/finance/paymentRecord/form?id=${paymentRecord.id}">
					${fns:escapeHtml(paymentRecord.memberCode)}
				</a></td>
				<td>
					${paymentRecord.paymentChargingItem.name}
				</td>
				<td>
					${fns:escapeHtml(paymentRecord.paymentAmount)}
				</td>
				<td>
					${fns:escapeHtml(paymentRecord.price)}
				</td>
				<td>
					${fns:getDictLabel(paymentRecord.paymentWay, 'payment_way', '')}
				</td>
				<td>
					${fns:escapeHtml(paymentRecord.runningNumber)}
				</td>
				<td>
					${fns:getDictLabel(paymentRecord.paymentState, 'user_payment_state', '')}
				</td>
				<td>
					<fmt:formatDate value="${paymentRecord.updateDate}" pattern="yyyy-MM-dd HH:mm:ss"/>
				</td>
				<td>
					${fns:escapeHtml(paymentRecord.remarks)}
				</td>
				<shiro:hasPermission name="finance:paymentRecord:edit"><td>
    				<a href="${ctx}/finance/paymentRecord/form?id=${paymentRecord.id}">修改</a>
					<a href="${ctx}/finance/paymentRecord/delete?id=${paymentRecord.id}" onclick="return confirmx('确认要删除该会员支付流水吗？', this.href)">删除</a>
				</td></shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>