<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>订单项目管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function addBtnShow(){
			parent.layer.open({
				type: 2,
				title: ['项目活动添加', 'font-size:18px;text-align: center;'],
				shadeClose: false,
				shade: [0.8, '#393D49'],
				maxmin: false, //开启最大化最小化按钮
				area: ['500px', '300px'],
				content: '${ctx}/finance/paymentOrderProject/form',
				end:function(){
					if(parent.isYes){
						$("form").submit();
					}
				}
			});
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li><a href="${ctx}/finance/paymentOrder/">订单列表</a></li>
		<shiro:hasPermission name="finance:paymentOrderProject:view"><li  class="active"><a href="${ctx}/finance/paymentOrderProject/">项目活动</a></li></shiro:hasPermission>

	</ul>
	<div class="panel panel-default">
		<div class="panel-body">
			<form:form id="searchForm" modelAttribute="paymentOrderProject" action="${ctx}/finance/paymentOrderProject/" method="post" class="breadcrumb form-search">
				<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
				<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
				<ul class="ul-form">
					<li><label>项目名称：</label>
						<form:input path="name" htmlEscape="false" maxlength="200" class="input-medium"/>
					</li>
					<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/>
						<shiro:hasPermission name="finance:paymentOrderProject:add">
							<input onclick="addBtnShow()" class="btn btn-primary" type="button" value="项目活动添加"/></li>
						</shiro:hasPermission>
					<li class="clearfix"></li>
				</ul>
			</form:form>
		</div>
	</div>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>项目名称</th>
				<th>项目时间</th>
				<th>项目地址</th>
				<shiro:hasPermission name="finance:paymentOrderProject:changeStatus">
					<th>是否置顶</th>
					<th>是否有效</th>
				</shiro:hasPermission>
				<th>统计</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="paymentOrderProject">
			<tr>
				<td>
					${fns:escapeHtml(paymentOrderProject.name)}
				</td>
				<td>
					<fmt:formatDate value="${paymentOrderProject.startDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(paymentOrderProject.address)}
				</td>
				<shiro:hasPermission name="finance:paymentOrderProject:changeStatus">
					<td>
						<c:if test="${paymentOrderProject.isTop==0}">
							<a href="${ctx}/finance/paymentOrderProject/changeStatus?type=isTop&isTop=${paymentOrderProject.isTop}&id=${paymentOrderProject.id}">否</a>
						</c:if>
						<c:if test="${paymentOrderProject.isTop==1}">
							<a href="${ctx}/finance/paymentOrderProject/changeStatus?type=isTop&isTop=${paymentOrderProject.isTop}&id=${paymentOrderProject.id}">是</a>
						</c:if>
					</td>
					<td>
						<c:if test="${paymentOrderProject.isValid==0}">
							<a href="${ctx}/finance/paymentOrderProject/changeStatus?type=isValid&isValid=${paymentOrderProject.isValid}&id=${paymentOrderProject.id}">无效</a>
						</c:if>
						<c:if test="${paymentOrderProject.isValid==1}">
							<a href="${ctx}/finance/paymentOrderProject/changeStatus?type=isValid&isValid=${paymentOrderProject.isValid}&id=${paymentOrderProject.id}">有效</a>
						</c:if>
					</td>
				</shiro:hasPermission>
				<td>
					<a href="${ctx}/finance/paymentOrderProject/statistical/?id=${paymentOrderProject.id}">统计</a>
				</td>

					<td>
						<shiro:hasPermission name="finance:paymentOrderProject:delete">
							<a href="${ctx}/finance/paymentOrderProject/delete?id=${paymentOrderProject.id}">删除</a>
						</shiro:hasPermission>
						<shiro:hasPermission name="finance:paymentOrder:add">
							<c:if test="${paymentOrderProject.isValid==1}">
								<a href="${ctx}/finance/paymentProjectCart/form?projectId=${paymentOrderProject.id}">录订单</a>
							</c:if>
						</shiro:hasPermission>
					</td>

			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>