<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>视频鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});
		
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogVideoAppraisal/examineList/">视频鉴定审核员列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogVideoAppraisal" action="${ctx}/dogvideoappraisal/examineList/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		
		<ul class="ul-form">
			<%-- <li><label>芯片号:</label>
				<form:input path="chipNo" placeholder="芯片号"  htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员姓名/编号:</label>
				<form:input path="memberInfo" placeholder="会员姓名/编号"  htmlEscape="false" maxlength="64" class="input-medium"/>
			</li> --%>
			<li><label>犬只品种:</label>
                <form:select id="dogBreed" path="dogBreed" class="input-xlarge" >
                	<form:option value="" label="请选择犬种"/> 
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode"  htmlEscape="false"/>
                </form:select>
             </li>
            <%--  <li><label>审核状态:</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('video_appraisal_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>付款状态:</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li> --%>
			
			<li><label>申请日期:</label>
				<input name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> - 
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<!-- <th>id</th> -->
				<th>品种</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>订单状态</th>
				<th>审核状态</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogVideoAppraisal">
			<tr>
				<%-- <td>
					${fns:escapeHtml(dogVideoAppraisal.id)}
				</td> --%>
				<td title="${fns:escapeHtml(dogVideoAppraisal.dogBreedCn)}">
					${fns:escapeHtml(dogVideoAppraisal.dogBreed)}
				</td>
				<td>
					<fmt:formatDate value="${dogVideoAppraisal.dogBirth}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogVideoAppraisal.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td style="color:${dogVideoAppraisal.paymentState eq '2' ?'#090':'#F00'}">
					${fns:getDictLabel(dogVideoAppraisal.paymentState, 'user_payment_state', '')}
				</td>
			
					<c:choose>
						<c:when test="${ dogVideoAppraisal.paymentState eq '1' }">
							<td></td>
						</c:when>
					
						<c:when test="${ dogVideoAppraisal.reviewState  eq '4' }">
							<td>
								已注销
							</td>
						</c:when>
					<c:otherwise>
						<c:if test="${ dogVideoAppraisal.reviewState == '0' &&  dogVideoAppraisal.businessRefundState!='1' && dogVideoAppraisal.businessRefundState!='3'}">
							<td >
								<a href="${ctx}/dogvideoappraisal/reviewStatePage?id=${dogVideoAppraisal.id}" style="color:red;">${fns:getDictLabel(dogVideoAppraisal.reviewState, 'video_appraisal_review_state', '')}</a>
							</td>
						</c:if>
						<c:if test="${ dogVideoAppraisal.reviewState == '5'  &&  dogVideoAppraisal.businessRefundState!='1' && dogVideoAppraisal.businessRefundState!='3'}">
							<td >
								<a href="${ctx}/dogvideoappraisal/reviewStatePage?id=${dogVideoAppraisal.id}"> ${fns:getDictLabel(dogVideoAppraisal.reviewState, 'video_appraisal_review_state', '')}</a>
							</td>
						</c:if>
						<c:if test="${ dogVideoAppraisal.reviewState == '1' }">
							<td style="color:green;">
								${fns:getDictLabel(dogVideoAppraisal.reviewState, 'video_appraisal_review_state', '')}
							</td>
						</c:if>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>