<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>视频鉴定管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
		});

		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }

	</script>
	<!-- 悬浮提示插件 -->
	<link rel="stylesheet" href="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.css">
	<script src="${ctxStatic}/jquery-ui/1.12.0/jquery-ui.min.js"></script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogVideoAppraisal/">视频鉴定列表</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="dogVideoAppraisal" action="${ctx}/dogvideoappraisal/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<input id="id" name="ia"  type="hidden"  />

		<ul class="ul-form">
			<li><label>芯片号:</label>
				<form:input path="chipNo" placeholder="芯片号"  htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>会员姓名/编号:</label>
				<form:input path="memberInfo" placeholder="会员姓名/编号"  htmlEscape="false" maxlength="64" class="input-medium"/>
			</li>
			<li><label>犬只品种:</label>
                <form:select id="dogBreed" path="dogBreed" class="input-xlarge" >
                	<form:option value="" label="请选择犬种"/>
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode"  htmlEscape="false"/>
                </form:select>
             </li>
             <li><label>审核状态:</label>
				<form:select path="reviewState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('video_appraisal_review_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>付款状态:</label>
				<form:select path="paymentState" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('user_payment_state')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>

			<li><label>申请日期:</label>
				<input name="beginDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${beginCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
				<input name="endDate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
					value="<fmt:formatDate value="${endCreateDate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
			</li>
			<li><label>合作机构:</label>
				<form:select path="orgName" class="input-medium" placeholder="请选择合作机构">
					<form:option value="" label="全部"/>
					<form:options items="${orgList}" itemLabel="name" itemValue="name" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>犬名</th>
				<th>品种</th>
				<th>犬主</th>
				<th>芯片编号</th>
				<th>护照编号</th>
				<th>出生日期</th>
				<th>申请日期</th>
				<th>鉴定编号</th>
				<th>合作机构</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>处理</th>
				<th>登记卡打印</th>
				<th>操作</th>
				<th>删除</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogVideoAppraisal">
			<tr>
				<td>
					${fns:escapeHtml(dogVideoAppraisal.dogName)}
				</td>
				<td title="${fns:escapeHtml(dogVideoAppraisal.dogBreedCn)}">
					${fns:escapeHtml(dogVideoAppraisal.dogBreed)}
				</td>
				<td title="${fns:escapeHtml(dogVideoAppraisal.memberCode)}">
					${fns:escapeHtml(dogVideoAppraisal.memberName)}
				</td>
				<td>
					${fns:escapeHtml(dogVideoAppraisal.chipNo)}
				</td>
				<td>
					${fns:escapeHtml(dogVideoAppraisal.passportNo)}
				</td>
				<td>
					<fmt:formatDate value="${dogVideoAppraisal.dogBirth}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<fmt:formatDate value="${dogVideoAppraisal.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:escapeHtml(dogVideoAppraisal.appraisalNo)}
				</td>
				<td>
					${fns:escapeHtml(dogVideoAppraisal.orgName)}
				</td>

				<td style="color:${dogVideoAppraisal.paymentState eq '2' ? '#090' : '#F00'}">
					${fns:getDictLabel(dogVideoAppraisal.paymentState, 'user_payment_state', '')}
				</td>

				<c:choose>
					<c:when test="${dogVideoAppraisal.paymentState eq '2'}">
						<td style="color:${dogVideoAppraisal.reviewState eq '1' ? '#090' :'#F00'}">
							${fns:getDictLabel(dogVideoAppraisal.reviewState, 'dog_appraisal_review_state', '')}
						</td>
					</c:when>
					<c:otherwise>
						<td></td>
					</c:otherwise>
				</c:choose>

				<c:choose >
					<c:when test="${dogVideoAppraisal.reviewState ne '4' }">
						<td style="color:${dogVideoAppraisal.resolveStatus eq '0' || dogVideoAppraisal.resolveStatus eq '2' ? '#F00' : '#090'}">
						<shiro:hasPermission name="dogVideoAppraisal:resolve">
							<c:if test="${ dogVideoAppraisal.paymentState eq '2' &&  dogVideoAppraisal.reviewState eq '1'}">
								<c:if test="${ dogVideoAppraisal.resolveStatus eq '0' || dogVideoAppraisal.resolveStatus eq '2'}">
								<a href="${ctx}/dogvideoappraisal/resolve?id=${dogVideoAppraisal.id}" onclick="return confirmx('确认要处理该视频鉴定吗？', this.href)">处理</a>
								</c:if>
								<c:if test="${ dogVideoAppraisal.resolveStatus eq '1'}">
									已处理
								</c:if>
							</c:if>
						</shiro:hasPermission>
					</td>
					<td>
						<shiro:hasPermission name="dogVideoAppraisal:print">
							<c:if test="${not empty dogVideoAppraisal.chipNo && dogVideoAppraisal.reviewState ne '0' && dogVideoAppraisal.resolveStatus eq '1'}">
								<c:if test="${dogVideoAppraisal.printStatus eq '0' }">
									<a href="${ctx}/dogvideoappraisal/print?id=${dogVideoAppraisal.id}">打印</a>
								</c:if>
								<c:if test="${dogVideoAppraisal.printStatus eq '1' }">
									<a href="${ctx}/dogvideoappraisal/resetPrint?id=${dogVideoAppraisal.id}">重置打印</a>
								</c:if>
							</c:if>
						</shiro:hasPermission>
					</td>
					<td>

					<shiro:hasPermission name="dogVideoAppraisal:view">
							<a href="${ctx}/dogvideoappraisal/form?id=${dogVideoAppraisal.id}">查看</a>
	    			</shiro:hasPermission>
	    			<shiro:hasPermission name="dogVideoAppraisal:edit">
	    				<c:if test="${ dogVideoAppraisal.paymentState eq '2' && dogVideoAppraisal.reviewState ne '0'}">
							<a href="${ctx}/dogvideoappraisal/editPage?id=${dogVideoAppraisal.id}">编辑</a>
						</c:if>
					</shiro:hasPermission>

					</td>
					<td>
					<shiro:hasPermission name="dogVideoAppraisal:delete">
						<c:if test="${ dogVideoAppraisal.paymentState eq '1' && dogVideoAppraisal.reviewState ne '0'}">
							<a href="${ctx}/dogvideoappraisal/delete?id=${dogVideoAppraisal.id}" onclick="return confirmx('确认要删除该视频鉴定吗？', this.href)">删除</a>
						</c:if>
					</shiro:hasPermission>
					</td>
					</c:when>
					<c:otherwise>
						<td /><td /><td /><td />
					</c:otherwise>
				</c:choose>


			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>