
package com.subscription.restful.web;

import java.io.IOException;
import java.text.SimpleDateFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;
import com.subscription.restful.vo.DogBirthCertificateSimpleVO;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import net.sf.json.JSONObject;

/**
 * 出生证明
 */
@Api(value = "公众号登记卡转让-xuxue", tags = { "公众号登记卡转让-xuxue" })
@Controller
@RequestMapping(value = "/subscription/dog/birthcertificate")
public class GZHDogBirthCertificateController extends BaseRestController {

	@Autowired
	private DogBirthCertificateService service;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogColorMarkService dogColorMarkService;

	/**
	 * 接收方点击确认
	 * 
	 * @param json
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "身份识别登记卡-转让", notes = "入参：\n" + "{\n" + "\"birthCerRegCode\":\"000857962\", --登记卡ID\n"
			+ " \"identificationFlag\":\"202001068998888\", --芯片号\n" + " \"snCode\":\"\",--识别码\n" + "}\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + " \"rc\": 0,\n" + "\"msg\": \"OK\",\n"
			+ " \"data\": \"0cf6a38c8e474c558a12b7462e131275\" -- 登记卡ID\n" + "}"))

	@RequestMapping(value = "transfer", method = RequestMethod.POST)
	public void post(@RequestBody String json, HttpServletResponse response) throws IOException {
		ServletUtils.writeResponse(response, service.transfer(json));
	}

	/**
	 * 扫码进详情
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	// @RequestMapping(value = "/{id}", method = RequestMethod.GET)
	// @ResponseBody
	// public void get(@PathVariable("id") String id, HttpServletResponse response)
	// throws Exception {
	// DogBirthCertificate dogBirthCertificate = service.get(id);
	// DogBirthCertificateSimpleVO vo = new DogBirthCertificateSimpleVO();
	// BeanUtils.copyProperties(dogBirthCertificate, vo);
	// DogType dogType =
	// dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
	// String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
	// vo.setDogBreedCnName(dogBreedCnName);
	// ServletUtils.writeResponse(response, new RESTResponse("data", vo));
	// }

	/**
	 * 等级卡号+芯片号 查询详情
	 * 
	 * @param request
	 * @param response
	 * @throws IOException
	 */
	@ApiOperation(value = "转让查询详情", notes = "入参（在URL上）：\n" + "birthCerRegCode\":\"000858015\", -- 登记卡详情\n"
			+ "   \"identificationFlag\":\"202004221234781\", -- 芯片号\n" + "\"snCode\":\"\" -- 识别码,非必填\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + " \"rc\": 0,\n" + "\"msg\": \"OK\",\n" + " \"data\": {\n"
			+ " \"dogEnName\": \"hedhh Walleria\", -- 名字\n" + " \"dogBirthday\": \"2020-04-22 00:00:00\", -- 出生日期\n"
			+ " \"dogGender\": \"1\", --性别 1公 2母\n" + " \"dogOwenr\": \"刘载春\", -- 犬主\n"
			+ " \"breeder\": \"刘载春\", -- 繁育人\n" + " \"breederMemberCode\": \"2268\", --繁育人会员\n"
			+ " \"dogBreed\": \"111\", -- 种类代码\n" + " \"dogBreedCnName\": \"金毛寻回猎犬\",--种类名称\n"
			+ " \"memberCode\": \"2268\", -- 犬主会员号\n" + " \"colorFlagName\": \"乳黄色\",-- 颜色中文\n"
			+ " \"colorFlag\": \"BUFF\" -- 颜色代码\n" + " }\n" + "}\n" + ""))
	@RequestMapping(value = "/detail", method = RequestMethod.GET)
	@ResponseBody
	public void detail(HttpServletRequest request, HttpServletResponse response) throws Exception {

		// 检查能不能转让
		JSONObject json = new JSONObject();
		json.put("birthCerRegCode", request.getParameter("birthCerRegCode"));
		json.put("identificationFlag", request.getParameter("identificationFlag"));
		json.put("snCode", request.getParameter("snCode"));

		DogBirthCertificate dogBirthCertificate = service.checkTransfer(json);
		DogBirthCertificateSimpleVO vo = new DogBirthCertificateSimpleVO();
		BeanUtils.copyProperties(dogBirthCertificate, vo);
		DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
		String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
		vo.setDogBreedCnName(dogBreedCnName);
		vo.setColorFlagName(dogColorMarkService.getDogColorMarkCnSimple(dogBirthCertificate.getColorFlag()));
		vo.setDogBirthday(new SimpleDateFormat("yyyy-MM-dd").format(dogBirthCertificate.getDogBirthday()));
		ServletUtils.writeResponse(response, new RESTResponse("data", vo));
	}

}