/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.trainschool.web;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.restful.v1.trainschool.service.RestTrainingInstitutionService;
import com.cku.util.ServletUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 培训机构管理Controller
 *
 * @author laiguanglong
 * @version 2017-07-13
 */
@Controller
@RequestMapping(value = "/cku/v1/trainschool")
public class CkuTrainingInstitutionController extends BaseRestController {

    @Autowired
    private RestTrainingInstitutionService restTrainingInstitutionService;

    /**
     * @description: CKU官网培训机构查询接口
     * @author: laiguanglong
     * @date: 2016年9月28日 下午5:26:13
     */
    @RequestMapping(value = "", method = RequestMethod.GET)
    @ResponseBody
    public void getTrainingInstitution(HttpServletRequest request,
                                       HttpServletResponse response) throws IOException {
        RESTResponse result = restTrainingInstitutionService.getTrainingInstitution(request);
        ServletUtils.writeResponse(response, result);
    }

    @RequestMapping(value = "/trainingInstitution", method = RequestMethod.GET)
    @ResponseBody
    public void getList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restTrainingInstitutionService.getList(request);
        ServletUtils.writeResponse(response, result);
    }
}