/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.dog.service.RestDogFrozenSemenService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

/**
 * @description: 冷冻精子
 * @author: laiguanglong
 * @date: 2017/8/25 13:56
 */
@Api(value = "犬种报备/申报相关-xuxue", tags = { "犬种报备/申报相关-xuxue" })
@Controller
@RequestMapping(value = "/api/v1/dog/dogFrozenSemen")
public class RestDogFrozenSemenController extends BaseRestController {

	@Autowired
	private RestDogFrozenSemenService restDogFrozenSemenService;

	@ApiOperation(value = "犬种申报/报备-已申报详情", notes = "入参： 冷冻精子主体ID\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "	\"rc\": 0,\n" + "	\"msg\": \"OK\",\n"
			+ "	\"data\": {\n" + "		\"id\": \"7f3d1c20b51840d2b8247cc6f1bb31db\", -- 冷冻精子主体ID\n"
			+ "		\"semenBatchCode\": \"JZPC0002140\",  --  冷冻精子批次号\n"
			+ "		\"dogId\": \"b9ca85c141124988a888a95108406bf9\",\n"
			+ "		\"pedigreeCertified\": \"CKU-111463176/20\",  - 证书号\n"
			+ "		\"dogChip\": \"100000202005253\", --芯片号\n" + "		\"dogBreed\": \"金毛寻回猎犬\",   -- 犬种\n"
			+ "		\"dogName\": \"hedhh Xamie\",    --名字\n" + "		\"dogOwner\": \"刘载春\",  -- 犬主\n"
			+ "		\"semenNumber\": \"2\",   -- 精子数量\n" + "		\"dogSemenList\": [{\n"
			+ "			\"id\": \"a884a36f75064c1a96d0fd45b479019e\",\n"
			+ "			\"originalSemenCode\": \"3让64756857\",  -- 原精子编号\n"
			+ "			\"semenCode\": \"JZ000002311\" -- cku精子编号 \n" + "		}, {\n"
			+ "			\"id\": \"f436eda05d4d4580a92785f167ef388b\",\n"
			+ "			\"originalSemenCode\": \"123455647\",  -- 原精子编号\n"
			+ "			\"semenCode\": \"JZ000002310\" -- cku精子编号 \n" + "		}]\n" + "	}\n" + "}\n" + ""))
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	public void get(@PathVariable("id") String id, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogFrozenSemenService.get(id);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "犬种申报/报备-已申报列表", notes = "入参：\n" + "pedigreeCertified 血统证书号\n"
			+ "businessType 0种犬申报   1种犬报备\n" + "pageSize 页面大小\n" + "pageNo 页码\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "	\"rc\": 0,\n" + "	\"msg\": \"OK\",\n"
			+ "	\"list\": [{\n" + "		\"id\": \"7f3d1c20b51840d2b8247cc6f1bb31db\",  -- 冷冻精子主体ID\n"
			+ "		\"semenBatchCode\": \"JZPC0002140\",     --  冷冻精子批次号\n"
			+ "		\"dogId\": \"b9ca85c141124988a888a95108406bf9\",  \n"
			+ "		\"pedigreeCertified\": \"CKU-111463176/20\",  -- 证书号\n"
			+ "		\"dogChip\": \"100000202005253\",  --芯片号\n" + "		\"dogBreed\": \"金毛寻回猎犬\",  -- 犬种\n"
			+ "		\"dogName\": \"hedhh Xamie\",  --名字\n" + "		\"dogOwner\": \"刘载春\",   -- 犬主\n"
			+ "		\"memberName\": \"刘载春\",    -- 犬主\n" + "		\"businessType\": \"申报\",  -- 类型\n"
			+ "		\"semenNumber\": \"\",  -- 精子数量\n" + "		\"acquisitionTime\": \"\",   -- 采集时间\n"
			+ "		\"createDate\": \"2020-05-25\",  -- 创建日期\n" + "		\"businessState\": \"待采集\",  -- 业务状态\n"
			+ "		\"reviewRemarks\": \"\"  -- 审核的意见\n" + "	}],\n" + "	\"total\": 1\n" + "}\n" + ""))
	@RequestMapping(value = "", method = RequestMethod.GET)
	public void getList(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogFrozenSemenService.getList(request);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "犬种申报/报备-提交", notes = "入参：\n" + "{\n"
			+ "	\"dogId\": \"b9ca85c141124988a888a95108406bf9\",  \n"
			+ "	\"businessType\": \"0\", --  0种犬申报   1种犬报备\n"
			+ " \"originalSemenCode\": [\"234\", \"345\", \"567\"], -- 0时不填 原精液号\n"
			+ " \"acquisitionTime\": \"2020-04-29\" -- 采集日期\n" + "}\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\"rc\":0,\"msg\":\"OK\",\"data\":\"430cff5a230c4b539d7fabd2f61d302c\"} --购物车条目ID\n"
			+ ""))
	@RequestMapping(value = "", method = RequestMethod.POST)
	public void post(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogFrozenSemenService.post(json);
		ServletUtils.writeResponse(response, result);
	}

	@RequestMapping(value = "", method = RequestMethod.PUT)
	public void put(@RequestBody String json, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogFrozenSemenService.put(json);
		ServletUtils.writeResponse(response, result);
	}

	@ApiOperation(value = "犬种申报/报备-查询价格", notes = "入参：\n" + "pedigreeCertifiedCode 血统证书号\n"
			+ "businessType 0种犬申报   1种犬报备\n" + "")
	@ApiResponses(@ApiResponse(code = 200, message = "{\"rc\":0,\"msg\":\"OK\",\"data\":{\"price\":\"300.00\"}}\n"
			+ ""))
	@RequestMapping(value = "/getPrice", method = RequestMethod.GET)
	public void getPrice(HttpServletRequest request, HttpServletResponse response) throws IOException {
		RESTResponse result = restDogFrozenSemenService.getPrice(request);
		ServletUtils.writeResponse(response, result);
	}

	/**
	 * @Description：根据配种证明编号查询配种信息
	 * @author: zhuoHeng
	 * @version: 2017年1月5日 下午3:56:43
	 */
	@ApiOperation(value = "犬种申报/报备-犬只查询", notes = "入参：\n" + "pedigreeCertifiedCode 血统证书号\n"
			+ "businessType 0种犬申报   1种犬报备\n")
	@ApiResponses(@ApiResponse(code = 200, message = "{\n" + "    \"rc\": 0,\n" + "    \"msg\": \"OK\",\n"
			+ "    \"data\": {\n" + "        \"dogId\": \"b9ca85c141124988a888a95108406bf9\",  \n"
			+ "        \"pedigreeCertified\": \"CKU-111463176/20\", --证书号\n"
			+ "        \"dogChip\": \"100000202005253\", -- 芯片号\n" + "        \"dogBreed\": \"金毛寻回猎犬\", --犬种\n"
			+ "        \"dogName\": \"hedhh Xamie\",  -- 名字\n" + "        \"dogOwner\": \"刘载春\",  --犬主\n"
			+ "        \"isHaveDogDna\": true,  -- 是否有DNA留存\n" + "        \"studDogCoverImg\": \"\",  -- 头像\n"
			+ "        \"age\": \"0个月\"，\n" + "        \"gender\": \"1\" -- 性别\n" + "    }\n" + "}\n" + ""))
	@RequestMapping(value = "/checkByPedigreeCertifiedCode", method = RequestMethod.GET)
	public void checkByPedigreeCertifiedCode(HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		RESTResponse result = restDogFrozenSemenService.checkByPedigreeCertifiedCode(request);
		ServletUtils.writeResponse(response, result);
	}
}