package com.cku.restful.v1.dog.vo;

import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogNewborn;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

import java.text.SimpleDateFormat;

public class DogMCVO {
	private String code;		// 序号
	private String nameEn;		// 英文姓名
	private String pedigreeCertifiedCode;		// 血统证书号
	private String gender;		//
	private String birthdate;		// 出生日期
	private String dna; // DNA
	private String identificationFlag; //
	private String dogOwner;		// 犬主人姓名
	private String puppyBirthNum;		// 出生数（几公几母）
	private String breedCertifiedCode;		// 配种证明编号
	private String breedDate;		// 配种日期


	public DogMCVO(Dog dog){
		this.nameEn = dog.getNameEn();
		this.pedigreeCertifiedCode = dog.getPedigreeCertifiedCode();
		this.gender = DictUtils.getDictLabel(dog.getGender(), "dog_gender", null);
		this.dna = dog.getDna();
		this.identificationFlag = dog.getIdentificationFlag();
		if(dog.getBirthdate()!=null){
			this.birthdate = new SimpleDateFormat("yyyy-MM-dd").format(dog.getBirthdate());
		}
	}
	public DogMCVO(DogNewborn dogNewborn){
		this.breedCertifiedCode = dogNewborn.getBreedCertifiedCode();
		this.puppyBirthNum = dogNewborn.getPuppyBirthNum();
		if(dogNewborn.getBirthday()!=null){
			this.birthdate = new SimpleDateFormat("yyyy-MM-dd").format(dogNewborn.getBirthday());
		}
		if(dogNewborn.getBreedDate()!=null){
			this.breedDate = new SimpleDateFormat("yyyy-MM-dd").format(dogNewborn.getBreedDate());
		}
	}


	public String getDogOwner() {
		return dogOwner;
	}

	public void setDogOwner(String dogOwner) {
		this.dogOwner = dogOwner;
	}

	public String getBreedCertifiedCode() {
		return breedCertifiedCode;
	}

	public void setBreedCertifiedCode(String breedCertifiedCode) {
		this.breedCertifiedCode = breedCertifiedCode;
	}

	public String getBreedDate() {
		return breedDate;
	}

	public void setBreedDate(String breedDate) {
		this.breedDate = breedDate;
	}

	public String getPuppyBirthNum() {
		return puppyBirthNum;
	}

	public void setPuppyBirthNum(String puppyBirthNum) {
		this.puppyBirthNum = puppyBirthNum;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getIdentificationFlag() {
		return identificationFlag;
	}

	public void setIdentificationFlag(String identificationFlag) {
		this.identificationFlag = identificationFlag;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getDna() {
		return dna;
	}

	public void setDna(String dna) {
		this.dna = dna;
	}

	public String getNameEn() {
		return nameEn;
	}
	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}
	public String getPedigreeCertifiedCode() {
		return pedigreeCertifiedCode;
	}
	public void setPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		this.pedigreeCertifiedCode = pedigreeCertifiedCode;
	}

	public String getBirthdate() {
		return birthdate;
	}
	public void setBirthdate(String birthdate) {
		this.birthdate = birthdate;
	}
}