/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.geneTree.utils.GeneTreeReportUtils;
import com.cku.geneTree.vo.response.SamplingGeneticDiseaseResponse;
import com.cku.oa.clubdog.entity.ClubDog;
import com.cku.oa.clubdog.service.ClubDogService;
import com.cku.oa.dog.dao.DogAppraisalDao;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogNewbornDao;
import com.cku.oa.dog.dao.DogStickerDao;
import com.cku.oa.dog.dao.DogVideoAppraisalDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBreedCertified;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogDna;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.entity.DogNewborn;
import com.cku.oa.dog.entity.DogOwner;
import com.cku.oa.dog.entity.DogPedigreeCertifiedExport;
import com.cku.oa.dog.entity.DogSticker;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.entity.DogVideoAppraisal;
import com.cku.oa.dog.entity.dogamphimixis.DogAmphimixisProve;
import com.cku.oa.dog.enums.GoldCertifiedStateEnum;
import com.cku.oa.dog.enums.ParenthoodTypeEnum;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBreedCertifiedService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.dog.service.DogDnaService;
import com.cku.oa.dog.service.DogOwnerService;
import com.cku.oa.dog.service.DogPedigreeCertifiedExportService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogStickerApplyService;
import com.cku.oa.dog.service.DogStickerService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.service.dogamphimixis.DogAmphimixisProveService;
import com.cku.oa.dog.util.PedigreeCertifiedCodeUtil;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.show.dao.ChampionLoginDao;
import com.cku.oa.show.dao.ShowResultsDao;
import com.cku.oa.show.dao.ShowResultsDdzDao;
import com.cku.oa.show.entity.ShowResults;
import com.cku.oa.show.entity.ShowResultsDdz;
import com.cku.oa.show.service.ChampionLoginService;
import com.cku.oa.show.vo.ShowResultsDdzVO;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.DesensitizeUtils;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.restful.v1.dog.model.CkuDog;
import com.cku.restful.v1.dog.model.InsuranceDog;
import com.cku.restful.v1.dog.model.MyDogPedigreeVo;
import com.cku.restful.v1.dog.model.PetClass;
import com.cku.restful.v1.dog.model.RestDog;
import com.cku.restful.v1.dog.model.ViewCertificateVo;
import com.cku.restful.v1.dog.model.ViewDogVo;
import com.cku.restful.v1.dog.vo.GeneticDiseaseRiskLevelVo;
import com.cku.restful.v1.dog.vo.GeneticDiseaseVo;
import com.cku.restful.v1.dog.vo.response.DogGeneReportResponse;
import com.cku.restful.v1.open.response.ExportDogMsgResponse;
import com.cku.restful.v1.show.model.RestShowResults;
import com.cku.restful.v1.show.model.RestShowResultsDdz;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.cku.util.HttpClientUtil;
import com.cku.util.HttpResult;
import com.cku.util.JSONUtils;
import com.google.common.collect.Lists;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

/**
 * 犬只信息管理Service
 *
 * @author zhuoHeng
 * @version 2016-07-22
 */
@Service
@Transactional(readOnly = true)
public class RestDogService {

	@Autowired
	public DogService dogService;
	@Autowired
	public DogTypeService dogTypeService;
	@Autowired
	public DogColorMarkService dogColorMarkService;
	@Autowired
	public MemberService memberService;
	@Autowired
	public KennelService kennelService;
	@Autowired
	public DogDnaService dogDnaService;
	@Autowired
	public DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	public DogBreedCertifiedService dogBreedCertifiedService;
	@Autowired
	public ChampionLoginService championLoginService;
	@Autowired
	public ClubDogService clubDogService;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	public ChampionLoginDao championLoginDao;
	@Autowired
	public DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private DogOwnerService dogOwnerService;
	@Autowired
	private DogStickerApplyService dogStickerApplyService;
	@Autowired
	private DogStickerDao dogStickerDao;
	@Autowired
	public DogNewbornDao dogNewbornDao;
	@Autowired
	private DogAmphimixisProveService dogAmphimixisProveService;
	@Autowired
	public DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogStickerService dogStickerService;
	@Autowired
	public DogAppraisalDao dogAppraisalDao;
	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;
	@Autowired
	private DogVideoAppraisalDao dogVideoAppraisalDao;
	@Autowired
	private MemberDao memberDao;

	private SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy/M/d");

	private SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy年M月d日");

	private SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy.M.d");

	private static final Date dcPrintTypeStartTime;

	@Value("${cabPassportServiceUrl}")
	private String cabPassportServiceUrl;

	private static final String DOG_CLASS_URL = Global.getConfig("cabPassportServiceUrl")
			+ "/cab/petClass/search?identificationFlag=";
	private static final String DOG_ACTIVE_URL = Global.getConfig("cabPassportServiceUrl") + "/cab/petClass/active";

	static {
		try {
			dcPrintTypeStartTime = new SimpleDateFormat("yyyy/M/d").parse("2024/03/05");
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
	}
	
	public RESTResponse getMyDog(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
		String dogBreed = request.getParameter("dogBreed");
		String gender = request.getParameter("gender");
		String birthdateYear = request.getParameter("birthdateYear");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String dogState = request.getParameter("dogState");
		String changeType = request.getParameter("changeType");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		Dog example = new Dog();
		// 设置分页参数
		Page<Dog> page = new Page<Dog>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		if (StringUtils.isNotBlank(dogBreed)) {
			example.setDogBreed(dogBreed);
		}
		if (StringUtils.isNotBlank(gender)) {
			example.setGender(gender);
		}
		if (StringUtils.isNotBlank(birthdateYear)) {
			example.setBirthdateYear(birthdateYear);
		}
		// //只显示犬只状态为正常的
		// example.setDogState("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(pedigreeCertifiedCode)) {
			example.setPedigreeCertifiedCode(pedigreeCertifiedCode);
		}
		if (StringUtils.isNotBlank(fmdogBreedCertifiedCode)) {
			example.setFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
		}
		example.setDogState(dogState);

		if (StringUtils.isNotBlank(changeType) && "4".equals(changeType)) {
			example.setEcertFlag("1");
		}
		// 查询并组装返回对象
		Page<Dog> result = dogService.findPage(page, example);
		List<Dog> dogList = result.getList();
		List<RestDog> list = new ArrayList<RestDog>();
		for (Dog dog : dogList) {
			RestDog vo = new RestDog();
			BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
			String breedCnName = "";
			DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
			if (dogType != null) {
				breedCnName = dogType.getBreedCnName();
			} else {
				breedCnName = dogTypeService.getUnMapBreedCnName(vo.getDogBreed());
			}
			vo.setDogBreedName(breedCnName);
			vo.setColorFlag(dogColorMarkService.getDogColorMarkCn(dog.getColorFlag()));
			vo.setStudDogCoverImg(getString(ImgUtil.getImgUrl(request, dogService.getDogImgById(dog.getId()))));
			// DNA位点分析
			vo.setDogDnaArchiveFlag(false);
			DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByPedigreeCertifiedCode(dog.getPedigreeCertifiedCode());
			if (dogDnaArchive == null || "1".equals(dogDnaArchive.getPaymentState())) {
				vo.setDogDnaArchiveFlag(true);
			}
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestDog>(list, count));
	}

	private String getString(String str) {
		return str == null ? "" : str;
	}

	public RESTResponse getOneByPedigreeCertified(HttpServletRequest request) {
		// 获取参数
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		// 参数校验
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		// 查询并组装返回对象
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		if (dog == null) {
			// 支持根据芯片号进行查询
			dog = dogService.getByIdentificationFlag(pedigreeCertifiedCode);
			if (dog == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号或芯片号");
			}
		}
		// 校验犬只是否能办理当前登录类型的业务
		Member byMemberCode = memberService.getByMemberCode(dog.getMemberCode());
		if (byMemberCode != null) {
			dog.setDogOwnerSite(byMemberCode.getMemberSite());
		}
		loginServerService.validDogType(dog);

		RestDog vo = new RestDog();
		BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
		if (StringUtils.isNotBlank(vo.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
			if (dogType != null) {
				vo.setDogBreedName(dogType.getBreedCnName());
			} else {
				vo.setDogBreedName(dogTypeService.getUnMapBreedCnName(vo.getDogBreed()));
			}
		}
		if (StringUtils.isNotBlank(vo.getColorFlag())) {
			DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(vo.getColorFlag());
			if (dogColorMark != null) {
				vo.setColorFlag(dogColorMark.getDogColorMarkCn());
			}
		}
		return new RESTResponse("data", JSONObject.fromObject(vo));
	}

	/**
	 * 培训牵犬师(查询犬只接口)
	 *
	 * @Author chaixueteng
	 * @2017年8月29日下午4:43:23
	 */
	public RESTResponse getByPedigreeCertified(HttpServletRequest request) {
		// 获取参数
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		// 参数校验
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号为空");
		}
		// 查询并组装返回对象
		Dog dog = dogService.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		if (dog == null) {
			// 支持根据芯片号进行查询
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入正确的血统证书号或芯片号");
		}
		if (!"0".equals(dog.getDogState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只状态非正常");
		}
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(new Date());
		calendar.add(Calendar.YEAR, -1);
		Date oneYearBeforeDate = calendar.getTime();
		if (dog.getBirthdate().getTime() >= oneYearBeforeDate.getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄不足1岁");
		}
		RestDog vo = new RestDog();
		BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
		if (StringUtils.isNotBlank(vo.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
			if (dogType != null) {
				vo.setDogBreedName(dogType.getBreedCnName());
			} else {
				vo.setDogBreedName(dogTypeService.getUnMapBreedCnName(vo.getDogBreed()));
			}
		}
		if (StringUtils.isNotBlank(vo.getColorFlag())) {
			DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(vo.getColorFlag());
			if (dogColorMark != null) {
				vo.setColorFlag(dogColorMark.getDogColorMarkCn());
			}
		}
		return new RESTResponse("data", JSONObject.fromObject(vo));
	}

	public RESTResponse getParentDogBloodlineByKey(HttpServletRequest request) {
		// 获取参数
		String key = request.getParameter("key");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		// 参数校验
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}
		Dog dog = dogService.getByPedigreeCertifiedCode(key);
		if (dog == null) {
			dog = dogService.getByPedigreeCertifiedEn(key);
			if (dog == null) {
				dog = dogService.getByIdentificationFlag(key);
			}
		}
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号/芯片号有误");
		}
		if ("ckumc".equals(source) && !"15C".equals(dog.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询犬只非玛犬！");
		}
		// 犬只状态为已删除、未审核、已注销、已冻结的提示
		String dogState = dog.getDogState();
		if ("1".equals(dogState) || "2".equals(dogState) || "3".equals(dogState) || "4".equals(dogState)
				|| "5".equals(dogState)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此证书状态异常，详情请致电宠爱王国客服热线。400-660-7000");
		}

		if (StringUtils.isNotBlank(dog.getFdogPedigreeCertified())
				&& StringUtils.isNotBlank(dog.getMdogPedigreeCertified())) {
			return new RESTResponse("data",
					bloodlineNew(dog.getFdogPedigreeCertified(), dog.getMdogPedigreeCertified()));
		}
		JSONObject jo = new JSONObject();
		jo.put("father", new JSONArray());
		jo.put("mother", new JSONArray());
		jo.put("infos", new JSONArray());
		return new RESTResponse("data", jo);
	}

	public RESTResponse getByKey(HttpServletRequest request) {
		return getByKey(request, false);
	}

	private boolean isSCode(String code) {
		code = code.toLowerCase().trim();
		if (code.endsWith("s") && isNumber(code)) {
			return true;
		}
		return false;
	}

	private boolean isNumber(String str) {
		str = str.substring(0, str.length() - 1);
		Pattern pattern = Pattern.compile("[0-9]*");
		Matcher isNum = pattern.matcher(str);
		if (!isNum.matches()) {
			return false;
		}
		return true;
	}

	/**
	 *
	 * @description: CKU官网根据血统证书号或芯片号进行查询
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午5:24:44
	 */
	public RESTResponse getByKey(HttpServletRequest request, boolean isShowNotCkuDog) {
		// 获取参数
		String key = request.getParameter("key");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		// 参数校验
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}

		Dog dog = dogService.getByPedigreeCertifiedCode(key);
		if (dog == null) {
			dog = dogService.getByPedigreeCertifiedEn(key);
			if (dog == null) {
				dog = dogService.getByIdentificationFlag(key);
			}
		}
		ClubDog clubDog = null;
		if (dog == null) {// 查询淘宠宝鉴定犬信息
			clubDog = clubDogService.getByPedigreeCertifiedCode(key);
			if (clubDog == null) {
				clubDog = clubDogService.getByIdentificationFlag(key);
			}
		}
		if (clubDog != null) {// 拼装鉴定犬信息
			dog = new Dog();
			dog.setPedigreeCertifiedCode(clubDog.getPedigreeCertifiedCode());
			dog.setBirthdate(clubDog.getBirthdate());
			dog.setDogBreed(clubDog.getDogBreed());
			dog.setGender(clubDog.getGender());
			dog.setColorFlag(clubDog.getColorFlag());
			dog.setNameCn(clubDog.getNameCn());
			dog.setNameEn(clubDog.getNameEn());
			dog.setIdentificationFlag(clubDog.getIdentificationFlag());
			dog.setDogOwner(clubDog.getDogOwner());
			dog.setDogState("");
		}
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号/芯片号有误");
		}
		if ("ckumc".equals(source) && !"15C".equals(dog.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询犬只非玛犬！");
		}
		if (!isShowNotCkuDog) {
			// 如果血统证书号不为CKU开头，根据外国血统证书号进行查询
			if (!dog.getPedigreeCertifiedCode().toUpperCase().startsWith("CKU")) {
				// 根据国外证书号查询
				Dog otherDog = dogService.getCkuDogByPedigreeCertifiedEn(dog.getPedigreeCertifiedCode());
				if (otherDog != null) {
					dog = otherDog;
				} else {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "目前暂时不支持此种证书号或芯片号的查询");
				}
			}
		}
		// 犬只状态为已删除、未审核、已注销、已冻结的提示
		String dogState = dog.getDogState();
		if ("1".equals(dogState) || "2".equals(dogState) || "3".equals(dogState) || "4".equals(dogState)
				|| "5".equals(dogState)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此证书状态异常，详情请致电宠爱王国客服热线。400-660-7000");
		}
		RestDog vo = new RestDog();
		BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
		if (StringUtils.isNotBlank(vo.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
			if (dogType != null) {
				vo.setDogBreedName(dogType.getBreedCnName());
				vo.setDogBreedNameEn(dogType.getBreedEnName());
			} else {
				vo.setDogBreedName(dogTypeService.getUnMapBreedCnName(vo.getDogBreed()));
				vo.setDogBreedNameEn("");
			}
		}

		vo.setGender(DictUtils.getDictLabel(vo.getGender(), "dog_gender", ""));
		return dogInfo(vo, dog);
	}

	public RESTResponse getDogClassByKeyWithCaptcha(HttpServletRequest request) {
		String identificationFlag = request.getParameter("identificationFlag");
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}
		PetClass petClass;
		Dog dog = dogService.getByIdentificationFlag(identificationFlag);
		if (dog != null) {
			petClass = new PetClass();
			petClass.setCabPassport(dog.getCabPassport());
			petClass.setPetName(dog.getNameEn());
			petClass.setPetGender(dog.getGender());
			petClass.setIdentificationFlag(dog.getIdentificationFlag());
			petClass.setPetType("狗");
			petClass.setPetBirthday(DateUtils.formatDate(dog.getBirthdate(), "yyyy-MM-dd"));
			petClass.setPetBreeadCnName(dogTypeService.getBreedCnName(dog.getDogBreed()));
			petClass.setPetBreead(dog.getDogBreed());
			DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dog.getColorFlag());
			petClass.setPetCoatColor(dogColorMark != null ? dogColorMark.getDogColorMarkCn() : null);
//			String alreadyHaveClass = dogStickerApplyService.getAlreadyHaveClass(identificationFlag);
//			petClass.setPetClassName(dogStickerApplyService.getStickerClass(alreadyHaveClass));
			int maxClass = dogStickerApplyService.getAlreadyHaveMaxClass(identificationFlag);
			if (maxClass == 0) {
				petClass.setPetClass("");
				petClass.setCabRegisterCode("");
				petClass.setPetClassName("");
			} else {
				petClass.setPetClass(dogStickerApplyService.getClassEnNameByClass(maxClass));
				petClass.setPetClassName(dogStickerApplyService.getStickerClass(maxClass + ""));
				DogSticker dogSticker = dogStickerDao.getByIdentificationFlagAndClass(identificationFlag,
						String.valueOf(maxClass));
				if (dogSticker == null) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到该宠物的信息！");
				}
				petClass.setCabRegisterCode(dogSticker.getStickerNo());
			}
		} else {
			petClass = this.getDogClassInfo(identificationFlag);
		}
		if (petClass == null || StringUtils.isBlank(petClass.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到该宠物的等级信息！");
		}
		return new RESTResponse("data", petClass);
	}

	public PetClass getDogClassInfo(String identificationFlag) {
		List<DogBirthCertificate> list = dogBirthCertificateService.getByIdentificationFlagList(identificationFlag);
		PetClass petClass;
		if (!Collections3.isEmpty(list)) {
			DogBirthCertificate dogBirthCertificate = list.get(0);
			petClass = new PetClass();
			petClass.setCabPassport(dogBirthCertificate.getCabPassport());
			petClass.setBirthCerRegCode(dogBirthCertificate.getBirthCerRegCode());
			petClass.setPetName(dogBirthCertificate.getDogEnName());
			petClass.setPetGender(dogBirthCertificate.getDogGender());
			petClass.setIdentificationFlag(dogBirthCertificate.getIdentificationFlag());
			petClass.setPetType("狗");
			petClass.setPetBirthday(DateUtils.formatDate(dogBirthCertificate.getDogBirthday(), "yyyy-MM-dd"));
			petClass.setPetBreeadCnName(dogTypeService.getBreedCnName(dogBirthCertificate.getDogBreed()));
			petClass.setPetBreead(dogBirthCertificate.getDogBreed());
			petClass.setPetCoatColor(
					dogColorMarkService.getByDogColorMarkCode(dogBirthCertificate.getColorFlag()).getDogColorMarkCn());
			String alreadyHaveClass = dogStickerApplyService.getAlreadyHaveClass(identificationFlag);
			if (StringUtils.isNotBlank(alreadyHaveClass)) {
				String petclassCode = dogStickerApplyService.getStickerClass(alreadyHaveClass);
				petClass.setPetClassName(petclassCode);
				petClass.setPetClass(petclassCode.substring(petclassCode.indexOf("(") + 1, petclassCode.indexOf(")")));
				List<DogSticker> stickers = dogStickerDao.getByIdentificationFlag(identificationFlag);
				if (Collections3.isEmpty(stickers)) {
					petClass.setCabRegisterCode("");
				} else {
					petClass.setCabRegisterCode(stickers.get(0).getStickerNo());
				}
			} else {
				if (StringUtils.isNotBlank(dogBirthCertificate.getClassPrintStatus())
						&& dogBirthCertificate.getClassPrintStatus().equals("9")) {
					petClass.setPetClassName("纯种级（E）");
					petClass.setPetClass("E");
					petClass.setCabRegisterCode(dogBirthCertificate.getCabPassport().replace("N", "P"));
				} else {
					petClass.setPetClassName("");
					petClass.setPetClass("");
					petClass.setCabRegisterCode("");
				}
			}
		} else {
			DogVideoAppraisal dogVideoAppraisal = dogVideoAppraisalDao.getByIdentificationFlag(identificationFlag);
			if (dogVideoAppraisal != null) {
				petClass = new PetClass();
				petClass.setCabPassport(dogVideoAppraisal.getPassportNo());
				petClass.setPetName(dogVideoAppraisal.getDogName());
				petClass.setPetGender(dogVideoAppraisal.getDogGender());
				petClass.setIdentificationFlag(dogVideoAppraisal.getChipNo());
				petClass.setPetType("狗");
				petClass.setPetBirthday(DateUtils.formatDate(dogVideoAppraisal.getDogBirth(), "yyyy-MM-dd"));
				petClass.setPetBreeadCnName(dogVideoAppraisal.getDogBreedCn());
				petClass.setPetBreead(dogVideoAppraisal.getDogBreed());
				petClass.setPetCoatColor(dogVideoAppraisal.getDogColorCn());
				if (StringUtils.isNotBlank(dogVideoAppraisal.getPassportNo())) {
					petClass.setCabRegisterCode("");
					petClass.setPetClassName("纯种级（E）");
					petClass.setPetClass("E");
				} else {
					petClass.setCabRegisterCode("");
					petClass.setPetClassName("");
					petClass.setPetClass("");
				}
			} else {
				String data = (String) getDogClassFromPassport(identificationFlag);
				petClass = BeanUtil.toBean(data, PetClass.class);
				if (petClass != null && StringUtils.isNotBlank(petClass.getPetBreead())) {
					petClass.setPetBreeadCnName(petClass.getPetBreead());
				}

			}
		}
		return petClass;
	}

	public Object getDogClassFromPassport(String identificationFlag) {
		try {
			OkHttpClient client = new OkHttpClient();
			// 获取breedCode
			Request request = new Request.Builder().url(DOG_CLASS_URL + identificationFlag).build();
			Object data = client.newCall(request).execute().body().string();
			return data;
		} catch (Exception e) {
			return null;
		}
	}

	public RESTResponse dogInfo(RestDog vo, Dog dog) {
		JSONObject jo = new JSONObject();
		// 犬基本信息
		vo.setPedigreeCertifiedCode(PedigreeCertifiedCodeUtil.getCode(vo.getPedigreeCertifiedCode()));
		vo.setPedigreeCertifiedEn(PedigreeCertifiedCodeUtil.getCode(vo.getPedigreeCertifiedEn()));
		jo.put("dog", vo);
		// 祖先信息
		//如果为金质证书降级则不显示祖辈信息
		if (!GoldCertifiedStateEnum.DOWNGRADE.code().equals(dog.getGoldCertifiedState())) {
			setBloodline(dog, jo);
		}
		// 全犬种赛事成绩
		setShowResultsArray(dog.getPedigreeCertifiedCode(), jo, "showResultsArray");
		// 单独展赛事成绩
		setShowResultsDdzArray(dog.getPedigreeCertifiedCode(), jo, "showResultsDdzArray");
		// 外国血统证书号下的全犬种赛事成绩
		setShowResultsArray(dog.getPedigreeCertifiedEn(), jo, "enShowResultsArray");
		// 外国血统证书号下的单独展赛事成绩
		setShowResultsDdzArray(dog.getPedigreeCertifiedEn(), jo, "enShowResultsDdzArray");
		// 犬主人组赛事成绩
		setShowResultsOwnerArray(dog.getPedigreeCertifiedCode(), jo, "showResultsOwnerArray");
		// 外国血统证书号下的犬主人组赛事成绩
		setShowResultsOwnerArray(dog.getPedigreeCertifiedEn(), jo, "enShowResultsOwnerArray");
		return new RESTResponse("data", jo);
	}

	public void desensitize(JSONObject data) {
		if (data == null) {
			return;
		}
		desensitizeJsonDogType(data, "dog");
		for (int i = 1; i <= 14; i++) {
			desensitizeJsonDogType(data, "dog" + i);
		}
	}
	
	public void desensitizeBloodline(JSONObject data) {
		if (data == null) {
			return;
		}
		if (data.get("father") != null) {
			JSONArray father = (JSONArray) data.get("father");
			for (int i = 0; i < father.size(); i++) {
				desensitizeJsonDog(father.getJSONObject(i));
			}
		}
		if (data.get("mother") != null) {
			JSONArray mother = (JSONArray) data.get("mother");
			for (int i = 0; i < mother.size(); i++) {
				desensitizeJsonDog(mother.getJSONObject(i));
			}
		}
	}

	private void desensitizeJsonDogType(JSONObject jo, String dogtype) {
		if (jo.get(dogtype) != null) {
			JSONObject vo = (JSONObject) jo.get(dogtype);
			desensitizeJsonDog(vo);
		}
	}

	private void desensitizeJsonDog(JSONObject dog) {
		if (dog != null) {
			if (StringUtils.isNotBlank((String) dog.get("pedigreeCertifiedCode"))) {
				dog.put("pedigreeCertifiedCode", DesensitizeUtils.desensitize((String) dog.get("pedigreeCertifiedCode"),
						DesensitizeUtils.TEXT_TYPE_PEDIGREECERTIFIEDCODE));
			}
			if (StringUtils.isNotBlank((String) dog.get("identificationFlag"))) {
				dog.put("identificationFlag", DesensitizeUtils.desensitize((String) dog.get("identificationFlag"),
						DesensitizeUtils.TEXT_TYPE_IDENTIFICATIONFLAG));
			}
			if (StringUtils.isNotBlank((String) dog.get("mdogPedigreeCertified"))) {
				dog.put("mdogPedigreeCertified", DesensitizeUtils.desensitize((String) dog.get("mdogPedigreeCertified"),
						DesensitizeUtils.TEXT_TYPE_PEDIGREECERTIFIEDCODE));
			}
			if (StringUtils.isNotBlank((String) dog.get("fdogPedigreeCertified"))) {
				dog.put("fdogPedigreeCertified", DesensitizeUtils.desensitize((String) dog.get("fdogPedigreeCertified"),
						DesensitizeUtils.TEXT_TYPE_PEDIGREECERTIFIEDCODE));
			}
		}
	}

	/**
	 *
	 * @description: 祖先信息
	 * @author: laiguanglong
	 * @date: 2016年9月29日 上午10:33:58
	 */
	public void setBloodline(Dog dog, JSONObject jo) {
		DogPedigreeCertifiedExport temp = new DogPedigreeCertifiedExport();
		dogPedigreeCertifiedExportService.set3Generation(temp, dog);
		jo.put("dog1", new CkuDog(temp.getDog1()));
		jo.put("dog2", new CkuDog(temp.getDog2()));
		jo.put("dog3", new CkuDog(temp.getDog3()));
		jo.put("dog4", new CkuDog(temp.getDog4()));
		jo.put("dog5", new CkuDog(temp.getDog5()));
		jo.put("dog6", new CkuDog(temp.getDog6()));
		jo.put("dog7", new CkuDog(temp.getDog7()));
		jo.put("dog8", new CkuDog(temp.getDog8()));
		jo.put("dog9", new CkuDog(temp.getDog9()));
		jo.put("dog10", new CkuDog(temp.getDog10()));
		jo.put("dog11", new CkuDog(temp.getDog11()));
		jo.put("dog12", new CkuDog(temp.getDog12()));
		jo.put("dog13", new CkuDog(temp.getDog13()));
		jo.put("dog14", new CkuDog(temp.getDog14()));
	}

	/**
	 *
	 * @description: 全犬种赛事成绩
	 * @author: laiguanglong
	 * @date: 2016年9月29日 上午10:31:29
	 */
	@Autowired
	private ShowResultsDao showResultsDao;

	public void setShowResultsArray(String pedigreeCertifiedCode, JSONObject jo, String name) {
		JSONArray ja = new JSONArray();
		if (StringUtils.isNotBlank(pedigreeCertifiedCode)) {
			for (ShowResults showResults : showResultsDao.getByKey(pedigreeCertifiedCode)) {
				ja.add(new RestShowResults(showResults));
			}
		}
		jo.put(name, ja);
	}

	public void setShowResultsOwnerArray(String pedigreeCertifiedCode, JSONObject jo, String name) {
		JSONArray ja = new JSONArray();
		if (StringUtils.isNotBlank(pedigreeCertifiedCode)) {
			List<ShowResults> resultsList = showResultsDao.getByKeyAndIsOwner(pedigreeCertifiedCode, "1");
			if (!Collections3.isEmpty(resultsList)) {
				for (ShowResults showResults : resultsList) {
					ja.add(new RestShowResults(showResults));
				}
			}
		}
		jo.put(name, ja);
	}

	/**
	 *
	 * @description: 单独展赛事成绩
	 * @author: laiguanglong
	 * @date: 2016年9月29日 上午10:28:41
	 */
	@Autowired
	private ShowResultsDdzDao showResultsDdzDao;

	public void setShowResultsDdzArray(String pedigreeCertifiedCode, JSONObject jo, String name) {
		JSONArray ja = new JSONArray();
		if (StringUtils.isNotBlank(pedigreeCertifiedCode)) {
			for (ShowResultsDdz showResultsDdz : showResultsDdzDao.getByKey(pedigreeCertifiedCode)) {
				ja.add(new RestShowResultsDdz(showResultsDdz));
			}
		}
		jo.put(name, ja);
	}

	@Autowired
	private DogPedigreeCertifiedExportService dogPedigreeCertifiedExportService;

	/**
	 *
	 * @description: CKU官网近亲查询
	 * @author: laiguanglong
	 * @date: 2016年9月28日 下午2:09:35
	 */
	public RESTResponse bloodline(HttpServletRequest request) {
		// 获取参数
		String fatherPedigreeCertified = request.getParameter("fatherPedigreeCertified");
		String motherPedigreeCertified = request.getParameter("motherPedigreeCertified");
		String source = null;
		if (request.getAttribute("source") != null) {
			source = (String) request.getAttribute("source");
		}
		if (StringUtils.isBlank(fatherPedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬血统证书号为空");
		}
		if (StringUtils.isBlank(motherPedigreeCertified)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬血统证书号为空");
		}
		// return new RESTResponse("data", bloodline(fatherPedigreeCertified,
		// motherPedigreeCertified));
		if ("ckumc".equals(source)) {
			Dog fatherDog = dogService.getByPedigreeCertifiedCode(fatherPedigreeCertified);
			Dog motherDog = dogService.getByPedigreeCertifiedCode(motherPedigreeCertified);
			if (!"15C".equals(fatherDog.getDogBreed()) || !"15C".equals(motherDog.getDogBreed())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询犬只非玛犬！");
			}
		}

		return new RESTResponse("data", bloodlineNew(fatherPedigreeCertified, motherPedigreeCertified));
	}

	public JSONObject bloodlineNew(String fatherPedigreeCertified, String motherPedigreeCertified) {
		// 根据血统证书号查询犬只信息
		Dog fatherDog = dogService.getByPedigreeCertifiedCode(fatherPedigreeCertified);
		Dog motherDog = dogService.getByPedigreeCertifiedCode(motherPedigreeCertified);
		if (fatherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬血统证书号不存在");
		}
		if (motherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬血统证书号不存在");
		}
		if ("1".equals(fatherDog.getDelFlag()) || !"1".equals(fatherDog.getGender())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬血统证书号有误");
		}
		if ("1".equals(motherDog.getDelFlag()) || !"2".equals(motherDog.getGender())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬血统证书号有误");
		}
		// if (!fatherDog.getDogBreed().equals(motherDog.getDogBreed())) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父母犬只必须为同类犬只");
		// }
		// 获取三代信息
		DogPedigreeCertifiedExport father = new DogPedigreeCertifiedExport();
		DogPedigreeCertifiedExport mother = new DogPedigreeCertifiedExport();
		dogPedigreeCertifiedExportService.set3GenerationNew(father, fatherDog);
		dogPedigreeCertifiedExportService.set3GenerationNew(mother, motherDog);
		JSONObject jo = new JSONObject();
		JSONArray fatherArray = setArray(father);
		JSONArray motherArray = setArray(mother);
		jo.put("father", fatherArray);
		jo.put("mother", motherArray);
		// 近亲繁殖信息
		jo.put("infos", setInfos(father, mother));
		return jo;
	}

	public JSONObject bloodline(String fatherPedigreeCertified, String motherPedigreeCertified) {
		// 根据血统证书号查询犬只信息
		Dog fatherDog = dogService.getByPedigreeCertifiedCode(fatherPedigreeCertified);
		Dog motherDog = dogService.getByPedigreeCertifiedCode(motherPedigreeCertified);
		if (fatherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬血统证书号不存在");
		}
		if (motherDog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬血统证书号不存在");
		}
		if ("1".equals(fatherDog.getDelFlag()) || !"1".equals(fatherDog.getGender())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父犬血统证书号有误");
		}
		if ("1".equals(motherDog.getDelFlag()) || !"2".equals(motherDog.getGender())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "母犬血统证书号有误");
		}
		if (!fatherDog.getDogBreed().equals(motherDog.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "父母犬只必须为同类犬只");
		}
		// 获取三代信息
		DogPedigreeCertifiedExport father = new DogPedigreeCertifiedExport();
		DogPedigreeCertifiedExport mother = new DogPedigreeCertifiedExport();
		dogPedigreeCertifiedExportService.set3Generation(father, fatherDog);
		dogPedigreeCertifiedExportService.set3Generation(mother, motherDog);
		JSONObject jo = new JSONObject();
		JSONArray fatherArray = setArray(father);
		JSONArray motherArray = setArray(mother);
		jo.put("father", fatherArray);
		jo.put("mother", motherArray);
		// 近亲繁殖信息
		jo.put("infos", setInfos(father, mother));
		return jo;
	}

	private JSONArray setArray(DogPedigreeCertifiedExport vo) {
		JSONArray array = new JSONArray();
		array.add(new CkuDog(vo.getDog()));
		array.add(new CkuDog(vo.getDog1()));
		array.add(new CkuDog(vo.getDog2()));
		array.add(new CkuDog(vo.getDog3()));
		array.add(new CkuDog(vo.getDog4()));
		array.add(new CkuDog(vo.getDog5()));
		array.add(new CkuDog(vo.getDog6()));
		array.add(new CkuDog(vo.getDog7()));
		array.add(new CkuDog(vo.getDog8()));
		array.add(new CkuDog(vo.getDog9()));
		array.add(new CkuDog(vo.getDog10()));
		array.add(new CkuDog(vo.getDog11()));
		array.add(new CkuDog(vo.getDog12()));
		array.add(new CkuDog(vo.getDog13()));
		array.add(new CkuDog(vo.getDog14()));
		return array;
	}

	private JSONArray setInfos(DogPedigreeCertifiedExport father, DogPedigreeCertifiedExport mother) {
		HashMap<String, Integer> motherMap = new HashMap<String, Integer>();
		motherMap.put(mother.getDog().getPedigreeCertifiedCode(), 1);
		motherMap.put(mother.getDog1().getPedigreeCertifiedCode(), 2);
		motherMap.put(mother.getDog2().getPedigreeCertifiedCode(), 2);
		motherMap.put(mother.getDog3().getPedigreeCertifiedCode(), 3);
		motherMap.put(mother.getDog4().getPedigreeCertifiedCode(), 3);
		motherMap.put(mother.getDog5().getPedigreeCertifiedCode(), 3);
		motherMap.put(mother.getDog6().getPedigreeCertifiedCode(), 3);
		motherMap.put(mother.getDog7().getPedigreeCertifiedCode(), 4);
		motherMap.put(mother.getDog8().getPedigreeCertifiedCode(), 4);
		motherMap.put(mother.getDog9().getPedigreeCertifiedCode(), 4);
		motherMap.put(mother.getDog10().getPedigreeCertifiedCode(), 4);
		motherMap.put(mother.getDog11().getPedigreeCertifiedCode(), 4);
		motherMap.put(mother.getDog12().getPedigreeCertifiedCode(), 4);
		motherMap.put(mother.getDog13().getPedigreeCertifiedCode(), 4);
		motherMap.put(mother.getDog14().getPedigreeCertifiedCode(), 4);
		JSONArray infoArray = new JSONArray();
		setInfo(father.getDog(), 1, motherMap, infoArray);
		setInfo(father.getDog1(), 2, motherMap, infoArray);
		setInfo(father.getDog2(), 2, motherMap, infoArray);
		setInfo(father.getDog3(), 3, motherMap, infoArray);
		setInfo(father.getDog4(), 3, motherMap, infoArray);
		setInfo(father.getDog5(), 3, motherMap, infoArray);
		setInfo(father.getDog6(), 3, motherMap, infoArray);
		setInfo(father.getDog7(), 4, motherMap, infoArray);
		setInfo(father.getDog8(), 4, motherMap, infoArray);
		setInfo(father.getDog9(), 4, motherMap, infoArray);
		setInfo(father.getDog10(), 4, motherMap, infoArray);
		setInfo(father.getDog11(), 4, motherMap, infoArray);
		setInfo(father.getDog12(), 4, motherMap, infoArray);
		setInfo(father.getDog13(), 4, motherMap, infoArray);
		setInfo(father.getDog14(), 4, motherMap, infoArray);
		return infoArray;
	}

	private void setInfo(Dog dog, Integer fgroup, HashMap<String, Integer> motherMap, JSONArray infoArray) {
		JSONObject jo = new JSONObject();
		String state = "";
		if (StringUtils.isBlank(dog.getPedigreeCertifiedCode())) {
			return;
		}
		Integer mgroup = motherMap.get(dog.getPedigreeCertifiedCode());
		if (mgroup == null) {
			return;
		}
		// 近亲判断
		if (dogService.closeRelative(fgroup, mgroup)) {
			state = "1";
		}
		jo.put("value", dog.getNameEn() + "(" + fgroup + "-" + mgroup + ")");
		jo.put("state", state);
		infoArray.add(jo);
	}

	public RESTResponse evaluate(HttpServletRequest request) {
		RESTResponse result = this.getByKey(request);

		if (result.getRc() == 0) {
			JSONObject jo = new JSONObject();
			JSONObject jsonObj = JSONObject.fromObject(result.getData());

			String breedCode = "";
			int age = 0;
			String tradingCity = "";
			String kennelName = "";
			String certificateType = "";
			int pedigree = 0;
			String parentAward = "";
			String disqualification = "";
			String selfAward = "";
			String memberCode = "";
			String pedigreeCertifiedCode = "";
			String birthdate = "";
			String DNA = "";
			String breedReview = "";
			String dogID = "";

			DogDna dogDna;
			DogBreedCertified dogBreedCertified;
			String dogGeneration = "";

			String fPedigree = "";
			String mPedigree = "";

			String fChampion = "";
			String mChampion = "";
			String dogDNAcode = "";
			String dogBreedCertifiedCode = "";

			breedCode = jsonObj.getJSONObject("data").getJSONObject("dog").getString("dogBreedName");
			birthdate = jsonObj.getJSONObject("data").getJSONObject("dog").getString("birthdate");
			memberCode = jsonObj.getJSONObject("data").getJSONObject("dog").getString("memberCode");
			age = getMonth(birthdate);
			tradingCity = memberService.getByMemberCode(memberCode).getCity();
			Date date = new Date();
			date = DateUtils.setHours(date, 0);
			date = DateUtils.setMinutes(date, 0);
			date = DateUtils.setSeconds(date, 0);
			Kennel kennel = kennelService.getKennelByMemberCode(memberCode);
			if (kennel != null && kennel.getEndTime().getTime() >= date.getTime()) {
				kennelName = kennel.getName();
			} else {
				kennelName = "";
			}

			pedigreeCertifiedCode = jsonObj.getJSONObject("data").getJSONObject("dog")
					.getString("pedigreeCertifiedCode");
			dogID = jsonObj.getJSONObject("data").getJSONObject("dog").getString("id");
			dogDna = dogDnaService.getByDogId(dogID);
			if (dogDna != null) {
				dogDNAcode = dogDna.getDnaCode();
			}
			dogBreedCertified = dogBreedCertifiedService.getByDogId(dogID);
			if (dogBreedCertified != null) {
				dogBreedCertifiedCode = dogBreedCertified.getBreedCertifiedCode();
			}

			if (dogBreedCertifiedService.getByDogId(dogID) != null)

				certificateType = "无血统证书";
			if (pedigreeCertifiedCode != null && !pedigreeCertifiedCode.trim().equals(""))
				certificateType = "纯血统犬证书";

			dogGeneration = jsonObj.getJSONObject("data").getJSONObject("dog").getString("dogGeneration");

			fPedigree = jsonObj.getJSONObject("data").getJSONObject("dog").getString("fdogPedigreeCertified");
			mPedigree = jsonObj.getJSONObject("data").getJSONObject("dog").getString("mdogPedigreeCertified");

			if (dogGeneration != null)
				pedigree = Integer.parseInt(dogGeneration);
			fChampion = championLoginService.getChamploginType(fPedigree);
			mChampion = championLoginService.getChamploginType(mPedigree);
			parentAward = "无登录";
			if (fChampion != null || mChampion != null)
				parentAward = "单亲冠军";
			if (fChampion != null && mChampion != null)
				parentAward = "双亲冠军";
			selfAward = championLoginService.getChamploginType(pedigreeCertifiedCode);

			if (selfAward == null)
				selfAward = "";

			jo.put("breedCode", breedCode);
			jo.put("age", age);
			jo.put("tradingCity", tradingCity);
			jo.put("kennelName", kennelName);
			jo.put("certificateType", certificateType);
			jo.put("pedigree", pedigree);
			jo.put("parentAward", parentAward);
			jo.put("disqualification", disqualification);
			jo.put("selfAward", selfAward);

			return new RESTResponse("data", jo);
		} else {
			return result;
		}

	}

	public static int getMonth(String str) {
		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date date = sdf.parse(str);
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(date);
			Calendar calendarNow = Calendar.getInstance();
			Calendar temp = Calendar.getInstance();

			temp.add(Calendar.DATE, 1);
			int year = calendarNow.get(Calendar.YEAR) - calendar.get(Calendar.YEAR);
			int month = calendarNow.get(Calendar.MONTH) - calendar.get(Calendar.MONTH);

			if ((calendar.get(Calendar.DATE) == 1) && (temp.get(Calendar.DATE) == 1)) {
				return year * 12 + month + 1;
			} else if ((calendar.get(Calendar.DATE) != 1) && (temp.get(Calendar.DATE) == 1)) {
				return year * 12 + month;
			} else if ((calendar.get(Calendar.DATE) == 1) && (temp.get(Calendar.DATE) != 1)) {
				return year * 12 + month;
			} else {
				return (year * 12 + month - 1) < 0 ? 0 : (year * 12 + month);
			}
		} catch (Exception e) {
			e.printStackTrace();
			return 0;
		}
	}

	/**
	 * 淘宠宝犬只信息查询
	 *
	 * @Author chaixueteng
	 * @2017年10月12日下午4:06:16
	 */
	public RESTResponse getClubDogByKey(HttpServletRequest request) {
		return null;
	}

	/**
	 * 新版血统证书二维码扫描结果
	 *
	 * @Author chaixueteng
	 * @2018年3月8日下午4:06:16
	 */
	public RESTResponse scanMsgByDogKey(HttpServletRequest request) {
		// 获取参数
		String key = request.getParameter("key");
		// 参数校验
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请求参数缺失!");
		}
		// 查询犬信息
		Dog dog = dogService.getByPedigreeCertifiedCode(key);
		if (dog == null) {
			dog = dogService.getByIdentificationFlag(key);
		}
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "扫描数据信息有误,请前往CKU官网查询!");
		}
		// 犬只状态为已删除、未审核、已注销、已冻结的提示
		String dogState = dog.getDogState();
		if ("1".equals(dogState) || "2".equals(dogState) || "3".equals(dogState) || "4".equals(dogState)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此证书状态异常，详情请致电宠爱王国客服热线。400-660-7000");
		}
		RestDog vo = new RestDog();
		BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
		if (StringUtils.isNotBlank(vo.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
			if (dogType != null) {
				vo.setDogBreedName(dogType.getBreedCnName());
				vo.setDogBreedNameEn(dogType.getBreedEnName());
			} else {
				vo.setDogBreedName(dogTypeService.getUnMapBreedCnName(vo.getDogBreed()));
				vo.setDogBreedNameEn("");
			}
		}
		vo.setGender(DictUtils.getDictLabel(vo.getGender(), "dog_gender", ""));
		DogColorMark color = dogColorMarkService.getByDogColorMarkCode(vo.getColorFlag());
		vo.setColorFlag(Optional.ofNullable(color).map(DogColorMark::getDogColorMarkCn).orElse(""));
		JSONObject jo = new JSONObject();
		// 犬基本信息
		jo.put("dog", vo);
		// 祖先信息
		setBloodline(dog, jo);
		// 犬展荣耀
		setDogGloryMsg(dog.getPedigreeCertifiedCode(), jo);
		// 冠军登录信息
		setDogChampionLoginMsg(dog.getPedigreeCertifiedCode(), jo);
		desensitize(jo);
		return new RESTResponse("data", jo);
	}

	/**
	 * 犬展荣耀信息
	 *
	 * @Author chaixueteng
	 * @2018年3月8日下午4:06:16
	 */
	public void setDogGloryMsg(String pedigreeCertifiedCode, JSONObject jo) {
		int bis = showResultsDao.getBisCountByPedigreeCertified(pedigreeCertifiedCode);
		int big = showResultsDao.getBigCountByPedigreeCertified(pedigreeCertifiedCode);
		int bob = showResultsDao.getBobCountByPedigreeCertified(pedigreeCertifiedCode);
		if (bis > 0) {
			jo.put("dogGloryMsg", "全场总冠军 (BIS) × " + bis);
		} else if (bis <= 0 && big > 0) {
			jo.put("dogGloryMsg", "组别冠军（BIG） × " + big);
		} else if (bis <= 0 && big < 0 && bob > 0) {
			jo.put("dogGloryMsg", "单犬种冠军（BOB） × " + bob);
		} else {
			jo.put("dogGloryMsg", "无");
		}
	}

	/**
	 * 犬只登录信息
	 *
	 * @Author chaixueteng
	 * @2018年3月8日下午4:06:16
	 */
	public void setDogChampionLoginMsg(String pedigreeCertifiedCode, JSONObject jo) {
		List<String> loginTypeList = championLoginDao.getLoginTypeByPedigreeCertified(pedigreeCertifiedCode);
		jo.put("dogChampionLoginMsg", loginTypeList);
	}

	/**
	 *
	 *
	 * @Description：根据血统证书号获取犬只代数
	 * @author: zhuoHeng
	 * @version: 2018年3月28日
	 */
	public int getDogGeneration(String pedigreeCertifiedCode) {
		List<String> errorList = new ArrayList<>();
		errorList.add("NP37525602");
		errorList.add("LOSH0999052");
		errorList.add("NHSB 2386893");
		errorList.add("NHSB 1.873.962");
		errorList.add("WP75624301");
		errorList.add("NO INFORMATION");
		errorList.add("JR 79752");
		errorList.add("JR 81791");
		errorList.add("2100065327");
		errorList.add("RKF 1976148");
		errorList.add("BCU 006241");
		errorList.add("AKC WR05890102");
		errorList.add("KCTH I06110273");
		errorList.add("RKF 1995966");
		errorList.add("RKF 2616407");
		errorList.add("LOF 6GD.B.G 0");
		errorList.add("РКФ 0001601");
		errorList.add("AKC TR09136601");
		errorList.add("ROI 09/172767");
		errorList.add("LOSH 0936742");
		errorList.add("PKR 50356");
		errorList.add("RKF 2102808");
		errorList.add("JKC-NP/11-17840");
		errorList.add("MKA DG-354742-2011");
		errorList.add("UKU 0000909");
		errorList.add("DHM-56062/99");
		errorList.add("PT-01175/84");
		errorList.add("LR -15834/98");
		errorList.add("-");
		errorList.add("RKF 1044939");
		errorList.add("（ENCI）TC070934");
		errorList.add("KCC 00105963");
		errorList.add("RKF 1383768");
		errorList.add("IKC T49584");
		errorList.add("MET.ANG.BULL8254/09");
		errorList.add("RKF 2371039");
		errorList.add("ENCI04/105364");
		List<Map> list = new ArrayList<Map>();
		boolean all = true;
		Map<String, String> map = new HashMap<String, String>();
		map.put("1", pedigreeCertifiedCode);
		list.add(map);
		int time = 1;
		int generation = 0;
		while (all) {
			String str = list.get(0).keySet().toString().substring(1, list.get(0).keySet().toString().length() - 1);
			String tempCode = list.get(0).get(str).toString();
			Dog dog = null;
			// 过滤错误号码
			if (!errorList.contains(tempCode)) {
				dog = dogService.getByPedigreeCertifiedCode(tempCode);
			}
			// System.out.println("序号："+time+"犬只标识："+str+"犬只证书号："+dog.getPedigreeCertifiedCode());
			time++;
			if (list.size() == 0) {
				break;
			} else {
				list.remove(0);
			}
			if (dog != null && StringUtils.isNotBlank(dog.getFdogPedigreeCertified())
					&& StringUtils.isNotBlank(dog.getMdogPedigreeCertified())
					&& !"-".equals(dog.getFdogPedigreeCertified()) && !"-".equals(dog.getMdogPedigreeCertified())) {
				all = true;
				Map<String, String> mapF = new HashMap<String, String>();
				Map<String, String> mapM = new HashMap<String, String>();
				mapF.put(str + "1", dog.getFdogPedigreeCertified());
				list.add(mapF);
				mapM.put(str + "2", dog.getMdogPedigreeCertified());
				list.add(mapM);
			} else {
				all = false;
				// System.out.println("犬只代数："+(str.length()-1));
				generation = str.length() - 1;
			}
		}
		return generation;

	}

	/**
	 * @Description： 根据父母犬信息获取犬只代数
	 *
	 * @author: yuanshuai
	 * @date: 2018/4/12 10:43
	 */
	public int getDogGeneration(String fDogPedigreeCertified, String mDogPedigreeCertified) {
		int fDogGeneration = getDogGeneration(fDogPedigreeCertified);
		int mDogGeneration = getDogGeneration(mDogPedigreeCertified);
		// 取最小的代数+1
		return Math.min(fDogGeneration, mDogGeneration) + 1;
	}

	/**
	 *
	 * @description: 宠爱王国保险查询犬只信息
	 * @author: cuihuaiyu
	 * @date: 2018年3月23日 下午5:24:44
	 */
	public RESTResponse getByInsIdentificationFlag(HttpServletRequest request) {
		// 获取参数
		String identificationFlag = request.getParameter("identificationFlag");
		// 参数校验
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数为空");
		}
		InsuranceDog insuranceDog = new InsuranceDog();
		List<DogBirthCertificate> dogs = dogBirthCertificateService.getByIdentificationFlagList(identificationFlag);
		if (dogs.size() == 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号输入错误，请重新输入");
		} else if (dogs.size() > 1) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "此芯片号重复，暂不支持办理，请联系宠爱王国客服：4006607000。给您带来的不便，敬请谅解！");
		}

		DogBirthCertificate dogBirthCertificate = dogs.get(0);
		DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());

		insuranceDog.setBirthdate(DateUtils.formatDate(dogBirthCertificate.getDogBirthday()));
		insuranceDog.setBreeder(dogBirthCertificate.getBreeder());
		// insuranceDog.setCallName();
		insuranceDog.setColorFlag(dogBirthCertificate.getColorFlag());
		insuranceDog.setDogBreed(dogBirthCertificate.getDogBreed());

		insuranceDog.setDogBreedName(dogType.getBreedCnName());
		insuranceDog.setDogBreedNameEn(dogType.getBreedEnName());
		insuranceDog.setDogOwner(dogBirthCertificate.getDogOwenr());
		// insuranceDog.setDogState();
		insuranceDog.setGender(dogBirthCertificate.getDogGender());
		insuranceDog.setId(dogBirthCertificate.getId());
		insuranceDog.setIdentificationFlag(dogBirthCertificate.getIdentificationFlag());
		// insuranceDog.setLogout();
		insuranceDog.setMemberCode(dogBirthCertificate.getMemberCode());
		// insuranceDog.setNameCn();
		insuranceDog.setNameEn(dogBirthCertificate.getDogEnName());
		insuranceDog.setPedigreeCertifiedCode(dogBirthCertificate.getPedigreeCertified());

		// DogType dogType =
		// dogTypeService.getByDogBreedCode(insuranceDogs.get(0).getDogBreed());
		// if(dogType!=null){
		// insuranceDogs.get(0).setDogBreedName(dogType.getBreedCnName());
		// insuranceDogs.get(0).setDogBreedNameEn(dogType.getBreedEnName());
		// }else{
		// insuranceDogs.get(0).setDogBreedName(dogTypeService.getUnMapBreedCnName(insuranceDogs.get(0).getDogBreed()));
		// insuranceDogs.get(0).setDogBreedNameEn("");
		// }

		return new RESTResponse("data", JSONObject.fromObject(insuranceDog));
		// // 查询犬信息
		// List<InsuranceDog> insuranceDogs=
		// dogService.getByInsIdentificationFlag(identificationFlag);
		// if(insuranceDogs.size() == 0 ){
		// List<DogBirthCertificate> dogs =
		// dogBirthCertificateService.getByIdentificationFlagList(identificationFlag);
		// if (dogs.size() == 0) {
		// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号输入错误，请重新输入");
		// }else if (dogs.size() > 1 ) {
		// throw new ZAException(ZAErrorCode.ZA_ERROR,
		// "此芯片号重复，暂不支持办理，请联系宠爱王国客服：4006607000。给您带来的不便，敬请谅解！");
		// }else{
		// throw new ZAException(ZAErrorCode.ZA_ERROR, "您还未办理血统证书，请办理后再激活");
		// }
		// };
		// if (insuranceDogs.size() > 1 ) {
		// throw new ZAException(ZAErrorCode.ZA_ERROR,
		// "此芯片号重复，暂不支持办理，请联系宠爱王国客服：4006607000。给您带来的不便，敬请谅解！");
		// }
		// if (null != insuranceDogs.get(0).getDogBreed() &&
		// StringUtils.isNotBlank(insuranceDogs.get(0).getDogBreed())) {
		// DogType dogType = dogTypeService
		// .getByDogBreedCode(insuranceDogs.get(0).getDogBreed());
		// if(dogType!=null){
		// insuranceDogs.get(0).setDogBreedName(dogType.getBreedCnName());
		// insuranceDogs.get(0).setDogBreedNameEn(dogType.getBreedEnName());
		// }else{
		// insuranceDogs.get(0).setDogBreedName(dogTypeService.getUnMapBreedCnName(insuranceDogs.get(0).getDogBreed()));
		// insuranceDogs.get(0).setDogBreedNameEn("");
		// }
		// };
		// return new RESTResponse("data", JSONObject.fromObject(insuranceDogs.get(0)));
	}

	/**
	 *
	 * @description: 宠爱王国保险添加时查询犬只信息
	 * @author: wangjie
	 * @date: 2018年5月9日 下午5:24:44
	 */
	public RESTResponse getByInsIdentificationFlagWhenInsert(HttpServletRequest request) {
		// 获取参数
		String identificationFlag = request.getParameter("identificationFlag");
		// 参数校验
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空");
		}
		// 查询犬信息
		List<InsuranceDog> dogList = dogService.getByInsIdentificationFlag(identificationFlag);
		InsuranceDog insuranceDog;
		if (Collections3.isEmpty(dogList) || dogList.size() == 0) {
			List<DogBirthCertificate> dogs = dogBirthCertificateService.getByIdentificationFlagList(identificationFlag);
			if (Collections3.isEmpty(dogs) || dogs.size() == 0) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号输入错误，请重新输入");
			} else if (dogs.size() > 1) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "此芯片号重复，暂不支持办理，请联系宠爱王国客服：4006607000。给您带来的不便，敬请谅解！");
			} else {
				DogBirthCertificate dog = dogs.get(0);
				insuranceDog = new InsuranceDog();
				insuranceDog.setMemberCode(dog.getMemberCode());
				insuranceDog.setIdentificationFlag(dog.getIdentificationFlag());
				insuranceDog.setBirthdate(DateUtils.formatDateTime(dog.getDogBirthday()));
				insuranceDog.setColorFlag(dog.getColorFlag());
				insuranceDog.setGender(dog.getDogGender());
				insuranceDog.setBreeder(dog.getBreeder());
				insuranceDog.setNameCn(dog.getBreedCnName());
				insuranceDog.setDogOwner(dog.getDogOwenr());
				insuranceDog.setNameEn(dog.getDogEnName());
				insuranceDog.setDogBreed(dog.getDogBreed());
				insuranceDog.setPedigreeCertifiedCode(dog.getPedigreeCertified());
				DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
				if (dogType != null) {
					insuranceDog.setDogBreedName(dogType.getBreedCnName());
					insuranceDog.setDogBreedNameEn(dogType.getBreedEnName());
				} else {
					insuranceDog.setDogBreedName(dogTypeService.getUnMapBreedCnName(dog.getDogBreed()));
					insuranceDog.setDogBreedNameEn("");
				}
			}
		} else if (dogList.size() > 1) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "此芯片号重复，暂不支持办理，请联系宠爱王国客服：4006607000。给您带来的不便，敬请谅解！");
		} else {
			insuranceDog = dogList.get(0);
			if (null != insuranceDog.getDogBreed() && StringUtils.isNotBlank(insuranceDog.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(insuranceDog.getDogBreed());
				if (dogType != null) {
					insuranceDog.setDogBreedName(dogType.getBreedCnName());
					insuranceDog.setDogBreedNameEn(dogType.getBreedEnName());
				}
			} else {
				insuranceDog.setDogBreedName(dogTypeService.getUnMapBreedCnName(insuranceDog.getDogBreed()));
				insuranceDog.setDogBreedNameEn("");
			}
		}
		return new RESTResponse("data", JSONObject.fromObject(insuranceDog));
	}

	public RESTResponse checkActivite(HttpServletRequest request) {
		String identificationFlag = request.getParameter("identificationFlag");
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空");
		}
		String cabPassport = request.getParameter("cabPassport");
		if (StringUtils.isBlank(cabPassport)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "护照号为空");
		}
		DogOwner dogOwner = dogOwnerService.findByIdentificationFlagAndCabPassport(identificationFlag, cabPassport);
		if (null != dogOwner && dogOwner.getActivateDate() != null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该宠物已经激活");
		}
		PetClass petClass;
		List<DogBirthCertificate> list = dogBirthCertificateService.getByIdentificationFlagList(identificationFlag);
		if (!Collections3.isEmpty(list)) {
			DogBirthCertificate dogBirthCertificate = list.get(0);
			petClass = new PetClass();
			petClass.setCabPassport(dogBirthCertificate.getCabPassport());
			petClass.setPetName(dogBirthCertificate.getDogEnName());
			petClass.setIdentificationFlag(dogBirthCertificate.getIdentificationFlag());
			petClass.setPetType("狗");
			petClass.setPetBreeadCnName(dogTypeService.getBreedCnName(dogBirthCertificate.getDogBreed()));
			petClass.setFrom("2");
		} else {
			String data = (String) getDogClassFromPassport(identificationFlag);
			petClass = BeanUtil.toBean(data, PetClass.class);
			petClass.setPetBreeadCnName(petClass.getPetBreead());
			petClass.setFrom("1");
			if (StringUtils.isNotBlank(petClass.getActiveState()) && petClass.getActiveState().equals("1")) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该宠物已经激活");
			}
		}
		if (petClass == null || StringUtils.isBlank(petClass.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询不到该宠物的信息！");
		}
		if (!cabPassport.equals(petClass.getCabPassport())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号护照号不匹配，请重新输入！");
		}
		return new RESTResponse("data", petClass);
	}

	@Transactional(readOnly = false)
	public RESTResponse saveActivite(HttpServletRequest request) {
		String petOwnerMobile = request.getParameter("petOwnerMobile");
		if (StringUtils.isBlank(petOwnerMobile)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠物主人手机号为空");
		}
		String petOwnerName = request.getParameter("petOwnerName");
		if (StringUtils.isBlank(petOwnerName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠物主人姓名为空");
		}
		String petOwnerAddress = request.getParameter("petOwnerAddress");
		if (StringUtils.isBlank(petOwnerAddress)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "宠物主人地址为空");
		}
		String identificationFlag = request.getParameter("identificationFlag");
		if (StringUtils.isBlank(identificationFlag)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号为空");
		}
		String cabPassport = request.getParameter("cabPassport");
		if (StringUtils.isBlank(cabPassport)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "护照号为空");
		}
		String from = request.getParameter("from");
		if (StringUtils.isNotBlank(from) && from.equals("1")) {
			JSONObject json = new JSONObject();
			json.put("petOwnerName", petOwnerName);
			json.put("petOwnerAddress", petOwnerAddress);
			json.put("identificationFlag", identificationFlag);
			json.put("petOwnerMobile", petOwnerMobile);
			json.put("cabPassport", cabPassport);
			try {
				OkHttpClient client = new OkHttpClient();
				RequestBody body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"),
						json.toString());
				Request req = new Request.Builder().url(DOG_ACTIVE_URL).post(body).build();
				Response response = client.newCall(req).execute();
				String string = response.body().string();
				JSONObject jo = JSONObject.fromObject(string);
				if (!jo.get("rc").toString().equals("0")) {
					return new RESTResponse("-1", jo.get("msg"));
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		} else if (StringUtils.isNotBlank(from) && from.equals("2")) {
			dogOwnerService.saveDogOwner(identificationFlag, cabPassport, petOwnerAddress, petOwnerMobile,
					petOwnerName);
		}
		return new RESTResponse();
	}

	public RESTResponse getMyDogBYGenderAll(HttpServletRequest request) {
		Member member = UserUtils.getLoginMember();
		// 获取参数
		String pedigreeCertifiedCode = request.getParameter("pedigreeCertifiedCode");
		String fmdogBreedCertifiedCode = request.getParameter("fmdogBreedCertifiedCode");
		String dogBreed = request.getParameter("dogBreed");
		String gender = request.getParameter("gender");
		String birthdateYear = request.getParameter("birthdateYear");

		Dog example = new Dog();
		// 设置查询条件
		example.setMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		if (StringUtils.isNotBlank(dogBreed)) {
			example.setDogBreed(dogBreed);
		}
		if (StringUtils.isNotBlank(gender)) {
			example.setGender(gender);
		}
		if (StringUtils.isNotBlank(birthdateYear)) {
			example.setBirthdateYear(birthdateYear);
		}
		// //只显示犬只状态为正常的
		// example.setDogState("0");

		if (StringUtils.isNotBlank(pedigreeCertifiedCode)) {
			example.setPedigreeCertifiedCode(pedigreeCertifiedCode);
		}
		if (StringUtils.isNotBlank(fmdogBreedCertifiedCode)) {
			example.setFmdogBreedCertifiedCode(fmdogBreedCertifiedCode);
			;
		}
		// 查询并组装返回对象
		List<Dog> dogList = dogService.findList(example);
		List<RestDog> list = new ArrayList<RestDog>();
		for (Dog dog : dogList) {
			RestDog vo = new RestDog();
			BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
			String breedCnName = "";
			DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
			if (dogType != null) {
				breedCnName = dogType.getBreedCnName();
			} else {
				breedCnName = dogTypeService.getUnMapBreedCnName(vo.getDogBreed());
			}
			vo.setDogBreedName(breedCnName);
			vo.setColorFlag(dogColorMarkService.getDogColorMarkCn(dog.getColorFlag()));
			list.add(vo);
		}
		long count = dogList.size();
		return new RESTResponse("list", list);
	}

	@Transactional(readOnly = false)
	public RESTResponse certificateInfo(String id) throws Exception {
		Dog dog0 = dogService.get(id);
		if (dog0 == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		// 返回对象
		ViewCertificateVo vo = new ViewCertificateVo();
		// 1、获得整窝几公几母的信息
		buildtPuppyBirthInfo(vo, dog0);
		// 2、狗主人狗繁殖人信息
		if (StringUtils.isNotBlank(dog0.getBirthCertificateLevelCode())) {
			DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao
					.getByBirthCerRegCode(dog0.getBirthCertificateLevelCode());
			if (dogBirthCertificate != null) {
				vo.setBreeder(dogBirthCertificate.getBreeder());
				Member member2 = memberService.getByMemberCode(dogBirthCertificate.getBreederMemberCode());
				if (member2 != null)
					vo.setBreederEn(convertMemberName(member2.getNameEn()));
				// 第二繁殖人
				vo.setSecondBreeder(dogBirthCertificate.getSecondBreeder());
				vo.setSecondBreederMemberCode(dogBirthCertificate.getSecondBreederMemberCode());
				Member member = memberService.getByMemberCode(dogBirthCertificate.getSecondBreederMemberCode());
				if (member != null)
					vo.setSecondBreederEn(convertMemberName(member.getNameEn()));
			}
		}

		// 3、犬种信息
		DogType dogType = dogTypeService.getByDogBreedCode(dog0.getDogBreed());
		if (dogType == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"该犬只的犬种" + dog0.getDogBreed() + ",在犬种表无法找到对应的记录，请检查是否有该犬种");
		vo.setDogBreed(dogType.getBreedEnName());
		vo.setDogBreedDesc(dogType.getBreedCnName());
		// 4、犬舍名称
		if (StringUtils.isNotBlank(dog0.getBreederMemberCode())) {
			Kennel kennel = kennelService.getKennelByMemberCode(dog0.getBreederMemberCode());
			if (kennel != null) {
				vo.setKennleName(kennel.getName());
				vo.setKennelEnName(StringUtils.isNotBlank(kennel.getNameEn()) ? kennel.getNameEn().split("'")[0] : "");
				vo.setPaperKennelEnName(kennel.getNameEn());
			} else {
				vo.setKennleName("");
				vo.setKennelEnName("");
				vo.setPaperKennelEnName("");
			}
		}

		// 5、犬只颜色
		DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dog0.getColorFlag());
		if (dogColorMark != null) {
			String colorMarkCn = dogColorMark.getDogColorMarkCn();
			String[] color = colorMarkCn.split("-");
			// vo.setColor(dogColorMark.getDogColorMarkCode());
			// vo.setColorDesc(color[1]);
			vo.setColor(color[1]);
			vo.setColorDesc(dogColorMark.getDogColorMarkCode());
		}
		// 犬只补充信息
		vo.setBusinessBan(dog0.getBusinessBan());
		vo.setCallName(dog0.getCallName()); // 呼名
		vo.setCreateDate(dog0.getPrintTime() != null ? sdf1.format(dog0.getPrintTime()) : null);
		if (vo.getCreateDate() == null) {
			vo.setCreateDate(dog0.getUpdateDate() != null ? sdf1.format(dog0.getUpdateDate()) : null);
		}
		vo.setDogBirthday(dog0.getBirthdate() != null ? sdf2.format(dog0.getBirthdate()) : null);
		vo.setDogGender("1".equals(dog0.getGender()) ? "公" : "母");
		vo.setDogGenderDesc("1".equals(dog0.getGender()) ? "Male" : "Female");
		if (dog0.getNameEn() != null && vo.getKennelEnName() != null)
			vo.setDogName(dog0.getNameEn().replace(vo.getKennelEnName(), ""));
		else
			vo.setDogName(dog0.getNameEn());

		vo.setPaperDogName(StringUtils.isNotBlank(dog0.getNameEn()) ? dog0.getNameEn().toUpperCase() : "");
		vo.setDogMemberName(dog0.getDogOwner());
		vo.setDogMemberNameEn(convertMemberName(memberService.getByMemberCode(dog0.getMemberCode()).getNameEn()));
		vo.setPedigreeCertifiedEn(dog0.getPedigreeCertifiedEn());
		vo.setIdentification(dog0.getIdentificationFlag());
		vo.setPedigreeCertified(dog0.getPedigreeCertifiedCode());
		vo.setTestGrade(dog0.getTestGrade());
		DogSticker dogSticker = dogStickerService.getDogStickerByIdentificationFlagByOne(dog0.getIdentificationFlag());
		vo.setDogGrade(dogStickerService.getSticker(dogSticker));
		if (StringUtils.isNotBlank(dog0.getBreederMemberCode())) {
			Kennel kennel = kennelService.getKennelByMemberCode(dog0.getBreederMemberCode());
			if (kennel != null) {
				vo.setKennleName(kennel.getName());
				vo.setKennelEnName(StringUtils.isNotBlank(kennel.getNameEn()) ? kennel.getNameEn().split("'")[0] : "");
				vo.setPaperKennelEnName(kennel.getNameEn());
			} else {
				vo.setKennleName("");
				vo.setKennelEnName("");
				vo.setPaperKennelEnName("");
			}
		}
		vo.setSecondDogOwner(dog0.getSecondDogOwner());
		vo.setSecondOwnerMemberNum(dog0.getSecondOwnerMemberNum());
		
		// 6、三代血统关系 14只狗
		Dog dog1 = null;
		if (StringUtils.isNotBlank(dog0.getFdogPedigreeCertified())) {
			dog1 = dogService.getByPedigreeCertifiedCode(dog0.getFdogPedigreeCertified().trim());// 父
		}
		Dog dog2 = null;
		if (StringUtils.isNotBlank(dog0.getFdogPedigreeCertified())) {
			dog2 = dogService.getByPedigreeCertifiedCode(dog0.getMdogPedigreeCertified().trim());// 母
		}
		build12Dog(vo, dog1, dog2);

		// 7、证书类型
		buildCertificateType(dog0, dog1, dog2, vo);
		if("country".equals(dogType.getBreedClass())) {
			vo.setCertificateType("COUNTRY");//证书类型为国家级证书
		}
		
		// 8、出口标识
		if("formal".equals(dogType.getBreedClass())) {
		//  breedClass;	FCI正式品种:formal、FCI临时认可品种:temp、FCI国家级认可品种:country、FCI不认可品种:unauth
			vo.setChangeBan(dog0.getChangeBan());
		}
		// 是否为新款证书
		if("15C".equals(dog0.getDogBreed())){
			if(dog0.getPrintTime()!=null && !dog0.getPrintTime().after(sdf3.parse("2022.8.2"))){
				vo.setIsNewMCCertificate("1");
			}else {
				vo.setIsNewMCCertificate("0");//是否为新款证书，0是，1否
			}
		}
		
		return new RESTResponse("data", vo);
	}

	private String convertMemberName(String name) {
		if (StringUtils.isBlank(name)) {
			return "";
		}
		String[] names = name.split(" ");
		if (names.length > 1) {
			return names[1] + " " + names[0];
		}
		return name;
	}

	public void buildtPuppyBirthInfo(ViewCertificateVo vo, Dog dog0) {
		DogNewborn dogNewborn = dogNewbornDao.getByBreedCertifiedCode(dog0.getFmdogBreedCertifiedCode());
		if (dogNewborn != null) {
			vo.setPuppyBirthNum(dogNewborn.getPuppyBirthNum().replace(" ", "").replace("公", ",").replace("母", ""));
			vo.setPuppyRegisterNum(
					dogNewborn.getPuppyRegisterNum().replace(" ", "").replace("公", ",").replace("母", ""));
		} else {
			// 如果国内配种证明表找不到，去国外配种证明表找
			DogAmphimixisProve dogAmphimixisProve = dogAmphimixisProveService.getMsg(dog0.getFmdogBreedCertifiedCode());
			if (dogAmphimixisProve != null) {
				vo.setPuppyBirthNum(dogAmphimixisProve.getNumberBirths());
				vo.setPuppyRegisterNum(dogAmphimixisProve.getNumberRegisteredDogs());
				vo.setBreeder(dogAmphimixisProve.getBreeder());
			}
		}
	}

	// 查三代12只狗
	public void build12Dog(ViewCertificateVo vo, Dog dog1, Dog dog2) {
		if (dog1 != null) {
			vo.setDog1(dogService.convertDogVo(dog1));
			Dog dog3 = dogService.getByPedigreeCertifiedCode(
					dog1.getFdogPedigreeCertified() == null ? null : dog1.getFdogPedigreeCertified().trim());// 祖父
			if (dog3 != null) {
				vo.setDog3(dogService.convertDogVo(dog3));
				Dog dog7 = dogService.getByPedigreeCertifiedCode(
						dog3.getFdogPedigreeCertified() == null ? null : dog3.getFdogPedigreeCertified().trim());// 曾祖父
				if (dog7 != null)
					vo.setDog7(dogService.convertDogVo(dog7));
				Dog dog8 = dogService.getByPedigreeCertifiedCode(
						dog3.getMdogPedigreeCertified() == null ? null : dog3.getMdogPedigreeCertified().trim());// 曾祖母
				if (dog8 != null)
					vo.setDog8(dogService.convertDogVo(dog8));
			}
			Dog dog4 = dogService.getByPedigreeCertifiedCode(
					dog1.getMdogPedigreeCertified() == null ? null : dog1.getMdogPedigreeCertified().trim());
			if (dog4 != null) {
				vo.setDog4(dogService.convertDogVo(dog4));
				Dog dog9 = dogService.getByPedigreeCertifiedCode(
						dog4.getFdogPedigreeCertified() == null ? null : dog4.getFdogPedigreeCertified().trim());
				if (dog9 != null)
					vo.setDog9(dogService.convertDogVo(dog9));
				Dog dog10 = dogService.getByPedigreeCertifiedCode(
						dog4.getMdogPedigreeCertified() == null ? null : dog4.getMdogPedigreeCertified().trim());
				if (dog10 != null)
					vo.setDog10(dogService.convertDogVo(dog10));
			}
		}
		if (dog2 != null) {
			vo.setDog2(dogService.convertDogVo(dog2));
			Dog dog5 = dogService.getByPedigreeCertifiedCode(
					dog2.getFdogPedigreeCertified() == null ? null : dog2.getFdogPedigreeCertified().trim());
			if (dog5 != null) {
				vo.setDog5(dogService.convertDogVo(dog5));
				Dog dog11 = dogService.getByPedigreeCertifiedCode(
						dog5.getFdogPedigreeCertified() == null ? null : dog5.getFdogPedigreeCertified().trim());
				if (dog11 != null)
					vo.setDog11(dogService.convertDogVo(dog11));
				Dog dog12 = dogService.getByPedigreeCertifiedCode(
						dog5.getMdogPedigreeCertified() == null ? null : dog5.getMdogPedigreeCertified().trim());
				if (dog12 != null)
					vo.setDog12(dogService.convertDogVo(dog12));
			}
			Dog dog6 = dogService.getByPedigreeCertifiedCode(
					dog2.getMdogPedigreeCertified() == null ? null : dog2.getMdogPedigreeCertified().trim());
			if (dog6 != null) {
				vo.setDog6(dogService.convertDogVo(dog6));
				Dog dog13 = dogService.getByPedigreeCertifiedCode(
						dog6.getFdogPedigreeCertified() == null ? null : dog6.getFdogPedigreeCertified().trim());
				if (dog13 != null)
					vo.setDog13(dogService.convertDogVo(dog13));
				Dog dog14 = dogService.getByPedigreeCertifiedCode(
						dog6.getMdogPedigreeCertified() == null ? null : dog6.getMdogPedigreeCertified().trim());
				if (dog14 != null)
					vo.setDog14(dogService.convertDogVo(dog14));
			}
		}
	}

	// 查证书类型
	public String buildCertificateType(Dog dog0, Dog dog1, Dog dog2, ViewCertificateVo vo) {
		String type = null;
		// 判断父母是否都为优生繁育 父母是否获得繁育证书标记位
		boolean isDogBreedCertified = false;
		if (dog1 != null && dog2 != null) {
			DogBreedCertified dogBreedCertified1 = dogBreedCertifiedService.getByDogId(dog1.getId());
			DogBreedCertified dogBreedCertified2 = dogBreedCertifiedService.getByDogId(dog2.getId());
			if (dogBreedCertified1 != null && "1".equals(dogBreedCertified1.getReviewState())
					&& dogBreedCertified2 != null && "1".equals(dogBreedCertified2.getReviewState())) {
				isDogBreedCertified = true;
			}
		}

		DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByPedigreeCertifiedCode(dog0.getPedigreeCertifiedCode());
		if (dogDnaArchive != null) {
			vo.setDnaCode(dogDnaArchive.getDnaCode());
		}
		// 位点分析是否通过标记位
		boolean isDogDnaArchive = dogDnaService.isHaveDogDna(dog0.getId());
		DogDna dogDna = dogDnaService.getByDogId(dog0.getId());
		if (Objects.nonNull(dogDna) && !StringUtils.isBlank(dogDna.getDnaResult())) {
			vo.setGeneCode(dogDnaService.convertGeneCodeByDNAResult(dogDna.getDnaResult()));
		}
		// 双亲比对是否通过标记位
		boolean isDnaParentsCompare = false;
		DogDnaParentsCompare dogDnaParentsCompare = dogDnaParentsCompareService.getByBirthCode(dog0.getBirthCertificateLevelCode());
		// 办理了双亲比对业务，审核状态不为通过不允许打印
		if (dogDnaParentsCompare != null) {
			if ("1".equals(dogDnaParentsCompare.getReviewState())) {
				isDnaParentsCompare = true;
			} else if (!"1".equals(dogDnaParentsCompare.getReviewState())
					&& !GoldCertifiedStateEnum.DOWNGRADE.code().equals(dog0.getGoldCertifiedState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只办理了双亲比对业务，需双亲比对审核通过后，方可查看电子证书");
			}
		}

		// 分析证书类型
		DogAppraisal dogAppraisal = dogAppraisalDao.getByPedigreeCertified(dog0.getPedigreeCertifiedCode());// 分析鉴定证书
		if (dogAppraisal != null) {
			vo.setIdentifySite(dogAppraisal.getIdentifySite());
			vo.setIdentifyDate(sdf2.format(dogAppraisal.getIdentifyDate()));
			vo.setIdentifier(dogAppraisal.getIdentifier());
		}
		Date createDate = null;
		try {
			createDate = sdf1.parse(vo.getCreateDate());
		} catch (ParseException e) {
			throw new RuntimeException(e);
		}
		if ("230".equals(dog0.getDogBreed())) {
			// 《纯种西藏獒犬血统证书》《纯种西藏獒犬鉴定证书》
//			type = dogAppraisal == null ? "ZA_XT" : "ZA_JD";
			if(dogAppraisal == null) {
				type = "XT";
			}else {
				if(Objects.isNull(dogAppraisal.getCreateDate()) 
						|| dogAppraisal.getCreateDate().before( com.cku.util.DateUtils.strToDate("2025-01-01"))) {
					type = "ZA_JD";
				}else {
					type = "JD";
				}
			}
		} else if (dog0.getPrintState() != null && dog0.getPrintState().endsWith("1")) {
			if (GoldCertifiedStateEnum.DOWNGRADE.code().equals(dog0.getGoldCertifiedState())) {
				// 《DNA纯种犬证书》
				type = "DNA_APPRAISAL";
			} else {
				// 《纯种犬鉴定证书》
				type = "JD";
			}
		} else if (isDogDnaArchive && isDnaParentsCompare && isDogBreedCertified) {
			// 《DNA优生繁育纯血犬血统证书》完成血样留存、位点分析、双亲比对通过、父母犬获得繁育证书
			type = "DNA_YSFY_XT";
		} else if (isDogDnaArchive && isDnaParentsCompare) {
			// 《DNA纯血犬血统证书》完成血样留存、位点分析、双亲比对通过
			type = "DNA_XT";
		} else if ("292".equals(dog0.getDogBreed())
				&& dcPrintTypeStartTime.compareTo(createDate) > 0) {
			// 《纯血犬血统证书》杜高
			type = "DG";
		} else if ("15C".equals(dog0.getDogBreed())) {
			// 《纯血犬血统证书》玛犬
			type = "MQ";
		}else {
			// 《纯血犬血统证书》
			type = "XT";
		}
		vo.setCertificateType(type);
		return type;

	}
	
	@Transactional(readOnly = false)
	public RESTResponse getDogFamilyByPedigreeCertifiedCode(String pedigreeCertifiedCode,String token) throws Exception {
		
		Dog dog0 = dogService.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
		if (dog0 == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		}
		
		return getDogFamilyByDog(dog0,token);
		
	}
	
	@Transactional(readOnly = false)
	public RESTResponse getDogFamily(HttpServletRequest request) throws Exception {
		String id = request.getParameter("id");
		Dog dog0 = dogService.get(id);
		if (dog0 == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		}
		return getDogFamilyByDog(dog0,request.getParameter("token"));
	}

	@Transactional(readOnly = false)
	private RESTResponse getDogFamilyByDog(Dog dog0,String token) throws Exception {
		// 返回对象
		MyDogPedigreeVo vo = new MyDogPedigreeVo();
		//如果为金质证书降级则不显示祖辈信息
		if (GoldCertifiedStateEnum.DOWNGRADE.code().equals(dog0.getGoldCertifiedState())) {
			return new RESTResponse("data", vo);
		}
		// 三代血统关系 14只狗
		Dog dog1 = null;
		if (StringUtils.isNotBlank(dog0.getFdogPedigreeCertified())) {
			dog1 = dogService.getByPedigreeCertifiedCode(dog0.getFdogPedigreeCertified().trim());// 父
		}
		Dog dog2 = null;
		if (StringUtils.isNotBlank(dog0.getFdogPedigreeCertified())) {
			dog2 = dogService.getByPedigreeCertifiedCode(dog0.getMdogPedigreeCertified().trim());// 母
		}
		ViewCertificateVo vo1 = new ViewCertificateVo();
		build12Dog(vo1, dog1, dog2);
		vo.setDog1(vo1.getDog1());
		vo.setDog2(vo1.getDog2());
		vo.setDog3(vo1.getDog3());
		vo.setDog4(vo1.getDog4());
		vo.setDog5(vo1.getDog5());
		vo.setDog6(vo1.getDog6());
		vo.setDog7(vo1.getDog7());
		vo.setDog8(vo1.getDog8());
		vo.setDog9(vo1.getDog9());
		vo.setDog10(vo1.getDog10());
		vo.setDog11(vo1.getDog11());
		vo.setDog12(vo1.getDog12());
		vo.setDog13(vo1.getDog13());
		vo.setDog14(vo1.getDog14());

		// 添加近亲查询
		if (vo.getDog1() != null && vo.getDog2() != null && StringUtils.isNotBlank(vo.getDog1().getPedigreeCertified())
				&& StringUtils.isNotBlank(vo.getDog2().getPedigreeCertified())) {
			bloodlineApp(vo.getDog1().getPedigreeCertified(), vo.getDog2().getPedigreeCertified(), vo);
		}
		if (isDesensitize(dog0.getMemberCode(), token)) {
			desensitize(vo.getDog1());
			desensitize(vo.getDog2());
			desensitize(vo.getDog3());
			desensitize(vo.getDog4());
			desensitize(vo.getDog5());
			desensitize(vo.getDog6());
			desensitize(vo.getDog7());
			desensitize(vo.getDog8());
			desensitize(vo.getDog9());
			desensitize(vo.getDog10());
			desensitize(vo.getDog11());
			desensitize(vo.getDog12());
			desensitize(vo.getDog13());
			desensitize(vo.getDog14());
		}
		return new RESTResponse("data", vo);
	}

	private void desensitize(ViewDogVo dog) {
		dog.setPedigreeCertified(DesensitizeUtils.desensitize(dog.getPedigreeCertified(),
				DesensitizeUtils.TEXT_TYPE_PEDIGREECERTIFIEDCODE));
	}

	public void bloodlineApp(String fatherPedigreeCertified, String motherPedigreeCertified, MyDogPedigreeVo vo) {
		JSONObject jo = bloodlineNew(vo.getDog1().getPedigreeCertified(), vo.getDog2().getPedigreeCertified());
		JSONArray infos = jo.getJSONArray("infos");
		Map<String, String> map = new HashMap<>();
		for (int i = 0; i < infos.size(); i++) {
			JSONObject j = (JSONObject) infos.get(i);
			String value = (String) j.get("value");
			String closeRelative = value.split("\\(")[1].split("\\)")[0];
			//不显示2-3/3-2和3-3
			if ("2-3".equals(closeRelative)
					|| "3-2".equals(closeRelative)
					|| "3-3".equals(closeRelative)) {
				continue;
			}
			map.put(value.split("\\(")[0], closeRelative);
		}
		if (vo.getDog1() != null)
			vo.getDog1().setBloodline(
					"3-3".equals(map.get(vo.getDog1().getNameEn())) ? null : map.get(vo.getDog1().getNameEn()));
		if (vo.getDog2() != null)
			vo.getDog2().setBloodline(
					"3-3".equals(map.get(vo.getDog2().getNameEn())) ? null : map.get(vo.getDog2().getNameEn()));
		if (vo.getDog3() != null)
			vo.getDog3().setBloodline(
					"3-3".equals(map.get(vo.getDog3().getNameEn())) ? null : map.get(vo.getDog3().getNameEn()));
		if (vo.getDog4() != null)
			vo.getDog4().setBloodline(
					"3-3".equals(map.get(vo.getDog4().getNameEn())) ? null : map.get(vo.getDog4().getNameEn()));
		if (vo.getDog5() != null)
			vo.getDog5().setBloodline(
					"3-3".equals(map.get(vo.getDog5().getNameEn())) ? null : map.get(vo.getDog5().getNameEn()));
		if (vo.getDog6() != null)
			vo.getDog6().setBloodline(
					"3-3".equals(map.get(vo.getDog6().getNameEn())) ? null : map.get(vo.getDog6().getNameEn()));
		if (vo.getDog7() != null)
			vo.getDog7().setBloodline(
					"3-3".equals(map.get(vo.getDog7().getNameEn())) ? null : map.get(vo.getDog7().getNameEn()));
		if (vo.getDog8() != null)
			vo.getDog8().setBloodline(
					"3-3".equals(map.get(vo.getDog8().getNameEn())) ? null : map.get(vo.getDog8().getNameEn()));
		if (vo.getDog9() != null)
			vo.getDog9().setBloodline(
					"3-3".equals(map.get(vo.getDog9().getNameEn())) ? null : map.get(vo.getDog9().getNameEn()));
		if (vo.getDog10() != null)
			vo.getDog10().setBloodline(
					"3-3".equals(map.get(vo.getDog10().getNameEn())) ? null : map.get(vo.getDog10().getNameEn()));
		if (vo.getDog11() != null)
			vo.getDog11().setBloodline(
					"3-3".equals(map.get(vo.getDog11().getNameEn())) ? null : map.get(vo.getDog11().getNameEn()));
		if (vo.getDog12() != null)
			vo.getDog12().setBloodline(
					"3-3".equals(map.get(vo.getDog12().getNameEn())) ? null : map.get(vo.getDog12().getNameEn()));
		if (vo.getDog13() != null)
			vo.getDog13().setBloodline(
					"3-3".equals(map.get(vo.getDog13().getNameEn())) ? null : map.get(vo.getDog13().getNameEn()));
		if (vo.getDog14() != null)
			vo.getDog14().setBloodline(
					"3-3".equals(map.get(vo.getDog14().getNameEn())) ? null : map.get(vo.getDog14().getNameEn()));
	}

	@Transactional(readOnly = false)
	public RESTResponse getCompatriots(HttpServletRequest request) throws Exception {
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String id = request.getParameter("id");
		Dog dog0 = dogService.get(id);

		if (dog0 == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		}
		List<RestDog> list = new ArrayList<>();
		//如果为金质证书降级则不显示祖辈信息
		if (GoldCertifiedStateEnum.DOWNGRADE.code().equals(dog0.getGoldCertifiedState())) {
			return new RESTResponse("data", new PageBeanResult<>(list, 0L));
		}
		if (StringUtils.isBlank(dog0.getFmdogBreedCertifiedCode())) {
			return new RESTResponse("list", new PageBeanResult<>(list, 0L));
		}
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 5;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		// 设置分页参数
		Page<Dog> page = new Page<Dog>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		page.setOrderBy("birth_certificate_level_code ,gender");
		Dog dog1 = new Dog();
		dog1.setFmdogBreedCertifiedCode(dog0.getFmdogBreedCertifiedCode());
		// 查询数据集
		Page<Dog> pageResult = dogService.findPage(page, dog1);
		// 组装返回对象
		List<Dog> dogList = pageResult.getList();
		long count = page.getCount();
		for (Dog dog : dogList) {
			if (!dog.getId().equals(dog0.getId())) {
				RestDog vo = new RestDog();
				BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
				if (StringUtils.isNotBlank(dog.getDogBreed())) {
					DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
					if (dogType != null) {
						vo.setDogBreedName(dogType.getBreedCnName());
					}
				}
				if ("1".equals(dog.getPictureReviewState())) {// 审核状态 0待审核、1已通过、2未通过
					vo.setPicture(dog.getPicture());
				} else {
					vo.setPicture(null);
				}
				if (isDesensitize(dog.getMemberCode(), request.getParameter("token"))) {
					desensitize(vo);
				}
				list.add(vo);
			} else {
				count--;
			}
		}

		return new RESTResponse("list", new PageBeanResult<RestDog>(list, count));
	}

	@Transactional(readOnly = false)
	public RESTResponse getChildren(HttpServletRequest request) throws Exception {
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String id = request.getParameter("id");
		Dog dog0 = dogService.get(id);
		if (dog0 == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		}
		//如果繁殖人不是自己不显示后代犬
		Member member = UserUtils.getLoginMember();
		if (Objects.isNull(member) || StringUtils.isBlank(member.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请登录后查看");
		}
		if (!member.getMemberCode().equals(dog0.getBreederMemberCode()) && !member.getMemberCode().equals(dog0.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "仅限繁殖人或犬主查看");
		}

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 5;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		// 设置分页参数
		Page<Dog> page = new Page<Dog>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		page.setOrderBy("birthdate desc,birth_certificate_level_code ,gender");

		Dog dog1 = new Dog();
		if ("1".equals(dog0.getGender())) {
			dog1.setFdogPedigreeCertified(dog0.getPedigreeCertifiedCode());
		} else {
			dog1.setMdogPedigreeCertified(dog0.getPedigreeCertifiedCode());
		}
		// 查询数据集
		Page<Dog> pageResult = dogService.findPage(page, dog1);
		// 组装返回对象
		List<Dog> dogList = pageResult.getList();
		List<RestDog> list = new ArrayList<RestDog>();
		for (Dog dog : dogList) {
			RestDog vo = new RestDog();
			BeanUtil.copyProperties(vo, dog, "yyyy-MM-dd");
			if (StringUtils.isNotBlank(dog.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
				if (dogType != null) {
					vo.setDogBreedName(dogType.getBreedCnName());
				}
			}
			if ("1".equals(dog.getPictureReviewState())) {
				vo.setPicture(dog.getPicture());
			} else {
				vo.setPicture(null);
			}
			if (isDesensitize(dog.getMemberCode(), request.getParameter("token"))) {
				desensitize(vo);
			}
			list.add(vo);
		}
		long count = page.getCount();
		return new RESTResponse("list", new PageBeanResult<RestDog>(list, count));
	}

	@Transactional(readOnly = false)
	public RESTResponse getShowResults(HttpServletRequest request) throws Exception {
		String id = request.getParameter("id");
		String charTime = request.getParameter("charTime");
		String type = request.getParameter("type");// 1:CKU单独展赛事成绩；2： CKU全犬种赛事成绩；3： CKU犬主人组赛事成绩
		if (StringUtils.isBlank(charTime))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询时间必传！");
		if (StringUtils.isBlank(type))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询类型必传！");
		Dog dog0 = dogService.get(id);
		if (dog0 == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		List<ShowResultsDdzVO> result = new ArrayList<>();
		if ("1".equals(type)) {// 1:CKU单独展赛事成绩；
			List<ShowResultsDdz> list = showResultsDdzDao.getDogGradeDdzList(dog0.getPedigreeCertifiedCode(), charTime);
			for (ShowResultsDdz showResultsDdz : list) {
				ShowResultsDdzVO vo = new ShowResultsDdzVO();
				BeanUtil.copyProperties(vo, showResultsDdz, "yyyy-MM-dd");
				StringBuilder resultStr = new StringBuilder();
				if (StringUtils.isNotBlank(showResultsDdz.getResultCc()))
					resultStr.append(showResultsDdz.getResultCc()).append(
							StringUtils.isNotBlank(showResultsDdz.getRemarksCc()) ? showResultsDdz.getRemarksCc() : "")
							.append("/");
				if (StringUtils.isNotBlank(showResultsDdz.getResultBow()))
					resultStr.append(showResultsDdz.getResultBow()).append("/");
				if (StringUtils.isNotBlank(showResultsDdz.getResultBiss()))
					resultStr.append(showResultsDdz.getResultBiss()).append("/");
				if (StringUtils.isNotBlank(showResultsDdz.getResultBob()))
					resultStr.append(showResultsDdz.getResultBob()).append("/");
				if (StringUtils.isNotBlank(showResultsDdz.getResultWb()))
					resultStr.append(showResultsDdz.getResultWb()).append("/");
				if (StringUtils.isNotBlank(resultStr.toString()))
					vo.setResult(resultStr.toString().substring(0, resultStr.toString().length() - 1));
				result.add(vo);
			}
		} else if ("2".equals(type)) {// 2： CKU全犬种赛事成绩；
			List<ShowResults> list = showResultsDao.getDogGradeList(dog0.getPedigreeCertifiedCode(), charTime);
			for (ShowResults showResults : list) {
				ShowResultsDdzVO vo = new ShowResultsDdzVO();
				//备注成绩取消则不显示
				if (StringUtils.isNotBlank(showResults.getRemarksCc())
						&& showResults.getRemarksCc().startsWith("成绩取消")) {
					continue;
				}
				BeanUtil.copyProperties(vo, showResults, "yyyy-MM-dd");
				StringBuilder resultStr = new StringBuilder();
				if (StringUtils.isNotBlank(showResults.getResultCc()))
					resultStr.append(showResults.getResultCc()).append(
							StringUtils.isNotBlank(showResults.getRemarksCc()) ? showResults.getRemarksCc() : "")
							.append("/");
				if (StringUtils.isNotBlank(showResults.getResultCacib()))
					resultStr.append(showResults.getResultCacib()).append("/");
				if (StringUtils.isNotBlank(showResults.getResultBow()))
					resultStr.append(showResults.getResultBow()).append("/");
				if (StringUtils.isNotBlank(showResults.getResultBoj()))
					resultStr.append(showResults.getResultBoj()).append("/");
				if (StringUtils.isNotBlank(showResults.getResultBob()))
					resultStr.append(showResults.getResultBob()).append("/");
				if (StringUtils.isNotBlank(showResults.getResultJbig()))
					resultStr.append(showResults.getResultJbig()).append("/");
				if (StringUtils.isNotBlank(showResults.getResultBig()))
					resultStr.append(showResults.getResultBig()).append("/");
				if (StringUtils.isNotBlank(showResults.getResultJbis()))
					resultStr.append(showResults.getResultJbis()).append("/");
				if (StringUtils.isNotBlank(showResults.getResultBis()))
					resultStr.append(showResults.getResultBis()).append("/");
				if (StringUtils.isNotBlank(resultStr.toString()))
					vo.setResult(resultStr.toString().substring(0, resultStr.toString().length() - 1));
				result.add(vo);
			}
		} else if ("3".equals(type)) {// 3： CKU犬主人组赛事成绩
			List<ShowResults> list = showResultsDao.getDogGradeListIsOwner(dog0.getPedigreeCertifiedCode(), charTime);
			for (ShowResults showResults : list) {
				ShowResultsDdzVO vo = new ShowResultsDdzVO();
				BeanUtil.copyProperties(vo, showResults, "yyyy-MM-dd");
				vo.setResult(showResults.getResultOhc());
				result.add(vo);
			}
		}

		return new RESTResponse("list", result);
	}

	@Transactional(readOnly = false)
	public RESTResponse updatePicture(String json) throws Exception {
		JSONObject jo = JSONObject.fromObject(json);
		if (jo.get("id") == null || jo.get("picture") == null || StringUtils.isBlank(jo.getString("id"))
				|| StringUtils.isBlank(jo.getString("picture")))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id、picture必传！");
		String id = jo.getString("id");
		String picture = jo.getString("picture");
		Dog dog0 = dogService.get(id);
		if (dog0 == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		// 0待审核、1已通过、2未通过
		if ("1".equals(dog0.getPictureReviewState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已通过图片不能修改");
		}
		dog0.setPicture(picture);
		dog0.setPictureReviewState("0");
		dog0.preUpdate();
		dogService.save(dog0);
		return new RESTResponse("data", true);
	}

	@Transactional(readOnly = false)
	public RESTResponse getInfo(HttpServletRequest request) throws Exception {
		String id = request.getParameter("id");
		String key = request.getParameter("key");
		if (StringUtils.isBlank(id) && StringUtils.isBlank(key))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "查询id或者key必传其一！");
		Dog dog0 = null;
		if (StringUtils.isNotBlank(id)) {
			dog0 = dogService.get(id);
			if (dog0 == null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		} else {
			dog0 = dogService.getByPedigreeCertifiedCodeOrIdentificationFlag(key);
			if (dog0 == null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只没有查到");
		}

		RestDog dog = new RestDog();
		BeanUtils.copyProperties(dog, dog0);
		Member qz = memberDao.getByMemberCode(dog0.getMemberCode());// 犬主人
		Member Breeder = memberDao.getByMemberCode(dog0.getBreederMemberCode());// 繁殖人
		dog.setBreederAvatar(Breeder != null && Breeder.getUser() != null ? Breeder.getUser().getPhoto() : null);
		dog.setDogOwnerAvatar(qz != null && qz.getUser() != null ? qz.getUser().getPhoto() : null);
		dog.setBirthdate(dog0.getBirthdate() == null ? null : sdf3.format(dog0.getBirthdate()));

		if (StringUtils.isNotBlank(dog.getColorFlag())) {
			DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dog.getColorFlag());
			if (dogColorMark != null) {
				dog.setColorFlagCn(dogColorMark.getDogColorMarkCn());
			}
		}

		if (StringUtils.isNotBlank(dog0.getDogBreed())) {
			DogType dogType = dogTypeService.getByDogBreedCode(dog0.getDogBreed());
			if (dogType != null) {
				dog.setDogBreedName(dogType.getBreedCnName());
				dog.setDogBreedNameEn(dogType.getBreedEnName());
			} else {
				dog.setDogBreedName(dogTypeService.getUnMapBreedCnName(dog0.getDogBreed()));
				dog.setDogBreedNameEn("");
			}
		}

		dog.setDogClass(this.getDogClass(dog.getIdentificationFlag()));
		dog.setDogClassName(this.getDogClassName(dog.getDogClass()));

		if (isDesensitize(dog.getMemberCode(), request.getParameter("token"))) {
			desensitize(dog);
		}
		//gene报告是否可以查看
		//默认不可查看
		dog.setGeneFlag("0");
		DogDnaArchive dogDnaArchive = dogDnaArchiveService.getByDogId(dog0.getId());
		if (Objects.nonNull(dogDnaArchive) && StringUtils.isNotBlank(dogDnaArchive.getDnaCode())) {
			if (StringUtils.isNotBlank(request.getParameter("token"))) {
				Member member = UserUtils.getLoginMember();
				if (Objects.equals(member.getMemberCode(), dog0.getMemberCode())) {
					dog.setGeneFlag("1");
				}
			}
		}
		return new RESTResponse("data", dog);
	}

	private boolean isDesensitize(String dogOwnerMemberCode, String token) {
		boolean hide = true;// 是否对重点信息进行隐藏
		if (StringUtils.isNotBlank(token)) {
			Member member = UserUtils.getLoginMember();
			if (Objects.equals(member.getMemberCode(), dogOwnerMemberCode)) {
				hide = false;
			}
		}
		return hide;
	}

	private void desensitize(RestDog dog) {
		dog.setPedigreeCertifiedCode(DesensitizeUtils.desensitize(dog.getPedigreeCertifiedCode(),
				DesensitizeUtils.TEXT_TYPE_PEDIGREECERTIFIEDCODE));
		dog.setIdentificationFlag(DesensitizeUtils.desensitize(dog.getIdentificationFlag(),
				DesensitizeUtils.TEXT_TYPE_IDENTIFICATIONFLAG));
	}

	public String getDogClass(String identificationFlag) {
		/**
		 * add by zhangjuwnu 查询犬只等级 1、从等级贴纸申请表（dog_sticker_apply）查询，按芯片号或血统证书号查询
		 * 如等级贴纸申请中存在，则取已申请等级中最高的等级，如不存在则进行第2部 2、从新生犬登记卡表（dog_birth_certificate）中查询
		 * 如存在则为E级，如不存在，则执行第3步，从宠爱护照系统查询 3、从宠爱护照系统查询 如存在则为伴侣级 如以上都不存在，则无等级 1 纯种级(E)，2
		 * 纯血级(P)， 3 赛级(S) ，4 冠军级(SS)
		 */

		if (StringUtils.isBlank(identificationFlag)) {
			return null;
		}
		String dogClass = null;
		try {
			String applyClass = dogStickerApplyService.getApplyClassByIdentificationFlag(identificationFlag);
			if (StringUtils.isNotBlank(applyClass)) {
				List<String> applyClassList = Arrays.asList(applyClass.split(","));
				applyClassList = applyClassList.stream().filter(content -> StringUtils.isNotBlank(content))
						.collect(Collectors.toList());
				Collections.reverse(applyClassList);
				dogClass = applyClassList.get(0);
			} else {
				DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
						.getByIdentificationFlag(identificationFlag);
				if (!Objects.isNull(dogBirthCertificate)) {
					dogClass = "1";
				} else {
					HttpResult hr = HttpClientUtil.get(null,
							cabPassportServiceUrl + "/tcbPetOrder/validate/" + identificationFlag, null);
					if (hr.getResultCode() == 200) {
						JSONObject jo = JSONObject.fromObject(hr.getResponseBody());
						Object data = jo.get("data");
						if (!Objects.isNull(data) && Boolean.valueOf(data.toString())) {
							dogClass = "0";
						}
					}
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		return dogClass;
	}

	public String getDogClassName(String dogClass) {
		String dogClassName = null;
		if (StringUtils.isNotBlank(dogClass)) {
			if ("0".equals(dogClass)) {
				dogClassName = "伴侣级(C)";
			} else {
				dogClassName = DictUtils.getDictLabel(dogClass, "sticker_class", null);
			}
		}
		return dogClassName;
	}

	/**
	 * 根据犬只ID查询基因报告
	 *
	 * @author yuanshuai
	 * @date 2023/8/3 13:47
	 */
	public DogGeneReportResponse findGeneReportById(String id) {
		if (StringUtils.isBlank(id)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只ID为空");
		}
		Dog dog = dogService.get(id);
		if (Objects.isNull(dog)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只信息为空");
		}
		DogDnaArchive dnaArchive = dogDnaArchiveService.getByDogId(dog.getId());
		if (Objects.isNull(dnaArchive) || StringUtils.isBlank(dnaArchive.getDnaCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只DNA信息为空");
		}
		Member member = UserUtils.getLoginMember();
		if (!Objects.equals(member.getMemberCode(), dog.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有犬主人可以查看基因报告");
		}
		DogDna dogDna = dogDnaService.getByDogId(dog.getId());
		DogDnaParentsCompare dnaParentsCompare = dogDnaParentsCompareService.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
		if (Objects.isNull(dnaParentsCompare)) {
			dnaParentsCompare = dogDnaParentsCompareService.getByBirthCode(dog.getBirthCertificateLevelCode());
		}
		//构建返回值
		DogGeneReportResponse resp = DogGeneReportResponse.builder().build();
		BeanUtil.copyProperties(resp, dog, "yyyy-MM-dd");
		resp.setSamplingCode(dnaArchive.getSamplingCode());
		resp.setDnaCode(dnaArchive.getDnaCode());
		resp.setGeneCode(dogDnaService.convertGeneCodeByDNAResult(dogDna.getDnaResult()));
		//处理亲子比对
		if (Objects.nonNull(dnaParentsCompare) && "1".equals(dnaParentsCompare.getReviewState())) {
			resp.setParenthoodType(ParenthoodTypeEnum.BOTH_CONFIRMED);
		} else if (Objects.nonNull(dnaParentsCompare) && "2".equals(dnaParentsCompare.getReviewState())) {
			resp.setParenthoodType(ParenthoodTypeEnum.FAILED);
		} else {
			resp.setParenthoodType(ParenthoodTypeEnum.UNCONFIRMED);
		}
		//处理遗传疾病数据
		if (StringUtils.isNotBlank(resp.getSamplingCode())) {
			List<String> samplingCodeList = Lists.newArrayList();
			samplingCodeList.add(resp.getSamplingCode());
			List<SamplingGeneticDiseaseResponse> geneticDiseaseRespList = GeneTreeReportUtils.findGeneticDiseaseBySamplingCodeList(samplingCodeList);
			if (!CollectionUtils.isEmpty(geneticDiseaseRespList)) {
				SamplingGeneticDiseaseResponse geneticDiseaseResp = geneticDiseaseRespList.get(0);
				if (StringUtils.isNotBlank(geneticDiseaseResp.getGeneticDiseaseJson())) {
					Map<String, Class<?>> classMap = new HashMap<>();
					classMap.put("riskGroupList", GeneticDiseaseRiskLevelVo.class);
					resp.setGeneticDisease(JSONUtils.toBean(geneticDiseaseResp.getGeneticDiseaseJson(), GeneticDiseaseVo.class, classMap));
				}
			}
		}

		resp.setIssueDate(DateUtils.formatDate(dnaArchive.getProcessTime()));
		return resp;
	}
	
	public ExportDogMsgResponse scanExportMsgByDogKey(String key) {
		// 参数校验
		if (StringUtils.isBlank(key)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请求参数缺失!");
		}
		// 是否为出口犬只
		DogPedigreeCertifiedExport dogPedigreeCertifiedExport = dogPedigreeCertifiedExportService.getByPedigreeCertified(key);
		if (dogPedigreeCertifiedExport == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "扫描数据信息有误!");
		}
		ExportDogMsgResponse vo = new ExportDogMsgResponse();
		BeanUtil.copyProperties(vo, dogPedigreeCertifiedExport, "yyyy-MM-dd");
		vo.setGender("1".equals(vo.getGender())?"MALE":"FEMALE");
		vo.setColorFlag(dogPedigreeCertifiedExport.getColorFlagCode());
		vo.setDogBreedNameEn(dogPedigreeCertifiedExport.getBreedEnName());
		vo.setPedigreeCertifiedCode(dogPedigreeCertifiedExport.getPedigreeCertified());
		return vo;
	}
}