package com.cku.restful.v1.dog.model;

import java.io.Serializable;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
@ApiModel("DNA管理")
public class RestDnaBlood implements Serializable {

    private static final long serialVersionUID = 488842578278475421L;
    
	@ApiModelProperty("id")
    private String id;
    @ApiModelProperty("申请时间")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createDate;
    @ApiModelProperty("血统证书号")
    private String pedigreeCertified;
    @ApiModelProperty("留存方式0血样  1位点")
    private String type;
    @ApiModelProperty("犬名")
    private String dogName;
    @ApiModelProperty("犬种")
    private String dogBreed;
    @ApiModelProperty("犬性别")
    private String dogGender;
    @ApiModelProperty("犬出生日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date dogBirthday;
    @ApiModelProperty("办理机构")
    private String orgName;
    @ApiModelProperty("办理机构id")
    private String orgId;
    @ApiModelProperty("会员")
    private String memberCode;
    @ApiModelProperty("出生纸号")
    private String birthCode;
    @ApiModelProperty("1可修改合作机构")
    private String isComplete = "0";
    @ApiModelProperty("可申请的方式 为0可以申请位点  为null不能办理")
    private String applyType;
    @ApiModelProperty("呼名")
    private String callName;
    @ApiModelProperty("跳转位置 0新添加 1购物车 2跳转到支付列表")
    private String skipDnaType;
    private String skipType;
    private String skipBloodType;
    @ApiModelProperty("是否口腔上皮细胞：0：否，1：是")
    private String isOEC;
    @ApiModelProperty("采样包编号")
	private String samplingCode;
    @ApiModelProperty("办理渠道：0 机构办理 1 自检")
    private String applyChannel;
    @ApiModelProperty("是否撤销 0 未撤销 1 已撤销")
    private String isCanceled;



}
