package com.cku.oa.sys.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.sys.entity.TaskLog;
import com.cku.oa.sys.service.TaskLogService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 计划任务执行日志Controller
 * @author zhuoHeng
 * @version 2017-03-31
 */
@Controller
@RequestMapping(value = "${adminPath}/tasklog/taskLog")
public class TaskLogController extends BaseController {

	@Autowired
	private TaskLogService taskLogService;
	
	@ModelAttribute
	public TaskLog get(@RequestParam(required=false) String id) {
		TaskLog entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = taskLogService.get(id);
		}
		if (entity == null){
			entity = new TaskLog();
		}
		return entity;
	}
	
	@RequiresPermissions("tasklog:taskLog:view")
	@RequestMapping(value = {"list", ""})
	public String list(TaskLog taskLog, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<TaskLog> page = taskLogService.findPage(new Page<TaskLog>(request, response), taskLog); 
		model.addAttribute("page", page);
		return "oa/sys/tasklog/taskLogList";
	}

	@RequiresPermissions("tasklog:taskLog:view")
	@RequestMapping(value = "form")
	public String form(TaskLog taskLog, Model model) {
		model.addAttribute("taskLog", taskLog);
		return "oa/sys/tasklog/taskLogForm";
	}

	@RequiresPermissions("tasklog:taskLog:edit")
	@RequestMapping(value = "save")
	public String save(TaskLog taskLog, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, taskLog)){
			return form(taskLog, model);
		}
		taskLogService.save(taskLog);
		addMessage(redirectAttributes, "保存计划任务执行日志成功");
		return "redirect:"+Global.getAdminPath()+"/tasklog/taskLog/?repage";
	}
	
	@RequiresPermissions("tasklog:taskLog:edit")
	@RequestMapping(value = "delete")
	public String delete(TaskLog taskLog, RedirectAttributes redirectAttributes) {
		taskLogService.delete(taskLog);
		addMessage(redirectAttributes, "删除计划任务执行日志成功");
		return "redirect:"+Global.getAdminPath()+"/tasklog/taskLog/?repage";
	}

}