package com.cku.oa.sys.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.sys.entity.SysOrgPrint;
import com.cku.oa.sys.service.SysOrgPrintService;

/**
 * 俱乐部打印重置Controller
 * @author cxt
 * @version 2017-10-24
 */
@Controller
@RequestMapping(value = "${adminPath}/sys/sysOrgPrint")
public class SysOrgPrintController extends BaseController {

	@Autowired
	private SysOrgPrintService sysOrgPrintService;
	
	@ModelAttribute
	public SysOrgPrint get(@RequestParam(required=false) String id) {
		SysOrgPrint entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = sysOrgPrintService.get(id);
		}
		if (entity == null){
			entity = new SysOrgPrint();
		}
		return entity;
	}
	
	@RequiresPermissions("sys:sysOrgPrint:view")
	@RequestMapping(value = {"list", ""})
	public String list(SysOrgPrint sysOrgPrint, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<SysOrgPrint> page = sysOrgPrintService.findPage(new Page<SysOrgPrint>(request, response), sysOrgPrint); 
		model.addAttribute("page", page);
		return "oa/sys/sysOrgPrintList";
	}

	@RequiresPermissions("sys:sysOrgPrint:view")
	@RequestMapping(value = "form")
	public String form(SysOrgPrint sysOrgPrint, Model model) {
		model.addAttribute("sysOrgPrint", sysOrgPrint);
		return "oa/sys/sysOrgPrintForm";
	}

	@RequiresPermissions("sys:sysOrgPrint:edit")
	@RequestMapping(value = "save")
	public String save(SysOrgPrint sysOrgPrint, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, sysOrgPrint)){
			return form(sysOrgPrint, model);
		}
		sysOrgPrintService.save(sysOrgPrint);
		addMessage(redirectAttributes, "保存俱乐部打印重置成功");
		return "redirect:"+Global.getAdminPath()+"/sys/sysOrgPrint/?repage";
	}
	
	@RequiresPermissions("sys:sysOrgPrint:edit")
	@RequestMapping(value = "delete")
	public String delete(SysOrgPrint sysOrgPrint, RedirectAttributes redirectAttributes) {
		sysOrgPrintService.delete(sysOrgPrint);
		addMessage(redirectAttributes, "删除俱乐部打印重置成功");
		return "redirect:"+Global.getAdminPath()+"/sys/sysOrgPrint/?repage";
	}

}