package com.cku.oa.statistics.strategy;

import com.cku.oa.finance.entity.PaymentOrderDetail;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.statistics.entity.SaPaymentDetail;
import com.cku.oa.statistics.service.SaPaymentDetailService;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;

public class MathStrategy implements InitSplitStrategy {
    private SaPaymentDetailService saPaymentDetailService;
    private HashMap<String,RelationShipEntity> relationShipMap;
    private HashMap<String,BigDecimal> chargingPriceMap;


    public MathStrategy(SaPaymentDetailService saPaymentDetailService,HashMap<String,RelationShipEntity> relationShipMap,HashMap<String,BigDecimal> chargingPriceMap) {
        this.saPaymentDetailService = saPaymentDetailService;
        this.relationShipMap =relationShipMap;
        this.chargingPriceMap = chargingPriceMap;
    }

    /**
     * 订单赛事处理
     * @param orderDetailList
     * @param id
     */
    @Override
    public void initSplitOrderDetail(List<PaymentOrderDetail> orderDetailList, String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        orderDetailList.forEach( r ->{
            int feeLong = new BigDecimal(r.getTotalPrice()).intValue();
            int num = Integer.parseInt(r.getNum() == null ? "1" : r.getNum());
            HashMap<String,Integer> countMap = new HashMap();
            countMap.put("280",0);
            countMap.put("380",0);
            if(splitShow(feeLong,num,countMap)){
                if(countMap.get("280")>0){
                    SaPaymentDetail saDetail280 = new SaPaymentDetail();
                    saDetail280.setPaymentNum(countMap.get("280"));
                    saDetail280.setMemberCode(r.getMemberCode());
                    saDetail280.setChargeDate(r.getAddTime());
                    saDetail280.setPrice("280");
                    saDetail280.setRunningNumber(r.getOrderCode());
                    saDetail280.setPaymentMoney((280*countMap.get("280"))+"");
                    saDetail280.setType(PAYMENT_TYPE_CAB);
                    saDetail280.setSourceCharge(id);
                    saDetail280.setChargeItemId("cab2192");
                    saDetail280.setOrderId(r.getId());
                    saDetail280.setPaymentTime((r.getPaymentOrder()!=null &&r.getPaymentOrder().getPaymentTime()!=null)?r.getPaymentOrder().getPaymentTime():r.getAddTime());
                    saDetail280.setDeptId(relationShipEntity.getDept());
                    saPaymentDetailService.save(saDetail280);
                }

                if(countMap.get("380")>0){
                    SaPaymentDetail saDetail380 = new SaPaymentDetail();
                    saDetail380.setPaymentNum(countMap.get("380"));
                    saDetail380.setMemberCode(r.getMemberCode());
                    saDetail380.setChargeDate(r.getAddTime());
                    saDetail380.setPrice("380");
                    saDetail380.setRunningNumber(r.getOrderCode());
                    saDetail380.setPaymentMoney((380*countMap.get("380"))+"");
                    saDetail380.setType(PAYMENT_TYPE_CAB);
                    saDetail380.setSourceCharge(id);
                    saDetail380.setChargeItemId("cab2191");
                    saDetail380.setOrderId(r.getId());
                    saDetail380.setPaymentTime((r.getPaymentOrder()!=null &&r.getPaymentOrder().getPaymentTime()!=null)?r.getPaymentOrder().getPaymentTime():r.getAddTime());
                    saDetail380.setDeptId(relationShipEntity.getDept());
                    saPaymentDetailService.save(saDetail380);
                }

            }else{

                SaPaymentDetail saDetail = new SaPaymentDetail();
                saDetail.setPaymentNum(Integer.parseInt(r.getNum()));
                saDetail.setMemberCode(r.getMemberCode());
                saDetail.setChargeDate(r.getAddTime());
                saDetail.setPrice(r.getPrice());
                saDetail.setRunningNumber(r.getOrderCode());
                saDetail.setPaymentMoney(r.getTotalPrice());
                saDetail.setType(PAYMENT_TYPE_CAB);
                saDetail.setSourceCharge(id);
                saDetail.setChargeItemId("cab2193");
                saDetail.setOrderId(r.getId());

                saDetail.setPaymentTime((r.getPaymentOrder()!=null &&r.getPaymentOrder().getPaymentTime()!=null)?r.getPaymentOrder().getPaymentTime():r.getAddTime());
                saDetail.setDeptId(relationShipEntity.getDept());
                saPaymentDetailService.save(saDetail);
            };



        });
    }

    /**
     * 直接扣费处理
     * @param recordList
     * @param id
     */
    @Override
    public void initSplitRecord(List<PaymentRecord> recordList, String id) {
        RelationShipEntity relationShipEntity = relationShipMap.get(id);
        recordList.forEach( r ->{
            int feeLong = new BigDecimal(r.getPaymentAmount()).intValue();
            int num = r.getChargingItemNum();
            HashMap<String,Integer> countMap = new HashMap();
            countMap.put("280",0);
            countMap.put("380",0);
            if(splitShow(feeLong,num,countMap)){
                if(countMap.get("280")>0){
                    SaPaymentDetail saDetail280 = new SaPaymentDetail();
                    saDetail280.setPaymentNum(countMap.get("280"));
                    saDetail280.setMemberCode(r.getMemberCode());
                    saDetail280.setChargeDate(r.getCreateDate());
                    saDetail280.setPrice("280");
                    saDetail280.setRunningNumber(r.getRunningNumber());
                    saDetail280.setPaymentMoney((280*countMap.get("280"))+"");
                    saDetail280.setType(PAYMENT_TYPE_CAB);
                    saDetail280.setSourceCharge(id);
                    saDetail280.setChargeItemId("cab2192");
                    saDetail280.setRecordId(r.getId());
                    saDetail280.setPaymentTime(r.getPaymentTime());
                    saDetail280.setDeptId(relationShipEntity.getDept());
                    saPaymentDetailService.save(saDetail280);
                }
                if(countMap.get("380")>0){
                    SaPaymentDetail saDetail380 = new SaPaymentDetail();
                    saDetail380.setPaymentNum(countMap.get("380"));
                    saDetail380.setMemberCode(r.getMemberCode());
                    saDetail380.setChargeDate(r.getCreateDate());
                    saDetail380.setPrice("380");
                    saDetail380.setRunningNumber(r.getRunningNumber());
                    saDetail380.setPaymentMoney((380*countMap.get("380"))+"");
                    saDetail380.setType(PAYMENT_TYPE_CAB);
                    saDetail380.setSourceCharge(id);
                    saDetail380.setChargeItemId("cab2191");
                    saDetail380.setRecordId(r.getId());
                    saDetail380.setPaymentTime(r.getPaymentTime());
                    saDetail380.setDeptId(relationShipEntity.getDept());
                    saPaymentDetailService.save(saDetail380);
                }

            }else{
                SaPaymentDetail saDetail = new SaPaymentDetail();
                saDetail.setPaymentNum(r.getChargingItemNum());
                saDetail.setMemberCode(r.getMemberCode());
                saDetail.setChargeDate(r.getCreateDate());
                saDetail.setPrice(r.getPrice());
                saDetail.setRunningNumber(r.getRunningNumber());
                saDetail.setPaymentMoney(r.getPaymentAmount());
                saDetail.setType(PAYMENT_TYPE_CAB);
                saDetail.setSourceCharge(id);
                saDetail.setChargeItemId("cab2193");
                saDetail.setRecordId(r.getId());
                saDetail.setPaymentTime(r.getPaymentTime());
                saDetail.setDeptId(relationShipEntity.getDept());
                saPaymentDetailService.save(saDetail);
            };



        });
    }

    private boolean splitShow(int feeLong,int num,HashMap<String,Integer> countMap ) {
        boolean boo = true;
        if(feeLong!=0&&feeLong%280==0){
            countMap.put("280",feeLong/280);
        }else
        if(feeLong!=0&&feeLong%380==0){
            countMap.put("380",feeLong/380);
        }else
        if(feeLong!=0&&feeLong%660==0){
            countMap.put("280",feeLong/660);
            countMap.put("380",feeLong/660);
        }else
        if(feeLong!=0&&feeLong%940==0){
            countMap.put("280",2*feeLong/940);
            countMap.put("380",feeLong/940);
        }else
        if(feeLong!=0&&feeLong%1040==0){
            countMap.put("280",feeLong/1040);
            countMap.put("380",2*feeLong/1040);
        }else
        if(feeLong!=0&&feeLong%1220==0){
            countMap.put("280",3*feeLong/1220);
            countMap.put("380",feeLong/1220);
        }else
        if(feeLong!=0&&feeLong%1420==0){
            countMap.put("280",feeLong/1420);
            countMap.put("380",3*feeLong/1420);
        }else
        if(feeLong!=0&&feeLong%1500==0){
            countMap.put("280",4*feeLong/1500);
            countMap.put("380",feeLong/1500);
        }else
        if(feeLong!=0&&feeLong%1800==0){
            countMap.put("280",feeLong/1800);
            countMap.put("380",4*feeLong/1800);
        }else{
            boo = false;
            System.out.println("-------------------------------------------------------------------------------------------------------------");
        }
        return boo;
    }
}
