package com.cku.oa.show.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.constant.Constants;
import com.cku.oa.show.dao.ShowJudgeCertificateDao;
import com.cku.oa.show.entity.ShowJudgeCertificate;
import com.cku.oa.show.entity.ShowJudgeCertificateDogGroup;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.Collections3;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 赛事裁判证书Service
 *
 * @author lgl
 * @version 2018-09-20
 */
@Service
@Transactional(readOnly = true)
public class ShowJudgeCertificateService extends CrudService<ShowJudgeCertificateDao, ShowJudgeCertificate> {

    @Autowired
    private ShowJudgeCertificateDogGroupService showJudgeCertificateDogGroupService;

    public ShowJudgeCertificate get(String id) {
        return super.get(id);
    }

    public List<ShowJudgeCertificate> findList(ShowJudgeCertificate showJudgeCertificate) {
        return super.findList(showJudgeCertificate);
    }

    public Page<ShowJudgeCertificate> findPage(Page<ShowJudgeCertificate> page, ShowJudgeCertificate showJudgeCertificate) {
        return super.findPage(page, showJudgeCertificate);
    }

    @Transactional(readOnly = false)
    public void save(ShowJudgeCertificate showJudgeCertificate) {
        validateInfo(showJudgeCertificate);
        if ("3".equals(showJudgeCertificate.getCertificateType())) {
            validateShowJudgeCertificateDogGroupInfo(showJudgeCertificate.getShowJudgeCertificateDogGroupList());
            saveShowJudgeCertificateDogGroupInfo(showJudgeCertificate);
        }
        super.save(showJudgeCertificate);
    }

    private void saveShowJudgeCertificateDogGroupInfo(ShowJudgeCertificate showJudgeCertificate) {
        List<ShowJudgeCertificateDogGroup> showJudgeCertificateDogGroupList = showJudgeCertificate.getShowJudgeCertificateDogGroupList();
        if(Collections3.isEmpty(showJudgeCertificateDogGroupList)){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审查员类型为犬种组时犬种组信息不能为空！！");
        }
        for (ShowJudgeCertificateDogGroup showJudgeCertificateDogGroup : showJudgeCertificateDogGroupList){
            showJudgeCertificateDogGroup.setJudgeCertificateMian(showJudgeCertificate.getJudgeCertificate());
            showJudgeCertificateDogGroupService.save(showJudgeCertificateDogGroup);
        }
    }

    private void validateShowJudgeCertificateDogGroupInfo(List<ShowJudgeCertificateDogGroup> showJudgeCertificateDogGroupList) {
        if(Collections3.isEmpty(showJudgeCertificateDogGroupList)){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审查员类型为犬种组时犬种组信息不能为空！！");
        }
        ShowJudgeCertificateDogGroup showJudgeCertificateDogGroup = showJudgeCertificateDogGroupList.get(0);
        if (StringUtils.isBlank(showJudgeCertificateDogGroup.getJudgeCertificate())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种组证书号不能为空！！");
        }
        if (StringUtils.isBlank(showJudgeCertificateDogGroup.getGroupNo())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "通过犬种组不能为空！！");
        }
        if(showJudgeCertificateDogGroup.getSignDate() == null){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "签发日期不能为空！！");
        }
        if(showJudgeCertificateDogGroup.getEndDate() == null){
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "有效日期不能为空！！");
        }
        if (StringUtils.isBlank(showJudgeCertificateDogGroup.getVisibleFlag())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "是否可见不能为空！！");
        }
        if (!"1".equals(showJudgeCertificateDogGroup.getVisibleFlag()) && !"0".equals(showJudgeCertificateDogGroup.getVisibleFlag())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "是否可见只能为可见或不可见！！");
        }
    }

    private void validateInfo(ShowJudgeCertificate showJudgeCertificate) {
        if (StringUtils.isBlank(showJudgeCertificate.getJudgeCertificate())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "裁判证书号不能为空！！");
        }
        if (StringUtils.isBlank(showJudgeCertificate.getCertificateType())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审查员类型不能为空！！");
        }
        if (DictUtils.getDictLabel(showJudgeCertificate.getCertificateType(), "certificate_type", null) == null) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审查员类型有误");
        }
        if (StringUtils.isBlank(showJudgeCertificate.getVisibleFlag())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "是否可见不能为空！！");
        }
        if (!"1".equals(showJudgeCertificate.getVisibleFlag()) && !"0".equals(showJudgeCertificate.getVisibleFlag())) {
            throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "是否可见只能为可见或不可见！！");
        }
        if ("4".equals(showJudgeCertificate.getCertificateType())) {
            if(StringUtils.isBlank(showJudgeCertificate.getDogBreedCode())){
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审查员类型为单犬种时犬种代码不能为空！！");
            }
        }
        if ("3".equals(showJudgeCertificate.getCertificateType())) {
            if(Collections3.isEmpty(showJudgeCertificate.getShowJudgeCertificateDogGroupList())){
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审查员类型为犬种组时犬种组信息不能为空！！");
            }
        }else{
            if(!Collections3.isEmpty(showJudgeCertificate.getShowJudgeCertificateDogGroupList())){
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "审查员类型是非犬种组时犬种组信息为空！！");
            }
        }
        if (!"3".equals(showJudgeCertificate.getCertificateType())) {
            if(showJudgeCertificate.getSignDate() == null){
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "签发日期不能为空！！");
            }
            if(showJudgeCertificate.getEndDate() == null){
                throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "有效日期不能为空！！");
            }
        }
    }

    @Transactional(readOnly = false)
    public void delete(ShowJudgeCertificate showJudgeCertificate) {
        super.delete(showJudgeCertificate);
    }

}