package com.cku.oa.shop.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.shop.entity.ShopPayRecord;
import com.cku.oa.shop.dao.ShopPayRecordDao;

/**
 * 商城充值流水Service
 * @author lyy
 * @version 2016-08-23
 */
@Service
@Transactional(readOnly = true)
public class ShopPayRecordService extends CrudService<ShopPayRecordDao, ShopPayRecord> {

	public ShopPayRecord get(String id) {
		return super.get(id);
	}
	
	public List<ShopPayRecord> findList(ShopPayRecord shopPayRecord) {
		return super.findList(shopPayRecord);
	}
	
	public Page<ShopPayRecord> findPage(Page<ShopPayRecord> page, ShopPayRecord shopPayRecord) {
		return super.findPage(page, shopPayRecord);
	}
	
	@Transactional(readOnly = false)
	public void save(ShopPayRecord shopPayRecord) {
		super.save(shopPayRecord);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShopPayRecord shopPayRecord) {
		super.delete(shopPayRecord);
	}
	
}